<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Shifts;
use frontend\models\ShiftsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\models\Ledger;
use frontend\models\Shops;
use backend\models\User;

/**
 * ShiftsController implements the CRUD actions for Shifts model.
 */
class ShiftsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Shifts models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ShiftsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Shifts model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Shifts model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        

        // echo Yii::$app->user->identity->role; die;
        if(Yii::$app->user->identity->role!='Shop Manager' && Yii::$app->user->identity->role!='Client Admin')
        {
            die('You are not authorized to do this');
        }


        $model = new Shifts();          



        if ($model->load(Yii::$app->request->post())) {
           $name=User::findOne($model->shift_name)->username;


            $you=Shifts::find()->where(['shift_name'=>$model->shift_name,'status'=>1,'cid'=>Yii::$app->user->identity->cid,'shop_id'=>Yii::$app->user->identity->shop_id])->one();
            
            if($you!=null)
            {
                die('You still have an open shift for this user. Please close that shift before opening another');
            }


             $model->save();

            return $this->redirect(['done','name'=>$name]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Shifts model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Shifts model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        die('You are not allowd to do this');
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Shifts model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Shifts the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Shifts::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionShifts()
    {
        if(Yii::$app->user->identity->role!='Shop Manager' && Yii::$app->user->identity->role!='Client Admin')
        {
            die('You are not authorized to do this');
        }

        $active=Shifts::find()->where(['status'=>1,'cid'=>Yii::$app->user->identity->cid,'shop_id'=>Yii::$app->user->identity->shop_id])->all();
        return $this->render('actives',['active'=>$active]);
    }

    public function actionClose($id,$stamp,$shift_id)
    {
        if(Yii::$app->user->identity->role!='Shop Manager' && Yii::$app->user->identity->role!='Client Admin')
        {
            die('You are not authorized to do this');
        }

        $rec=Shifts::findOne($id);
        $fame=\frontend\models\User::findOne($rec->shift_name);

        $shop_type=Shops::findOne($fame->shop_id);

        $transaction = Yii::$app->db->beginTransaction();
                try {

        if($shop_type->shop_type!=3){
           


                
                    $rec->status=2;
                    if(!$rec->save())
                    {
                        throw new \Exception('could not save to shift');
                    }

                    $record=Ledger::find()->where(['shift'=>$shift_id,'tlink'=>null,'stamp'=>$stamp,'staff'=>$rec->shift_name])->sum('credit');
                    $records=Ledger::find()->where(['shift'=>$shift_id,'tlink'=>null,'stamp'=>$stamp,'staff'=>$rec->shift_name])->all();
                    $single=Ledger::find()->where(['shift'=>$shift_id,'tlink'=>null,'stamp'=>$stamp,'staff'=>$rec->shift_name])->one();

                    $records2=Ledger::find()->where(['shift'=>$shift_id,'tlink'=>null,'stamp'=>$stamp,'staff'=>$rec->shift_name])->groupBy('transaction_id')->all();

                    // add up details
                    // var_dump($records); die;

                    $two=array();                   
                    $new=array();
                    $tree=array();

                    if($record!=null)
                    {
                    

                    foreach($records2 as $recs)
                    {
                       
                        // array_push($two, json_decode($recs->details,true));                        
                        
                        $tree[]=json_decode($recs->details,true);
                    }
              

                    for($i=0; $i<count($tree); $i++)
                    {
                        $new=array_merge($new,$tree[$i]);
                        
                    }

                    // close add up details

                    $single->credit=$record;
                    $single->details=json_encode($new);
                    $single->fin=2;
                    if(!$single->save())
                    {
                       throw new \Exception('could not save to shift');
                        // var_dump($single->getErrors()); die;
                    }

                    //foreach($records as $rec)
                    if(count($records)>1)
                    {
                        for($x=1; $x<count($records); $x++)
                        {
                            $records[$x]->credit=0;
                            $records[$x]->transaction_id="0";
                            $records[$x]->amount_paid=0;
                            $records[$x]->vendor="0";
                            $records[$x]->staff=0;
                            $records[$x]->shift=0;
                            // $records[$x]->cid=0;
                            $records[$x]->details='';
                            if(!$records[$x]->save())
                        {
                           throw new \Exception('could not save to shift');
                            // var_dump($records[$x]->getErrors()); die;
                        }
                        }
                    }

                }





                    
                }else{
                    
                    $rec->status=2;
                    if(!$rec->save())
                    {
                        // var_dump($rec->getErrors()); die;
                        throw new \Exception('could not save to ledger');
                    }

                    $records3=Ledger::find()->where(['shift'=>$shift_id,'stamp'=>$stamp,'staff'=>$rec->shift_name])->all();
                    foreach($records3 as $rec3)
                    {
                        $rec3->fin=2;
                        if(!$rec3->save())
                        {
                            throw new \Exception('could not save to ledger');
                        }
                    }
            }

                    $transaction->commit();
                   

                    } catch (\Exception $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    } catch (\Throwable $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    }
        return $this->redirect(['shifts']);
                   
    }


    public function actionDone($name)
    {
        return $this->render('done',['name'=>$name]);
    }
}
