<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "attendance".
 *
 * @property int $id
 * @property int $cid
 * @property int $client_account
 * @property int $staff
 * @property string $start
 * @property string $stop
 * @property string $ddate
 * @property int $work_hours
 * @property int $location
 * @property int $department
 * @property double $shift
 * @property int $status
 * @property int $starter
 * @property int $stopper
 */
class Attendance extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'attendance';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'client_account', 'staff', 'start', 'stop', 'ddate', 'work_hours', 'location', 'department', 'shift'], 'required'],
            [['cid', 'client_account', 'staff', 'work_hours', 'location', 'department', 'status','starter','stopper'], 'integer'],
            [['shift'], 'number'],
            [['start', 'stop'], 'string', 'max' => 6],
            [['ddate'], 'string', 'max' => 17],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'client_account' => 'Client Account',
            'staff' => 'Staff',
            'start' => 'Start',
            'stop' => 'Stop',
            'ddate' => 'Ddate',
            'work_hours' => 'Work Hours',
            'location' => 'Location',
            'department' => 'Department',
            'shift' => 'Shift',
            'status' => 'Status',
            'starter' => 'Clocked in by',
            'stopper' => 'Attendance stopped by'
        ];
    }

    /**
     * {@inheritdoc}
     * @return AttendanceQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AttendanceQuery(get_called_class());
    }
}
