<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "client_units".
 *
 * @property int $id
 * @property int $cid
 * @property int $client_account
 * @property string $unit_name
 * @property string $unit_address
 * @property string $created_at
 */
class ClientUnits extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'client_units';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'client_account', 'unit_address', 'created_at'], 'required'],
            [['cid', 'client_account'], 'integer'],
            [['unit_address'], 'string'],
            [['unit_name'], 'string', 'max' => 255],
            [['created_at'], 'string', 'max' => 17],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'client_account' => 'Client Account',
            'unit_name' => 'Unit Name',
            'unit_address' => 'Unit Address',
            'created_at' => 'Created At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return ClientUnitsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new ClientUnitsQuery(get_called_class());
    }
}
