<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "designate".
 *
 * @property int $id
 * @property int $cid
 * @property string $designation_name
 */
class Designate extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'designate';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'designation_name'], 'required'],
            [['cid'], 'integer'],
            [['designation_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'designation_name' => 'Designation Name',
        ];
    }

    /**
     * {@inheritdoc}
     * @return DesignateQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new DesignateQuery(get_called_class());
    }
}
