<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "employment_type".
 *
 * @property int $id
 * @property string $name
 */
class EmploymentType extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'employment_type';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
        ];
    }

    /**
     * {@inheritdoc}
     * @return EmploymentTypeQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new EmploymentTypeQuery(get_called_class());
    }
}
