<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "locations".
 *
 * @property int $id
 * @property int $cid
 * @property string $location_name
 */
class Locations extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'locations';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'location_name'], 'required'],
            [['cid'], 'integer'],
            [['location_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'location_name' => 'Location Name',
        ];
    }

    /**
     * {@inheritdoc}
     * @return LocationsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new LocationsQuery(get_called_class());
    }
}
