<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "monthly_deductions".
 *
 * @property int $id
 * @property int $cid
 * @property int $staff_id
 * @property string $payments
 */
class MonthlyDeductions extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'monthly_deductions';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'staff_id', 'payments'], 'required'],
            [['cid', 'staff_id'], 'integer'],
            [['payments'], 'string'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'staff_id' => 'Staff ID',
            'payments' => 'Payments',
        ];
    }

    /**
     * {@inheritdoc}
     * @return MonthlyDeductionsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new MonthlyDeductionsQuery(get_called_class());
    }
}
