<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "nationality".
 *
 * @property int $id
 * @property string $nation
 */
class Nationality extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'nationality';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nation'], 'required'],
            [['nation'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nation' => 'Nation',
        ];
    }

    /**
     * {@inheritdoc}
     * @return NationalityQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new NationalityQuery(get_called_class());
    }
}
