<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "payment_details".
 *
 * @property int $id
 * @property int $cid
 * @property int $staff_id
 * @property int $allowance
 * @property double $amount
 */
class PaymentDetails extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'payment_details';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'staff_id', 'allowance', 'amount'], 'required'],
            [['cid', 'staff_id', 'allowance'], 'integer'],
            [['amount'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'staff_id' => 'Section ID',
            'allowance' => 'Allowance ID',
            'amount' => '%',
        ];
    }

    /**
     * {@inheritdoc}
     * @return PaymentDetailsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new PaymentDetailsQuery(get_called_class());
    }
}
