<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\models\Industries;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model backend\models\Clients */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="clients-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'client_name')->textInput(['rows' => 6]) ?>

    <?= $form->field($model, 'client_address')->textInput(['rows' => 6]) ?>
      <?= Html::activeDropDownList($model,'industry', ArrayHelper::map(Industries::find()->all(),'id','name'),['class'=>'form-control','prompt'=>'Select Industry','id'=>'industries']) ?>
    

    <?= $form->field($model, 'phone')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'website')->textInput(['maxlength' => true]) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
