<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\models\Clients;
use backend\models\Departments;
use backend\models\Designation;

/* @var $this yii\web\View */
/* @var $model backend\models\User */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Users', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id,'cid' => $cid], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
        <?= Html::a(ucwords(Clients::findOne($cid)->client_name),['/clients/view','id'=>$cid],['class'=>'btn btn-primary']) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'username',
            'role',
            'first_name',
            'last_name',            
             ['label'=>'Department', 'format'=>'raw', 'value'=>ucwords(Departments::findOne($model->department)->department_name)],
            ['label'=>'Designation', 'format'=>'raw', 'value'=>ucwords(Designation::findOne($model->position)->position)],
             'position_label',
            ['label'=>'Company Name', 'format'=>'raw', 'value'=>ucwords(Clients::findOne($model->cid)->client_name)],
       
            //'auth_key',
           // 'password_hash',
            //'password_reset_token',
            'email:email',
            'status',
            'shop_id',
            // 'created_at',
            // 'updated_at',
        ],
    ]) ?>

</div>
