<?php
use frontend\models\Customers;
use frontend\models\Taken;
use kartik\date\DatePicker;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
?>
<h1>Guests List</h1>

<div>
	<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['customers/houseg'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">Select Date</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>



<div>

<table class="table table-striped table-bordered">

<tr>
<th>Name</th>
<th>Amount</th>
<th>Checkout Date</th>
</tr>

<?php
$total=0;
foreach($houseg as $house)
{
	$total+=$house->amount_paid;
	?>

	<tr>
<td>
<?= ucwords(Customers::findOne($house->vendor)->name) ?>
</td>

<td>
<?= number_format($house->amount_paid,2) ?>
</td>

<td>
<?php $date=Taken::find()->where(['transaction_id'=>$house->transaction_id])->one()->departure; echo $date!=null ? date('jS F Y',strtotime($date)) : ''; ?>

</td>
	</tr>


	<?php
}

?>

<tr>
<th>
Total
</th>

<th>
<?= number_format($total,2) ?>
</th>

<th></th>
</tr>
</table>
</div>