<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use frontend\models\Categories;

/* @var $this yii\web\View */
/* @var $model frontend\models\Inventory */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="inventory-form">

    <?php $form = ActiveForm::begin(['options'=>['enctype'=>'multipart/form-data']]); ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <?= $form->field($model, 'barcode')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'description')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'quantity')->textInput() ?>

    <?= $form->field($model, 'supply_price')->textInput() ?>

    <?= $form->field($model, 'reorder')->textInput() ?>

    <?= $form->field($model, 'staff')->hiddenInput(['value'=>Yii::$app->user->identity->id])->label(false) ?>

    <?= $form->field($model, 'price')->textInput() ?>

    <?= $form->field($model, 'photo')->fileInput()->label('Product Image') ?>


     <?php echo $form->field($model, 'category')->dropDownList(
    ArrayHelper::map(Categories::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','category_name'),['prompt'=>'']) ?>


     <?php echo $form->field($model, 'countable')->dropDownList(
    [1=>'Deductable',2=>'Non-deductable'],['prompt'=>'']) ?>

   

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
