<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\models\Banks;
use yii\helpers\ArrayHelper;
use frontend\models\Customers;
use frontend\models\Inventory;
use frontend\models\Stores;

?>

<h1>Stock Movement (Sales Point)</h1>

<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['inventory/movement'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,

    ]
]); ?>

</div>



<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>

<div>
    <table class="table table-striped table-bordered">
        <tr>
            <td></td>
            <td>Item</td>
           
<td>BF</td>
<td>IN</td>
<td>TOTAL</td>
<td>OUT</td>
<td>UNIT PRICE</td>
<TD>SALE VALUE</TD>
<TD>BAL</TD>
<TH>STOCK VALUE</TH>
        </tr>
<?php $t=0;
$xv=1;
$sum=0;
$sum2=0;
if($records!=null){
    echo "<strong><font size:20>".date('jS F Y',strtotime($datef))." - ".date('jS F Y',strtotime($tof))."</font></strong><br><br>";
foreach($records as $rec)
{ 
   

  // $inv=Inventory::findOne($rec['item_id']);
    $inv=Inventory::find()->where(['item_id'=>$rec['item_id'],'cid'=>Yii::$app->user->identity->cid])->one();
    $tot=$rec['type']==12 ? $t+=$rec['transaction_quantity'] : $rec['type']==11 ? $t-=$rec['transaction_quantity'] : '';
// $tot=$his->type==12 ? $t+=$his->transaction_quantity : $t-=$his->transaction_quantity;

if($inv!=null){

    ?>
        <tr>
            <td><?= $xv ?></td>
            <td><?= ucwords($inv->name)."-".$rec['item_id'] ?></td>
      
<td><?= $rec['standing_quantity'] ?></td>
<td><?= !empty($rec['qin']) ? $rec['qin'] : '--' ?></td>
<td><?= $rak=$rec['standing_quantity']+$rec['qin'] ?></td>
<td><?= !empty($rec['qout']) ? $rec['qout'] : '--' ?></td>
<TD><?= number_format($inv->price,2); ?></TD>
<TD><?= number_format($inv->price*$rec['qout'],2) ?></TD>
<TD><?= $rak-$rec['qout'] ?></TD>
<?php $dif=$rak-$rec['qout']; $dif>0 ? $sum+=$dif*$inv->price : 0; ?>
<TD><?= $rak-$rec['qout']>0 ? number_format($dif*$inv->price,2) : 0 ?></TD>

        </tr>
    <?php
    $sum2+=$inv->price*$rec['qout'];
    $xv++;
}
}
}
?>
<tr>
<td colspan="7"></td>
<td><?= number_format($sum2,2) ?></td>
<td></td>
<td><?= number_format($sum,2) ?></td>
</tr>

</table>
</div>