<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

use yii\helpers\ArrayHelper;

?>
<h2>Journal Entries</h2>



<div id="holder">
	<h2>MORRIS ROYAL SECURITY</h2>
	<?php $record = \frontend\models\Ledger::find()->where(['transaction_id'=>$debit['transaction_id']])->one(); ?>
	<?php if($record->ptype==1){ ?>
		<h3 style="color: green;"><?= \frontend\models\Customers::findOne($record->vendor)->name; ?></h3>
		
	<?php }else{ ?>
		<h3 style="color: darkred;"><?= \frontend\models\Vendors::findOne($record->vendor)->name; ?></h3>
		<?php
	}
	?>
	<table class="table table-striped table-bordered">
		
		<tr>
			<th>DATE</th>
			<th>ACCOUNT</th>
			<th>DEBIT</th>
			<th>CREDIT</th>
			<th></th>
		</tr>		
			
			<tr>
			<th colspan="5">JOURNAL ENTRY NO: <?= $debit['transaction_id'] ?></th>
		</tr>
		<tr>
			<th colspan="5" style="text-transform: uppercase; text-align: right;"><?php  echo ucfirst($debit['details'])  ?></th>
		</tr>
	
		<tr>
			<td><?= date('jS F Y',strtotime($debit['created_at'])) ?></td>
			<td>
				<?= $debit['entry_type']==1 ?  $debit->accounts->title : '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-style:italic;">'.ucfirst($debit->accounts->title).'</span>'; ?>	
			</td>

			<td>
				<?=  $debit['entry_type'] == 1 ? number_format(abs($debit['amount']),2) : '' ?>
			</td>
			<td>
				<?=  $debit['entry_type'] == 2 ? number_format(abs($debit['amount']),2) : '' ?>
			</td>
			<th>
				<?=Html::a('Edit', ['/entry/update', 'id' => $debit['id']], ['class' => 'btn btn-primary narrow', 'id' => 'noshow', 'target' => '_blank'])?>
			</th>
		</tr>

		<!-- credit row -->

		<tr>
			<td><?= date('jS F Y',strtotime($credit['created_at'])) ?></td>
			<td>
				<?= $credit['entry_type']==1 ?  $credit->accounts->title : '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-style:italic;">'.ucfirst($credit->accounts->title).'</span>'; ?>	
			</td>

			<td>
				<?=  $credit['entry_type'] == 1 ? number_format(abs($credit['amount']),2) : '' ?>
			</td>
			<td>
				<?=  $credit['entry_type'] == 2 ? number_format(abs($credit['amount']),2) : '' ?>
			</td>
			<th>
				
			</th>
		</tr>


	</table>
	
</div>

<div>
    <?= Html::button('Print',['class'=>'btn btn-success','onclick'=>'print()']) ?>
</div>