<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\models\Banks;
use yii\helpers\ArrayHelper;
use frontend\models\Customers;
use frontend\models\Vendors;
use frontend\models\Requisitions; use frontend\models\Charts;
?>
<?php
$this->title = 'Ledgers';
$this->params['breadcrumbs'][] = $this->title;

?>

<h1>Reverse Transaction</h1>

<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['ledger/reverse'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,

    ]
]); ?>

</div>

<div class="well well-sm">
 <?= Html::textInput('tid',null,['class'=>'form-control','placeholder'=>'Enter Transaction ID','id'=>'tid','autocomplete'=>'off']) ?>
</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>


<div id="holder">

<table class="table table-striped table-bordered">
<tr>
	<th>Transaction ID</th>
    <th>Narration</th>
<th>Vendor</th>
<th>Amount Due</th>
<th>Amount Paid</th>
<th>Transaction Type</th>
<th>Balance</th>
<th></th>
<th></th>
<th></th>
</tr>

<?php
if($reverse!=null){
foreach($reverse as $rev)
{ 
	$querya="select sum(amount_paid) from ledger where tlink='".$rev['transaction_id']."'";
	$saj = Yii::$app->db->createCommand($querya)->queryScalar(); 

    $nar=Requisitions::find()->where(['transaction_id'=>$rev['transaction_id']])->one();

    $item7=json_decode($nar['requested_item'],true);
   
	?>
<tr id="<?= $rev['transaction_id']."ray" ?>">
<td><?= $rev['transaction_id'] ?></td>
<td><?= !empty($item7[0]['narration']) ? ucfirst($item7[0]['narration']) : 'Not Set' ?></td>
<td id="<?= $rev['transaction_id']."name" ?>"><?= $rev['ptype']==1 ? ucwords(Customers::findOne($rev['vendor'])->name) : ucwords(Vendors::findOne($rev['vendor'])->name) ?></td>
<td><?= $rev['ptype']==1 ? $rev['credit'] : $rev['debit'] ?></td>
<td><?= $rev['amount_paid']+$saj ?></td>
<td><?= $rev['ptype']==1 ? 'Sales Transaction' : 'Expenditure Transaction' ?></td>
<td><?= $rev['ptype']==1 ? $rev['credit']-$rev['amount_paid']-$saj : $rev['debit']-$rev['amount_paid']-$saj ?></td>
<td id="noshow"><?php if(Yii::$app->user->identity->role=='accounts'){ ?>
    
    <?= Html::button('Reverse',['onclick'=>'do_rev('.$rev['transaction_id'].','.$rev['id'].')','class'=>'btn btn-danger form-control', 'style'=>'']) ?>
    <?php } ?></td>
<td><?php if(Yii::$app->user->identity->role=='accounts' && $rev['ptype']==1){ ?><?= Html::button('Add Discount',['onclick'=>'disc('.$rev['transaction_id'].','.$rev['debit'].','.$rev['amount_paid'].','.$rev['ptype'].','.$rev['credit'].')','class'=>'btn btn-primary form-control', 'style'=>'']) ?><?php } ?></td>
<td id="<?= $rev['transaction_id']."mark" ?>"><?= $rev['open']==1 ? "Marked for Reversal" : " " ?><?php echo Html::img('@web/loaders/loader11.gif', ['class' => 'pull-center img-responsive','style'=>'display:none','id'=>$rev['transaction_id']."load"]); ?></td>
</tr>
	<?php
}		
}
?>


</table>
</div>

<div>
<?= Html::button('Print Document',['class'=>'btn btn-primary','onclick'=>'print()','style'=>'']) ?>
</div>

<div id="myModal3" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Enter discount amount in text field below</h4>
      </div>
      <div class="modal-body">
        <?php $form = ActiveForm::begin(); ?>   
    

    <table class="table table-striped table-bordered">
        <tr>
   <td>Invoice/Voucher Value: </td>
<td id="owed"></td>
     </tr>

     <td>Customer / Vendor: </td>
<td id="name2"></td>
     </tr>
     
</table>
     <div class="form-group">
         <?= Html::hiddenInput('rid',null,['class'=>'form-control','rows'=>3,'cols'=>30,'id'=>'rid','placeholder'=>'']) ?>
     </div>    


    <div class="form-group">
         <?= Html::textInput('amount',null,['class'=>'form-control','rows'=>3,'cols'=>30,'id'=>'amount','placeholder'=>'Enter Amount']) ?>
     </div>

  <div class="form-group">
          <?= Html::dropDownList('entry_type',null, ['1'=>'Debit'],['class'=>'form-control','id'=>'entry_type']) ?>
     </div>

      <div class="form-group">
         <?= Html::textInput('dcode',null,['class'=>'form-control','rows'=>3,'cols'=>30,'id'=>'dcode','placeholder'=>'','onkeyup'=>'getcode23("1","chart_account","dcode")','style'=>'width:50%; display:inline;']) ?>
     <input type="button" value="Get Account Name" class="btn btn-success" onclick="getcode('dcode','chart_account')">
   </div>

     <div class="form-group">
          <?= Html::dropDownList('chart_account',null, ArrayHelper::map(Charts::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','title'),['class'=>'form-control','prompt'=>'--- Choose Account','id'=>'chart_account']) ?>
     </div>

       <div class="form-group">
          <?= Html::dropDownList('entry_type2',null, ['2'=>'Credit'],['class'=>'form-control','id'=>'entry_type2']) ?>
     </div>
  

    <div class="form-group">
         <?= Html::textInput('dcode2',null,['class'=>'form-control','rows'=>3,'cols'=>30,'id'=>'dcode2','placeholder'=>'','onkeyup'=>'getcode24("2","chart_account2","dcode2")','style'=>'width:50%; display:inline;']) ?>
     <input type="button" value="Get Account Name" class="btn btn-success" onclick="getcode('dcode2','chart_account2')">
   </div>

     <div class="form-group">
          <?= Html::dropDownList('chart_account2',null, ArrayHelper::map(Charts::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','title'),['class'=>'form-control','prompt'=>'--- Choose Account','id'=>'chart_account2']) ?>
     </div> 
      
         <div class="form-group">
        <?= Html::button('Save Discount', ['class' => 'btn btn-primary','onclick'=>'push_discount()']) ?>
    </div>

    <?php ActiveForm::end(); ?>
      </div>
      <div class="modal-footer">
        <button type="button" id="bait" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>