<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\models\Banks;
use yii\helpers\ArrayHelper;
use frontend\models\Customers;
use frontend\models\Stores;

?>

<h1>Stock Movement</h1>

<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['stores/movement'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,

    ]
]); ?>

</div>



<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>

<div>
    <table class="table table-striped table-bordered">
        <tr>
            <td>Item</td>
           
<td>BF</td>
<td>IN</td>

<td>TOTAL</td>
<td>OUT</td>
<TD>BAL</TD>
<th>CP</th>
<th>VALUE</th>
        </tr>
<?php $t=0;
if($records!=null){
    echo "<strong><font size:20>".date('jS F Y',strtotime($datef))." - ".date('jS F Y',strtotime($tof))."</font></strong><br><br>";
foreach($records as $rec)
{ 
   $price=Stores::findOne($rec['item_id'])->cost_price;
    $tot=$rec['type']==12 ? $t+=$rec['transaction_quantity'] : $rec['type']==11 ? $t-=$rec['transaction_quantity'] : '';
// $tot=$his->type==12 ? $t+=$his->transaction_quantity : $t-=$his->transaction_quantity;

    ?>
        <tr>
            <td><?= ucwords(Stores::findOne($rec['item_id'])->name) ?></td>
      
<td><?= $rec['standing_quantity'] ?></td>
<td><?= !empty($rec['qin']) ? $rec['qin'] : '--' ?></td>

<td><?= $rak=$rec['standing_quantity']+$rec['qin'] ?></td>
<td><?= !empty($rec['qout']) ? $rec['qout'] : '--' ?></td>
<TD><?= $rak-$rec['qout'] ?></TD>
<td><?= number_format($price,2) ?></td>
<td><?= number_format($price*($rak-$rec['qout']),2) ?></td>
        </tr>
    <?php
}
}
?>


</table>
</div>