<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

use kartik\date\DatePicker;
use frontend\models\Requisitions;
use yii\helpers\ArrayHelper;
use backend\models\TaskType;

use backend\models\Departments;
use backend\models\User;
use backend\models\Workflow;
?>


<h1>Search Production</h1>


<div>
<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['transaction/search'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd'
    ]
]); ?>

</div>


  <div class="form-group">
      <?= Html::submitButton('Search',['class'=>'btn btn-success','id'=>'button','name'=>'Initialize','value'=>'Initialize']) ?>
  </div>

  <?php ActiveForm::end(); ?>
</div>


<div>
  <table class="table table-bordered table-striped">
    <tr style="font-weight:bold;"><td>Production Date</td><td>Product</td></tr>
<?php
if($results!=null)
{
  foreach($results as $result){
	?>

	<tr><td><?= date('jS F Y',strtotime($result['created_at'])) ?></td><td>
<?= Html::a(ucwords($result['product']),['/transaction/dock_details','id'=>$result['id']],[]) ?>
  </td></tr>




	<?php
}
}
?>
</table>
</div>