<?php


use yii\helpers\Html;
use yii\widgets\ActiveForm;

use backend\models\User;
use frontend\models\Stores;
use yii\helpers\ArrayHelper;

?>
<h1>User Ledger</h1>
<div class="form-group">
You can search with user field to view their personal ledger or use the item dropdown to find location for particular item but do not use both
</div>

<div>
<?php $form = ActiveForm::begin(['action'=>Yii::$app->urlManager->createUrl('transaction/uledger'),'options'=>['method'=>'post']]); ?>

<div class="form-group">

  <?= Html::dropDownList('user',null, ArrayHelper::map(User::find()->where(['cid'=>Yii::$app->user->identity->cid])->orderBy(['last_name'=>SORT_ASC])->all(),'id','label2'),['class'=>'form-control','prompt'=>'View Particular Users Ledger','id'=>'']) ?>
 </div>

 <div class="form-group">

  <?= Html::dropDownList('item',null, ArrayHelper::map(Stores::find()->where(['cid'=>Yii::$app->user->identity->cid])->orderBy(['name'=>SORT_ASC])->all(),'id','name'),['class'=>'form-control','prompt'=>'Find which users have an item','id'=>'']) ?>
 </div>

  <div class="form-group">
        <?= Html::submitButton('Get Records', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<?php if($rows!=null){ ?>
<div>

<table class="table table-striped table-bordered">

<tr style="font-weight:bold;">
	<td>Staff Name</td>
<td>Item Name</td>
<td>Quantity</td>
</tr>

<?php
foreach($rows as $row)
{
	?>

<tr>
	<td><?= ucwords(User::findOne($row['reciever_id'])->last_name) ?></td>
<td><?= $row['item_name'] ?></td>
<td><?= $row['quantity'] ?></td>
</tr>

	<?php
}

?>


</table>


</div>

<?php }else{
	echo "No records found";
} ?>