<?php

namespace backend\controllers;

use Yii;
use backend\models\Tasks;
use backend\models\SearchTasks;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\Clients;
use backend\models\Workflow;
use frontend\models\Requisitions;
use backend\models\User;
use yii\filters\AccessControl;
use backend\filters\AccessRule1;
/**
 * TaskController implements the CRUD actions for Tasks model.
 */
class TaskController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
            'class' => AccessControl::className(),
            'ruleConfig' => [
                    'class' => AccessRule1::className(),
                ],
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','create','update','findModel','viewtasks','loadflow',
                    'clearflow','clearnotice','show_instruments','show_status','addnotice'],
                    'roles' => ['@'],
                ],
                [
                    'allow' => true,
                    'actions' => ['delete'],
                    'roles' => ['Client Admin'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Tasks models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SearchTasks();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Tasks model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Tasks model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($id)
    {
        $model = new Tasks();

        if ($model->load(Yii::$app->request->post())) {            

            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        $name=Clients::findOne($id)->client_name; 
        return $this->render('create', [
            'model' => $model,
            'id'=>$id,
            'name'=>$name
        ]);
    }

    /**
     * Updates an existing Tasks model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {             
            
            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Tasks model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Tasks model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tasks the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Tasks::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionViewtasks($id)
    {
        $tasks=Tasks::find()->where(['cid'=>$id])->all();
        $name=Clients::findOne($id)->client_name;
        $model = new Tasks();
        return $this->render('viewtasks',[
            'tasks'=>$tasks,
            'id'=>$id,
            'name'=>$name,
            'model'=>$model]);
    }

    public function actionLoadflow()
    {
        // ob_start();
        $show='';
        $sent_flow=Yii::$app->request->post('dflow');
        $selected_int=Yii::$app->request->post('selected_int');

        $cid=Yii::$app->request->post('cid');
        $tid=Yii::$app->request->post('tid');

        $instrument_text=Yii::$app->request->post('instrument_text');
        $instrument_id=Yii::$app->request->post('instrument_id');

        $status_id=Yii::$app->request->post('status_id');
        $status_text=Yii::$app->request->post('status_text');
       

        $flow='';
        $break='';
        $break.="<br>";
        $break.="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|";
        $break.="<br>";

        



        $check=Workflow::find()->where(['task_id'=>$tid,'cid'=>$cid])->one();
        
        if(count($check)==0)
        {
            //$flow.=$sent_flow;
            $work= new Workflow();
            $work->cid=$cid;
            $work->task_id=$tid;
            $work->work_flow=ucfirst($sent_flow);
            $work->int_workflow=$selected_int;
            $work->status=0;
            $work->instrument=$instrument_id;
            $work->instrument_text=$instrument_text;
            $work->status_id=$status_id;
            $work->status_text=$status_text;
            $work->save();
            $show.= $sent_flow;

       }else{

        if($check->work_flow=='deleted')
        {
            $check->work_flow='';
            $check->int_workflow='';

            $check->work_flow.=ucfirst($sent_flow);
            $check->int_workflow.=$selected_int;
            $check->instrument=$instrument_id;
            $check->instrument_text=$instrument_text;
            $check->status_id=$status_id;
            $check->status_text=$status_text;
        }else{        
       
        $check->work_flow.=','.ucwords($sent_flow); 
        $check->int_workflow.=','.$selected_int; 

        $check->instrument.=','.$instrument_id;
        $check->instrument_text.=','.ucwords($instrument_text); 

        $check->status_id.=','.$status_id;
        $check->status_text.=','.ucwords($status_text);    
        
            }
            
        if(!$check->save())
        {
            var_dump($check->getErrors());
        }
      
       }
        $chip=explode(',',  $check->work_flow);
        $x=count($chip);
        foreach($chip as $ch)
        {
           
                  $show.= $ch;
                   if($x>1)
                   {
                    $show.= $break;
                    }
                    $x--;
                
        }

 \Yii::$app->response->data=$show;

        
    }


    /*

     public function actionLoadflow()
    {
        $sent_flow=Yii::$app->request->post('dflow');
        $cid=Yii::$app->request->post('cid');
        $tid=Yii::$app->request->post('tid');

        $flow='';
        $break='';
        $break.="<br>";
        $break.="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|";
        $break.="<br>";



        $check=Workflow::find()->where(['task_id'=>$tid,'cid'=>$cid])->one();
        
        if(count($check)==0)
        {
            //$flow.=$sent_flow;
            $work= new Workflow();
            $work->cid=$cid;
            $work->task_id=$tid;
            $work->work_flow=ucfirst($sent_flow);
            $work->status=0;
            $work->save();
            echo $sent_flow;

       }else{

        if($check->work_flow=='deleted')
        {
            $check->work_flow='';
            $check->work_flow.=ucfirst($sent_flow);
        }else{
        
        $check->work_flow.=$break.ucwords($sent_flow);
        
            }
            echo $check->work_flow;
        $check->save();
        
       }



        
    }

    */

    public function actionClearflow()
    {
        // ob_start();
        $cid=Yii::$app->request->post('cid');
        $tid=Yii::$app->request->post('tid');  



        $flow=Workflow::find()->where(['task_id'=>$tid,'cid'=>$cid])->one();

        $check=Requisitions::find()->where(['workflow_id'=>$flow['id']])->andwhere(['cid'=>$cid])->andwhere(['!=','concluded',1])->one();

        if($check!=null){
            ?>
<script type="text/javascript">
alert("You have uncompleted Transactions using this workflow. Complete or delete Ongoing Transactions first before clearling workflow")
</script>

            <?php die();
        }
        //var_dump($flow);
        $flow->work_flow='deleted';
        $flow->int_workflow='deleted';
        $flow->instrument='deleted';
        $flow->instrument_text='deleted';
        $flow->status_text='deleted';
        $flow->status_id='deleted';
        if(!$flow->save()){ var_dump($flow->getErrors()); }
        \Yii::$app->response->data="deleted";
    }



    public function actionClearnotice()
    {
        $cid=Yii::$app->request->post('cid');
        $tid=Yii::$app->request->post('tid');        

        $flow=Workflow::find()->where(['task_id'=>$tid,'cid'=>$cid])->one();
        //var_dump($flow);
      
        $flow->notices='deleted';
        if(!$flow->save()){ var_dump($flow->getErrors()); }
        \Yii::$app->response->data="deleted";
    }


    public function actionShow_instruments()
    {
        // ob_start();
        $show='';
        $cid=Yii::$app->request->post('cid');
        $tid=Yii::$app->request->post('tid');  

        $break='';
        $break.="<br>";
        $break.="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|";
        $break.="<br>";

        $chips2=Workflow::find()->where(['task_id'=>$tid,'cid'=>$cid])->one()->instrument_text; 
    $chip2=explode(',',  $chips2);
        $y=count($chip2);
        foreach($chip2 as $ch2)
        {
           
                   $show.= $ch2;
                   if($y>1)
                   {
                    $show.=$break;
                    }
                    $y--;
                
        }
         \Yii::$app->response->data=$show;
    }


     public function actionShow_status()
    {
        ob_start();
        $show='';
        $cid=Yii::$app->request->post('cid');
        $tid=Yii::$app->request->post('tid');  

        $break='';
        $break.="<br>";
        $break.="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|";
        $break.="<br>";

        $chips2=Workflow::find()->where(['task_id'=>$tid,'cid'=>$cid])->one()->status_text; 
    $chip2=explode(',',  $chips2);
        $y=count($chip2);
        foreach($chip2 as $ch2)
        {
           
                   $show.=$ch2;
                   if($y>1)
                   {
                    $show.=$break;
                    }
                    $y--;
                
        }
        \Yii::$app->response->data=$show;
    }


    public function actionAddnotice()
    {
        $user=Yii::$app->request->post('user');
        $tid=Yii::$app->request->post('task_id');
        $cid=Yii::$app->request->post('cid'); 

        $check=Workflow::find()->where(['task_id'=>$tid,'cid'=>$cid])->one();
        $noput=0;
        $show='';
        if(count($check)==0)
        {
           ?>
<script type="text/javascript">
alert('Workflow Not Set');
</script>
           <?php
               $noput=1;   
        }else{
             
        if($check->notices=='deleted')  
        {
            $check->notices='';
            $check->notices=$user;
        }elseif(empty($check->notices) || $check->notices==NULL)
        {
             $check->notices=$user;
        }else{
            $flex=explode(',', $check->notices);
            if(in_array($user, $flex))
                
            {               
                $noput=1;
                ?>
<script type="text/javascript">

alert('Entry already added for this user'); 
</script>
                <?php
               // $noput=1;
            }
            if($noput==0)
            {
                $check->notices.=','.$user;
            }
        }

        }
        if(!$check->save())
        {
            var_dump($check->getErrors()); die;
        }



        $break='';
        $break.="<br>";
        $break.="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|";
        $break.="<br>";


        $chip=explode(',',  $check->notices);
        $x=count($chip);
        foreach($chip as $ch)
        {
           
                   $show.=ucwords(User::findOne($ch)->position_label);
                   if($x>1)
                   {
                    $show.= $break;
                    }
                    $x--;
                
        }

       \Yii::$app->response->data=$show;

    }


   
}
