<?php
/* sets up payee and penstion type deductions
 in seperate table called deductions with two test entries in them
 and then stores monthly values entered into these fields from the payroll
 in the month_deductions table.
 monthtly dedcutions code to save payroll pension and advance entries to
 the monthly deductions table has not yet been written and has to be written
 by me if i decide to go forward with this multi approach in the future
 pension and advance will be saved as json type payments text field
 */
namespace frontend\modules\hr\controllers;

use Yii;
use frontend\modules\hr\models\PersonalDetails;
use frontend\modules\hr\models\PersonalDetailsSearch;
use frontend\modules\hr\models\PersonalDetailsSearch2;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\modules\hr\models\EducationalDetails;
use frontend\modules\hr\models\PastEmploymentDetails;
use frontend\modules\hr\models\EmploymentDetails;
use frontend\modules\hr\models\Guarantor;
use frontend\modules\hr\models\PaymentDetails;
use frontend\modules\hr\models\ClientUnits;
use frontend\modules\hr\models\Attendance;
use frontend\modules\hr\models\Section;
use yii\widgets\ActiveForm;
use yii\filters\AccessControl;
use yii\data\SqlDataProvider;
use frontend\modules\hr\models\Deductions;

use yii\helpers\Html;

use yii\helpers\ArrayHelper;

/**
 * PersonalDetailsController implements the CRUD actions for PersonalDetails model.
 */
class PersonaldetailsController extends Controller
{
    /**
     * {@inheritdoc}
     */
     public function behaviors()
    {
        return [
              'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['create','update','index','summary','view',
                    'doapprove','allstaff','archive','varchive',
                    'apage','mark','viewattendance','atform','locate','payroll'],
                    'roles' => ['HR'],
                ],
                  
                  [
                    'allow' => true,
                    'actions' => ['index2','pendinga','approved','getunits','getunits3','loadstaff_pay','deep_pay',
                    'getunits2','loadstaff','deep'],  
                    'roles' => ['@']                 
                ],
                [
                    'allow' => true,
                    'actions' => ['pendinga','archive','varchive','apage','locate','payroll'],  
                    'roles' => ['Client Admin']                 
                ],
                //  [
                //     'allow' => true,
                //     'actions' => ['error'],  
                //     'roles' => ['?','@']                 
                // ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all PersonalDetails models.
     * @return mixed
     */
    public function actionIndex()
    {
        $this->layout='column1';
        $searchModel = new PersonalDetailsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
        
    }

    public function actionIndex2()
    {
        // $totalCount = Yii::$app->db->createCommand("SELECT COUNT(*) FROM personal_details WHERE cid='".Yii::$app->user->identity->cid."'")
        //     ->queryScalar();

        $count = Yii::$app->db->createCommand('SELECT COUNT(*) FROM personal_details WHERE cid=:cid', [':cid' => Yii::$app->user->identity->cid])->queryScalar();
$searchModel = new PersonalDetailsSearch();
        $dataProvider = new SqlDataProvider([
    'sql' => 'SELECT * FROM personal_details WHERE cid=:cid',
    'params' => [':cid' => Yii::$app->user->identity->cid],
    'totalCount' => $count,
    'sort' => [
        'attributes' => [
            'surname',
            // 'firstname' => [
            //     'asc' => ['firstname' => SORT_ASC, 'surname' => SORT_ASC],
            //     'desc' => ['firstname' => SORT_DESC, 'surname' => SORT_DESC],
            //     'default' => SORT_ASC,
            //     'label' => 'Name',
            // ],
        ],
    ],
    'pagination' => [
        'pageSize' => 20,
    ],
]);

// get the user records in the current page
$models = $dataProvider->getModels();

 return $this->render('index2', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);




// return $dataProvider;
    }

    /**
     * Displays a single PersonalDetails model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new PersonalDetails model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        if(Yii::$app->user->identity->place==1)
        {
            throw new \yii\web\HttpException(403,"Not authorized");
        }

        $model = new PersonalDetails();

        if ($model->load(Yii::$app->request->post())) {
            $check=PersonalDetails::find()->where(['firstname'=>$model->firstname,'surname'=>$model->surname,'other_names'=>$model->other_names])->one();
            if($check==null)
            {
                 $model->save();
                return $this->redirect(['view', 'id' => $model->id]);
            }
            die("User with fistname $model->firstname and surname $model->surname and other names $model->other_names already exists");
           
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing PersonalDetails model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        if(Yii::$app->user->identity->place==2)
        {
            throw new \yii\web\HttpException(403,"Not authorized");
        }

        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    public function actionSummary($sid)
    {
       
        $this->layout='column1';
        $education=EducationalDetails::find()->where(['staff_id'=>$sid,'cid'=>Yii::$app->user->identity->cid])->all();
        $past=PastEmploymentDetails::find()->where(['staff_id'=>$sid,'cid'=>Yii::$app->user->identity->cid])->all();
        $name=PersonalDetails::findOne($sid)->surname;
        $model=PersonalDetails::findOne($sid);
        $model2=EmploymentDetails::find()->where(['staff_id'=>$sid])->one();        
        $guarantor=Guarantor::find()->where(['staff_id'=>$sid,'cid'=>Yii::$app->user->identity->cid])->all();
        $emolument=PaymentDetails::find()->where(['staff_id'=>$sid,'cid'=>Yii::$app->user->identity->cid])->all();
        return $this->render('summary',['education'=>$education,'name'=>$name,'past'=>$past,
            'model'=>$model,'model2'=>$model2,'guarantor'=>$guarantor,'emolument'=>$emolument]);
    }

    /**
     * Deletes an existing PersonalDetails model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the PersonalDetails model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return PersonalDetails the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = PersonalDetails::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionPendinga()
    {
        if(Yii::$app->user->identity->place==2)
        {
            throw new \yii\web\HttpException(403,"Not authorized");
        }

        $staff=PersonalDetails::find()->where(['cid'=>Yii::$app->user->identity->cid,'approved'=>1])->all();
        // var_dump($staff); die;
        return $this->render('pending',['staff'=>$staff]);
    }


    public function actionVarchive()
    {
        if(Yii::$app->user->identity->place==2)
        {
            throw new \yii\web\HttpException(403,"Not authorized");
        }

        $staff=PersonalDetails::find()->where(['cid'=>Yii::$app->user->identity->cid,'approved'=>3])->all();
        // var_dump($staff); die;
        return $this->render('archive',['staff'=>$staff]);
    }


    public function actionAllstaff()
    {
        if(Yii::$app->user->identity->place==2)
        {
            throw new \yii\web\HttpException(403,"Not authorized");
        }

        $staff=PersonalDetails::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
        // var_dump($staff); die;
        return $this->render('allstaff',['staff'=>$staff]);
    }

    // hold

    // public function actionAllstaff()
    // {
    //     if(Yii::$app->user->identity->place==2)
    //     {
    //         throw new \yii\web\HttpException(403,"Not authorized");
    //     }

    //     $staff=PersonalDetails::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
    //     // var_dump($staff); die;
    //     return $this->render('allstaff',['staff'=>$staff]);
    // }

    public function actionDoapprove()
    {
        
        if(Yii::$app->user->identity->place==2)
        {
            throw new \yii\web\HttpException(403,"Not authorized");
        }

        $sid=Yii::$app->request->post('sid');
        $current=0;
        $record=PersonalDetails::find()->where(['id'=>$sid])->one();
        if($record->approved==1){
            $current=2;
        $record->approved=2;
        }else{
            $record->approved=1;
            $current=1;
        }

        if($record->save())
        {
            echo json_encode(array('saved'=>1,'current'=>$current));
        }else{
            echo json_encode(array('saved'=>2,'current'=>3));
        }

    }

    // archive

     public function actionArchive()
    {
        
        if(Yii::$app->user->identity->place==2)
        {
            throw new \yii\web\HttpException(403,"Not authorized");
        }

        $sid=Yii::$app->request->post('sid');
        $current=0;
        $record=PersonalDetails::find()->where(['id'=>$sid])->one();
        if($record->approved!=3){
            $current=3;
        $record->approved=3;
        }else{
            $record->approved=1;
            $current=1;
        }

        if($record->save())
        {
            echo json_encode(array('saved'=>1,'current'=>$current));
        }else{
            echo json_encode(array('saved'=>2,'current'=>3));
        }

    }


    public function actionApage()
    {
        return $this->render('apage');
    }

    public function actionPayroll()
    {
        $this->layout='column1';
        return $this->render('payroll');
    }

    public function actionGetunits()
    {
        $client=Yii::$app->request->post('cid');       
       
        ?>
        <?= Html::dropDownList('units',null, ArrayHelper::map(ClientUnits::find()->where(['client_account'=>$client])->all(),'id','unit_address'),['class'=>'form-control','prompt'=>'','id'=>'unit','onchange'=>'load_staff()']) ?>
        <?= Html::dropDownList('Section',null, ArrayHelper::map(Section::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','section_name'),['class'=>'form-control','prompt'=>'','id'=>'section','style'=>'margin-top:20px; margin-bottom:20px;','onchange'=>'deep()']) ?>

        <?php
    }



    // get payroll details for client location

    public function actionGetunits3()
    {
        $client=Yii::$app->request->post('cid');       
       
        ?>
        <?= Html::dropDownList('units',null, ArrayHelper::map(ClientUnits::find()->where(['client_account'=>$client])->all(),'id','unit_address'),['class'=>'form-control','prompt'=>'','id'=>'unit','onchange'=>'load_staff_pay()']) ?>
        <?= Html::dropDownList('Section',null, ArrayHelper::map(Section::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','section_name'),['class'=>'form-control','prompt'=>'','id'=>'section','style'=>'margin-top:20px; margin-bottom:20px;','onchange'=>'deep_pay()']) ?>

        <?php
    }


    // get attencance stuff

    public function actionAtform()
    {
        $client=Yii::$app->request->post('cid');       
       
        ?>
        <?= Html::dropDownList('location',null, ArrayHelper::map(ClientUnits::find()->where(['client_account'=>$client])->all(),'id','unit_address'),['class'=>'form-control','prompt'=>'','id'=>'unit']) ?>
        <?= Html::dropDownList('department',null, ArrayHelper::map(Section::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','section_name'),['class'=>'form-control','prompt'=>'','id'=>'section','style'=>'margin-top:20px; margin-bottom:20px;']) ?>

        <?php
    }

    // get unit for employment details form

    public function actionGetunits2()
    {
        $client=Yii::$app->request->post('cid');   
        $form = ActiveForm::begin(); 
        $model=new EmploymentDetails();    
       
        ?>

        <?= $form->field($model,'location')->dropDownList(ArrayHelper::map(ClientUnits::find()->where(['cid'=>Yii::$app->user->identity->cid,'client_account'=>$client])->orderBy(['unit_address'=>'asc'])->all(),'id','unit_address'),['class'=>'form-control','prompt'=>'','id'=>'unit'])->label('Unit') ?>


        <?php
    }

    public function actionLoadstaff()
    {
        ob_start();
        $cid=Yii::$app->request->post('cid');
        $unit=Yii::$app->request->post('unit');
        $client=$cid;

        // $color='#337ab7';
        // $btn='btn btn-primary';
        $details=EmploymentDetails::find()->where(['client'=>$client,'cid'=>Yii::$app->user->identity->cid,'location'=>$unit])->all();

        foreach($details as $det)
        {
         
         // $check=Attendance::find()->where(['client_account'=>$client,'substr(ddate, 1,10)'=>date('Y-m-d')])->one();
            $check=Attendance::find()->where(['client_account'=>$client,'substr(ddate, 1,10)'=>date('Y-m-d'),'location'=>$unit,'staff'=>$det->staff_id])->one();

         if($check==null)
         {
           
                $attend = new Attendance();

                    $start=date('H:i');
                $attend->start=$start;
                    $timestamp=strtotime($start ." + $person->shift_hours hours");
                $attend->stop=date('H:i',$timestamp);


               
                $attend->client_account=$det->client;
                $attend->ddate=date('Y-m-d');
                $attend->staff=$det->staff_id;
                $attend->cid=Yii::$app->user->identity->cid;
                $attend->work_hours=($det->shift_hours*60);
                $attend->location=$unit;
                $attend->shift=$det->shift_hours;
                $attend->department=$det->section;
                $attend->status=0;
                $attend->save();       
        
         }
     }

        // $staff=EmploymentDetails::find()->where(['client'=>$cid,'location'=>$unit])->all();
        $query="select employment_details.staff_id, attendance.status,  employment_details.client, employment_details.section, employment_details.location, employment_details.shift_hours, personal_details.firstname, personal_details.surname, personal_details.id from personal_details left join employment_details on personal_details.id=employment_details.staff_id left join attendance on personal_details.id=attendance.staff WHERE  employment_details.location='".$unit."' and ddate='".date('Y-m-d')."' and personal_details.approved=2 group by employment_details.staff_id";
        $staff=Yii::$app->db->createCommand($query)->queryAll();

        ?>

        <table class="table table-bordered table-striped" style="width:100%">
                    <tr>
                        <th>NAME</th>
                        <th></th>
                    </tr>
        <?php
        foreach($staff as $sta)
        {

            if($sta['status']==1)
            {
                $btn='btn btn-danger';
                $text='Running';
            }elseif($sta['status']==2){
                $btn='btn btn-primary';
                $text='Start';
            }else{
                 $btn='btn btn-primary';
                 $text='Start';
            }
            // echo "status is ".$stastatus;
            ?>
               
                    <tr>
                        <td><?= $sta['surname'] ?></td>
                        <td> <?= Html::button($text,['onclick'=>'mark('.$sta['id'].','.$sta['client'].','.$sta['shift_hours'].','.$sta['location'].','.$sta['section'].')','class'=>$btn.' ','style'=>'display:block; margin-bottom:5px; float:right;','id'=>$sta['id']]) ?></td>
                    </tr>
                
            <?php
        }
        ?>
        </table>

        <?php
    }

    // load specified staff for payroll

    public function actionLoadstaff_pay()
    {
        ob_start();

        $cid=Yii::$app->request->post('cid');
        $unit=Yii::$app->request->post('unit');
        $client=$cid;

        $thisMonth = date('Y-m');
        // $thisMonth = '2021-09';

        $emuls = \frontend\modules\hr\models\Allowances::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

        // $color='#337ab7';
        // $btn='btn btn-primary';
        $details=EmploymentDetails::find()->where(['client'=>$client,'cid'=>Yii::$app->user->identity->cid,'location'=>$unit])->all();

        $deductions=Deductions::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

        // $staff=EmploymentDetails::find()->where(['client'=>$cid,'location'=>$unit])->all();
        $query="select sum(work_hours) as work_hours, employment_details.staff_id, employment_details.designation, attendance.status,  employment_details.client, employment_details.section, employment_details.gross_pay, employment_details.location, employment_details.shift_hours, personal_details.firstname, personal_details.surname, personal_details.id from personal_details left join employment_details on personal_details.id=employment_details.staff_id left join attendance on personal_details.id=attendance.staff WHERE  employment_details.location='".$unit."' and substr(ddate,1,7)='".$thisMonth."' and personal_details.approved=2 group by employment_details.staff_id";
        $staff=Yii::$app->db->createCommand($query)->queryAll();

        $in=1;
        ?>

        <table class="table table-bordered table-striped" style="width:100%">
             <tr>
                        <th colspan="3">LOCATION</th>
                        <th colspan="6">PAYABLES</th>
                        <th colspan="4">DEDUCTABLES</th>
                        <th></th>
                    </tr>

                    <tr>
                        <th>SN</th>
                        <th>NAME</th>
                        <th>DESIGNATION</th>
                        
                        <?php foreach($emuls as $emul){  ?>
                        <th><?= strtoupper($emul->allowance_name) ?></th>                        
                        <?php } ?>
                        <th>GROSS PAY</th>
                        <th>TOTAL HRS</th>
                        <th>HOURS WORKED</th>
                        <th>PENSION</th>
                        <th>PAYEE</th>
                        <?php foreach($deductions as $deduction){  ?>
                        <th><?= strtoupper($deduction->name) ?></th>                        
                        <?php } ?>
                        <th>TOTAL DEDUCTION</th>
                        <th>NET PAY</th>
                    </tr>
        <?php
        foreach($staff as $sta)
        {

         
           
            ?>
               
                    <tr>
                        <th><?= $in++ ?></th>
                        <td><?= $sta['surname'] ?></td>
                        <td><?= ucwords(\frontend\modules\hr\models\Designate::find()->where(['id'=>$sta['designation']])->one()->designation_name) ?></td>
                        
                         <?php foreach($emuls as $emul){ 
                         $pay=PaymentDetails::find()->where(['allowance'=>$emul->id,'cid'=>Yii::$app->user->identity->cid])->one();
                          ?>
                        <td><?= number_format(($pay->amount*$sta['gross_pay'])/100,2) ?></td>                        
                        <?php } ?>
                        
                        <td><?= number_format($sta['gross_pay'],2) ?></td>
                        <td><?= floor($sta['work_hours']/60) ?></td>
                        <td></td>
                        <td></td>
                        <td></td>
                         <?php foreach($deductions as $deduction){  ?>
                        
                        <td><input type="text" size="4" name="<?= $deduction->name ?>"></td>                       
                        <?php } ?>
                
                        <td></td>
                        <td><?= number_format($sta['gross_pay'],2) ?></td>
                    </tr>
                
            <?php
        }
        ?>
        </table>

        <?php
    }


    // filter by department

    public function actionDeep()
    {
        $cid=Yii::$app->request->post('cid');
        $unit=Yii::$app->request->post('unit'); // 
        $deep=Yii::$app->request->post('deep'); // department

        // $staff=EmploymentDetails::find()->where(['client'=>$cid,'location'=>$unit])->all();
        // $query="select employment_details.staff_id, employment_details.client, employment_details.section, employment_details.location, employment_details.section, employment_details.shift_hours, personal_details.firstname, personal_details.surname, personal_details.id from personal_details, employment_details where personal_details.id=employment_details.staff_id and employment_details.location='".$unit."' && employment_details.section='".$deep."'";
        // $query="select employment_details.staff_id, attendance.status, employment_details.client, employment_details.section, employment_details.location, employment_details.shift_hours, personal_details.firstname, personal_details.surname, personal_details.id from personal_details, employment_details, attendance WHERE personal_details.id=employment_details.staff_id && attendance.staff=personal_details.id && attendance.ddate='".date('Y-m-d')."' && employment_details.location='".$unit."' && employment_details.section='".$deep."' group by employment_details.staff_id";
        $query="select employment_details.staff_id, attendance.status, employment_details.client, employment_details.section, employment_details.location, employment_details.shift_hours, personal_details.firstname, personal_details.surname, personal_details.id from personal_details left join employment_details on personal_details.id=employment_details.staff_id left join attendance on personal_details.id=attendance.staff WHERE  employment_details.location='".$unit."' && employment_details.section='".$deep."' and ddate='".date('Y-m-d')."' and personal_details.approved=2 group by employment_details.staff_id ";
        $staff=Yii::$app->db->createCommand($query)->queryAll();

        ?>

        <table class="table table-bordered table-striped" style="width:100%">
                    <tr>
                        <th>NAME</th>
                        <th></th>
                    </tr>
        <?php
        foreach($staff as $sta)
        {
            if($sta['status']==1)
            {
                $btn='btn btn-danger';
                $text='Running';
            }elseif($sta['status']==2){
                $btn='btn btn-primary';
                $text='Start';
            }else{
                 $btn='btn btn-primary';
                 $text='Start';
            }

            
            ?>
               
                    <tr>
                        <td><?= $sta['surname'] ?></td>
                        <td> <?= Html::button($text,['onclick'=>'mark('.$sta['id'].','.$sta['client'].','.$sta['shift_hours'].','.$sta['location'].','.$sta['section'].')','class'=>$btn,'style'=>'display:block; margin-bottom:5px; float:right','id'=>$sta['id']]) ?></td>
                    </tr>
                
            <?php
        
        }
        ?>
        </table>

        <?php
    }


    // deep for payroll

    public function actionDeep_pay()
    {
        $cid=Yii::$app->request->post('cid');
        $unit=Yii::$app->request->post('unit'); // 
        $deep=Yii::$app->request->post('deep'); // department

        // $staff=EmploymentDetails::find()->where(['client'=>$cid,'location'=>$unit])->all();
        // $query="select employment_details.staff_id, employment_details.client, employment_details.section, employment_details.location, employment_details.section, employment_details.shift_hours, personal_details.firstname, personal_details.surname, personal_details.id from personal_details, employment_details where personal_details.id=employment_details.staff_id and employment_details.location='".$unit."' && employment_details.section='".$deep."'";
        // $query="select employment_details.staff_id, attendance.status, employment_details.client, employment_details.section, employment_details.location, employment_details.shift_hours, personal_details.firstname, personal_details.surname, personal_details.id from personal_details, employment_details, attendance WHERE personal_details.id=employment_details.staff_id && attendance.staff=personal_details.id && attendance.ddate='".date('Y-m-d')."' && employment_details.location='".$unit."' && employment_details.section='".$deep."' group by employment_details.staff_id";
        $query="select employment_details.staff_id, sum(work_hours) as work_hours,  employment_details.designation, employment_details.gross_pay, attendance.status, employment_details.client, employment_details.section, employment_details.location, employment_details.shift_hours, personal_details.firstname, personal_details.surname, personal_details.id from personal_details left join employment_details on personal_details.id=employment_details.staff_id left join attendance on personal_details.id=attendance.staff WHERE  employment_details.location='".$unit."' && employment_details.section='".$deep."' and substr(ddate,1,7)='".date('Y-m')."' and personal_details.approved=2 group by employment_details.staff_id ";
        $staff=Yii::$app->db->createCommand($query)->queryAll();

         $emuls = \frontend\modules\hr\models\Allowances::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
         $details=EmploymentDetails::find()->where(['client'=>$client,'cid'=>Yii::$app->user->identity->cid,'location'=>$unit])->all();
         $in=1;
        ?>

        <table class="table table-bordered table-striped" style="width:100%">
                     <tr>
                        <th colspan="3">LOCATION</th>
                        <th colspan="6">PAYABLES</th>
                        <th colspan="4">DEDUCTABLES</th>
                        <th></th>
                    </tr>

                    <tr>
                        <th></th>
                        <th>NAME</th>
                        <th>DESIGNATION</th>
                        
                        <?php foreach($emuls as $emul){  ?>
                        <th><?= strtoupper($emul->allowance_name) ?></th>                        
                        <?php } ?>
                        <th>GROSS PAY</th>
                        <th>TOTAL HRS</th>
                        <th>HOURS WORKED</th>
                        <th>PENSION</th>
                        <th>PAYEE</th>
                        <th>ADVANCE</th>
                        <th>SURCHARGE</th>
                        <th>TOTAL DEDUCTION</th>
                        <th>NET PAY</th>
                    </tr>
        <?php
        foreach($staff as $sta)
        {

         
           
            ?>
               
                    <tr>
                        <th><?= $in++ ?></th>
                        <td><?= $sta['surname'] ?></td>
                        <td><?= ucwords(\frontend\modules\hr\models\Designate::find()->where(['id'=>$sta['designation']])->one()->designation_name) ?></td>
                        
                         <?php foreach($emuls as $emul){ 
                         $pay=PaymentDetails::find()->where(['allowance'=>$emul->id,'cid'=>Yii::$app->user->identity->cid])->one();
                          ?>
                        <td><?= number_format(($pay->amount*$sta['gross_pay'])/100,2) ?></td>                        
                        <?php } ?>
                        
                        <td><?= number_format($sta['gross_pay'],2) ?></td>
                        <td><?= floor($sta['work_hours']/60) ?></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td><input type="text" size="4" name="advance[]"></td>
                        <td><input type="text" size="4" name="surcharge[]"></td>
                        <td></td>
                        <td><?= number_format($sta['gross_pay'],2) ?></td>
                    </tr>
                
            <?php
        }
        ?>
        </table>

        <?php
    }



    public function actionMark()
    {
        $staff=Yii::$app->request->post('staff');
        $client=Yii::$app->request->post('client');
        $shift=Yii::$app->request->post('shift');
        $location=Yii::$app->request->post('location');
        $department=Yii::$app->request->post('department');

        $check=Attendance::find()->where(['staff'=>$staff,'client_account'=>$client,'substr(ddate, 1,10)'=>date('Y-m-d')])->one();
        if($check!=null)
        {
        if($check->status==0)
        {           
          
            $check->status=1;
            $check->starter=Yii::$app->user->identity->id;
            $check->stopper=Yii::$app->user->identity->id;
            $check->save();

            }else{

            $start=$check->start;  

            $hold=$check->status;
                if($hold==2)
                {
                    $check->status=1;
                }else{
                    $check->status=2;
                }         
                
            $check->stop=date('H:i');
                $timeDifference=strtotime(date('H:i'))-strtotime($start);
                $time=$timeDifference/(60);
            $check->work_hours=$time;
                // $check->stop=date('H:i',strtotime($start+ $shift." hours"));
            $check->stopper=Yii::$app->user->identity->id;
            $check->save();
        }
    }
        if($check->status==1)
        {            
            echo json_encode(array('colors'=>'#d9534f','textt'=>'Running'));
        }elseif($check->status==2){           
            echo json_encode(array('colors'=>'#337ab7','textt'=>'Start'));
        }else{
             echo json_encode(array('colors'=>'#d9534f','textt'=>'Running'));
        }
    }


    public function actionViewattendance()
    {
        if(Yii::$app->request->post())
        {
              $client=Yii::$app->request->post('client');
              $department=Yii::$app->request->post('department');
              $location=Yii::$app->request->post('location');
              $from=Yii::$app->request->post('from');
              $to=Yii::$app->request->post('to');

               $query = (new \yii\db\Query())
           // ->select(['id'])
            // ->from('requisitions')
            ->select('client_account, location,staff,sum(work_hours) as work_hours')
            ->from('attendance')

            ->where('cid=:sam', [':sam' => Yii::$app->user->identity->cid])->andWhere(['>','status',0]);
            // ->andWhere('amount_paid!=:pa', [':pa' => 0])
            
            // ->andWhere('vendor!=:ba', [':ba' => 0]);
            // ->andWhere('vendor!=:ba1', [':ba1' => NULL]);
            // ->andWhere(['concluded'=>1]);
            if(Yii::$app->request->post('from') && Yii::$app->request->post('to'))
            {
                $query=$query->andWhere(['between','SUBSTR(ddate,1,10)',$from, $to]);
            } 


            if(!empty(Yii::$app->request->post('client')))
            {
                $query=$query->andWhere(['client_account'=>$client]);
            }  


            if(!empty(Yii::$app->request->post('location')))
            {
                $query=$query->andWhere(['location'=>$location]);
            }   


            if(!empty(Yii::$app->request->post('department')))
            {
                $query=$query->andWhere(['department'=>$department]);
            }            
            
//
           

            $query=$query->groupBy('staff');
           

             
              $query=$query->all();
              return $this->render('view_attendance',['staff'=>$query]);
        }
        return $this->render('view_attendance');
    }


    // locate staff

    public function actionLocate()
    {
        if(Yii::$app->request->post())
        {
              $client=Yii::$app->request->post('client');
              $department=Yii::$app->request->post('department');
              $location=Yii::$app->request->post('location');
             

               $query = (new \yii\db\Query())
           // ->select(['id'])
            // ->from('requisitions')
            ->select('client_account, staff, location,staff')
            ->from('attendance')

            ->where('cid=:sam', [':sam' => Yii::$app->user->identity->cid])->andWhere(['>','status',0]);
            // ->andWhere('amount_paid!=:pa', [':pa' => 0])
            
            // ->andWhere('vendor!=:ba', [':ba' => 0]);
            // ->andWhere('vendor!=:ba1', [':ba1' => NULL]);
            // ->andWhere(['concluded'=>1]);
           


            if(!empty(Yii::$app->request->post('client')))
            {
                $query=$query->andWhere(['client_account'=>$client]);
            }  


            if(!empty(Yii::$app->request->post('location')))
            {
                $query=$query->andWhere(['location'=>$location]);
            }   
           

            $query=$query->groupBy('staff');
           

             
              $query=$query->all();
              return $this->render('locate_staff',['staff'=>$query]);
        }
        return $this->render('locate_staff');
    }

    // orginal view attendance

    // public function actionViewattendance()
    // {
    //     if(Yii::$app->request->post())
    //     {
    //           $client=Yii::$app->request->post('client');
    //           $department=Yii::$app->request->post('department');
    //           $location=Yii::$app->request->post('location');
    //           $from=Yii::$app->request->post('from');
    //           $to=Yii::$app->request->post('to');

    //           // ->andWhere(['between','SUBSTR(created_at,1,10)',$from,$to])
    //           $query = Attendance::find()->where(['cid'=>Yii::$app->user->identity->cid,'client_account'=>$client])->andWhere(['>=','ddate',$from])->andWhere(['<=','ddate',$to]);         
    //           // $query="select *from attendance sum(work_hours) where ddate >='".$ddate."' and ddate <='".$ddate."' and client_account='".$client."' and cid='".Yii::$app->user->identity->cid."'";

    //           if(Yii::$app->request->post('location')){
    //             $query=$query->andWhere(['location'=>$location]);
    //           }             

    //          if(Yii::$app->request->post('department')){
    //             $query=$query->andWhere(['department'=>$department]);
    //           }

    //           $query=$query->all();
    //           return $this->render('view_attendance',['staff'=>$query]);
    //     }
    //     return $this->render('view_attendance');
    // }







    // public function actionApproved()
    // {
    //     $staff=PersonalDetails::find()->where(['cid'=>Yii::$app->user->identity->cid,'approved'=>2])->all();
    //     // var_dump($staff); die;
    //     return $this->render('approved',['staff'=>$staff]);
    // }


    public function actionApproved()
    {
        // $this->layout='column1';
        $searchModel = new PersonalDetailsSearch2();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('approved', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }



    

   
}
