<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\ClientAccount */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Client Accounts', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="client-account-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'cid',
            'client_name',
            'address:ntext',
            'company_number',
            'email:email',
            'contact_person',
            'created_at',
            'contact_number',
            // ['label'=>'Emolument Details', 'format'=>'raw', 'value'=>Html::a('Emolument Details',['/hr/paymentdetails/index','sid'=>$model->id],['class'=>'btn btn-primary'])],
        ],
    ]) ?>

</div>
