<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\modules\hr\models\InstitutionType;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\EducationalDetails */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="educational-details-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <?= $form->field($model, 'staff_id')->hiddenInput(['value'=>Yii::$app->request->get('sid')])->label(false) ?>

    
     <?= $form->field($model, 'institution_type')->dropDownList(ArrayHelper::map(InstitutionType::find()->orderBy(['type'=>'asc'])->all(),'id','type'),['class'=>'form-control','prompt'=>'','id'=>'itype'])->label('Institution Type') ?>

    
    <?=  $form->field($model,'start_date')->widget(DatePicker::classname(),
    ['options'=>['placeholder'=>'Start Date','autocomplete'=>'Off'],
    'pluginOptions'=>[ 'autoclose'=>true,
                'format' => 'yyyy-mm-dd',
                'todayHighlight' => true,]]) ?>

    
    <?=  $form->field($model,'end_date')->widget(DatePicker::classname(),
    ['options'=>['placeholder'=>'End Date','autocomplete'=>'Off'],
    'pluginOptions'=>[ 'autoclose'=>true,
                'format' => 'yyyy-mm-dd',
                'todayHighlight' => true,]]) ?>

    <?= $form->field($model, 'qualification')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'institution_name')->textarea(['rows' => 6]) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
