<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

use yii\helpers\ArrayHelper;
use frontend\modules\hr\models\EmploymentType;

/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\PastEmploymentDetails */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="past-employment-details-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'name_of_employer')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <?= $form->field($model, 'address')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'phone')->textInput(['maxlength' => true]) ?>

    
    <?= $form->field($model, 'employment_type')->dropDownList(ArrayHelper::map(EmploymentType::find()->orderBy(['name'=>'asc'])->all(),'id','name'),['class'=>'form-control','prompt'=>'','id'=>'employment_type'])->label('Employment Type') ?>

    <?= $form->field($model, 'employment_period')->textInput(['maxlength' => false]) ?>

    <?= $form->field($model, 'last_position_held')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'staff_id')->hiddenInput(['maxlength' => true,'value'=>Yii::$app->request->get('sid')])->label(false) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
