<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use frontend\modules\hr\models\Allowances;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\PaymentDetails */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="payment-details-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <?= $form->field($model, 'staff_id')->hiddenInput(['value'=>$sid])->label(false) ?>

    
    <?= $form->field($model, 'allowance')->dropDownList(ArrayHelper::map(Allowances::find()->where(['cid'=>Yii::$app->user->identity->cid])->orderBy(['allowance_name'=>'asc'])->all(),'id','allowance_name'),['class'=>'form-control','prompt'=>'','id'=>'allowance_name'])->label('Allowance Name') ?>

    <?= $form->field($model, 'amount')->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
