<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel frontend\modules\hr\models\PersonalDetailsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Approved Staff List';
$this->params['breadcrumbs'][] = $this->title;
// var_dump($searchModel); die;
?>
<div class="personal-details-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

  
<?php
$club='edetails.section';
$emtype='edetails.employment_type';

$unit='edetails.location';

?>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
             // ['class' => 'yii\grid\SerialColumn'],

            // 'id',
             [
                'label'=>'Staff ID',
                'attribute'=>'id',
                'value'=>function($data){                    
                     return "MRL".str_pad($data->id, 5,0, STR_PAD_LEFT);
                                      }                
            ],
            // 'cid',
            'surname',
            'firstname',
            // 'other_names',
            //'dob',
            //'nationality',
            //'nin',
            //'nir',
            //'tin',
            //'marital_status',
            //'name_of_spouse',
            // 'residential_address',
            // 'telephone',
            // 'email:email',
            'gender',
            //'address_of_spouse:ntext',
            //'account_type',
            // 'account_number',
            // 'spouse_telephone',
            //'name_of_banker',
            //'name_of_PFA',
            //'name_of_PFC',
            //'RSA_number',
            // 'edetails.section',
            'approved',
            [
                'label'=>'Department',
                'attribute'=>'sectoral',
                'value'=>function($data){
                    $sec=\frontend\modules\hr\models\Section::find()->where(['id'=>$data->edetails->section])->one()->section_name;
                     return $sec;
                }
                
            ],
            [
                'label'=>'Employment Type',
                'attribute'=>'emtype',
                'value'=>function($data,$emtype){
                    $jec=\frontend\modules\hr\models\EmploymentType::find()->where(['id'=>$data->edetails->employment_type])->one()->name;
                     return $jec;
                 }
            ],
            // [
            //     'label'=>'Section',
            //     'attribute'=>'client',
            //     'value'=>function($data){
            //         $dclient=\frontend\modules\hr\models\ClientAccount::find()->where(['like','client_name',$data->edetails->client])->one()->client_name;
            //          return $dclient;
            //      }
            // ],

                 [
                'label'=>'Section',
                'attribute'=>'client',
                'value'=>function($data){
                    $dclient=\frontend\modules\hr\models\ClientAccount::find()->where(['=','id',$data->edetails->client])->one()->client_name;
                     return $dclient;
                 }
            ],
            [
                'label'=>'Unit',
                'attribute'=>'unit',
                'value'=>function($data){
                    $dunit=\frontend\modules\hr\models\ClientUnits::find()->where(['id'=>$data->edetails->location])->one()->unit_name;
                     return $dunit;
                 }
            ],
            ['label'=>'Action', 'format'=>'raw', 'attribute'=>'unit', 'value'=>function ($model){  return  Html::button('Archive',['class'=>'btn btn-warning', 'style'=>$style,'onclick'=>'archive('.$model->id.')','id'=>'but'.$model->id]);  }], 
           

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>


