<?php
use yii\helpers\Html;
use yii\widgets\DetailView;
use frontend\modules\hr\models\ClientAccount;
?>

<style type="text/css">
.pushit{
	padding-left:10px; text-transform: uppercase; font-weight: bold;
}
</style>



<h1>Information Details on <?= $name ?></h1>
<?= Html::a('Back to Staff Details', ['personaldetails/index'], ['class' => 'btn btn-primary']) ?>

<div id="holder" style="border:1px solid #ccc; margin-top:50px;">

		<div>
			<h4 class="pushit">Personal Details</h4>
            <?= Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['personaldetails/update','id'=>$model2->staff_id], ['class' => '', 'style'=>'margin-left:10px;','id'=>'noshow']) ?>
            
<div class="personal-details-view">

  

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            // 'id',
            // 'cid',
            'surname',
            'firstname',
            'other_names',               
            ['label'=>'Date of birth', 'format'=>'raw', 'value'=>date('jS F Y',strtotime($model->dob))],        
            ['label'=>'Nationality', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\Nationality::findOne($model->nationality)->nation],
            'nin',
            'nir',
            'tin',            
            ['label'=>'Marital Status', 'format'=>'raw', 'value'=>$model->marital_status==2 ? 'Married' : ($model->marital_status == 1 ? 'Single' : 'Not set')],
            'name_of_spouse',
            'residential_address',
            'telephone',
            'email:email',
            ['label'=>'Gender', 'format'=>'raw', 'value'=>$model->gender==1 ? 'Male' : ($model->gender == 2 ? 'Female' : 'Not set')],
            'address_of_spouse:ntext',            
            ['label'=>'Account Type', 'format'=>'raw', 'value'=>$model->account_type==1 ? 'Savings' : ($model->account_type == 2 ? 'Current' : 'Not set')],
            'account_number',
            'spouse_telephone',
            'name_of_banker',
            'name_of_PFA',
            'name_of_PFC',
            'RSA_number',
            

        ],
    ]) ?>

</div>

	</div>



<div>
	<h4 class="pushit">Educational Details</h4>
	
	<table class="table table-striped table-bordered">
		<tr>
<th>NAME</th>
<th>QUALIFICATION</th>
<th>START DATE</th>
<th>END DATE</th>
<th></th>
		</tr>
	<?php
	if($education!=null)
	{


foreach($education as $edu)
{
	?>
	<tr>
<td><?= $edu->institution_name ?></td>
<td><?= $edu->qualification ?></td>
<td><?= $edu->start_date ?></td>
<td><?= $edu->end_date ?></td>
<td>
    <?= Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['educationaldetails/update','id'=>$edu->id], ['class' => '', 'style'=>'margin-left:10px;','id'=>'noshow']) ?>
    </td>
	</tr>

	<?php
}

}
	?>
</table>
</div>





<div>
	<h4 class="pushit">Past Employment Details</h4>	
	<table class="table table-striped table-bordered">
		<tr>
<th>EMPLOYER NAME</th>
<th>ADDRESS</th>
<th>PHONE</th>
<th>EMPLOYMENT PERIOD</th>
<th>LAST POSITION HELD</th>
<th></th>
		</tr>
	<?php
	if($past!=null)
	{


foreach($past as $pas)
{
	?>
	<tr>
<td><?= $pas->name_of_employer ?></td>
<td><?= $pas->address ?></td>
<td><?= $pas->phone ?></td>
<td><?= $pas->employment_period ?></td>
<td><?= $pas->last_position_held ?></td>
<td><?= Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['pastemploymentdetails/update','id'=>$pas->id], ['class' => '', 'style'=>'margin-left:10px;','id'=>'noshow']) ?></td>
	</tr>

	<?php
}

}
	?>
</table>

</div>

<h4 class="pushit">Employment Details</h4>
<?= Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['employmentdetails/update','id'=>$model2->id], ['class' => '', 'style'=>'margin-left:10px;','id'=>'noshow']) ?>
<div class="employment-details-view">



    <?php if($model2!=null)
    {

    echo  DetailView::widget([
        'model' => $model2,
        'attributes' => [
            // 'id',
             
               ['label'=>'Employment Date', 'format'=>'raw', 'value'=>date('jS F Y',strtotime($model2->employment_date))],          
             ['label'=>'Designation', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\Designate::findOne($model2->designation)->designation_name],
            
            //['label'=>'Base Salary Pa', 'format'=>'raw', 'value'=>number_format($model2->base_salary_pa,2)],          
            //['label'=>'Transport Allowance Pa', 'format'=>'raw', 'value'=>number_format($model2->transport_allowance_pa,2)],          
            ['label'=>'Department', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\Section::findOne($model2->section)->section_name],
           
            ['label'=>'Employment Type', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\EmploymentType::findOne($model2->employment_type)->name],
            
          // ['label'=>'Housing Allowance', 'format'=>'raw', 'value'=>number_format($model2->housing_allowance,2)],
           // ['label'=>'Other Allowance', 'format'=>'raw', 'value'=>number_format($model2->other_allowance,2)],
            // ['label'=>'Location', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\Locations::findOne($model2->location)->location_name],
            ['label'=>'Location', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\ClientUnits::findOne($model2->location)->unit_address],

            ['label'=>'Section', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\ClientAccount::findOne($model2->client)->client_name],
            
             ['label'=>'cadre', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\Cadre::findOne($model2->cadre)->cadre_type],
            'supervisor_name',
            
            ['label'=>'First Name', 'format'=>'raw', 'value'=>\frontend\modules\hr\models\PersonalDetails::findOne($model2->staff_id)->firstname],
            ['label'=>'Gross Pay', 'format'=>'raw', 'value'=>number_format($model2->gross_pay)],
            // 'cid',
        ],
    ]);
    }
     ?>

</div>


<div>
	<h4 class="pushit">Gurantor Details</h4>
	
	<table class="table table-striped table-bordered">
		<tr>
<th>NAME</th>
<th>ADDRESS</th>
<th>PHONE</th>
<th>EMPLOYER</th>
<th>EMPLOYER ADDRESS</th>
<th>EMPLOYER PHONE</th>
<th>POSITION</th>
<th>DEPARTMENT</th>
<th>LENTH OF SERVICE</th>
<th></th>
		</tr>
	<?php
	if($guarantor!=null)
	{


foreach($guarantor as $gua)
{
	?>
	<tr>
<td><?= $gua->name ?></td>
<td><?= $gua->address ?></td>
<td><?= $gua->phone ?></td>
<td><?= $gua->employer ?></td>
<td><?= $gua->employer_addrress ?></td>
<td><?= $gua->employer_phone ?></td>
<td><?= $gua->position ?></td>
<td><?= $gua->department ?></td>
<td><?= $gua->length_of_service ?></td>
<td><?= Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['guarantor/update','id'=>$gua->id], ['class' => '', 'style'=>'margin-left:10px;','id'=>'noshow']) ?></td>
	</tr>

	<?php
}

}
	?>
</table>
</div>




<div>
    <h4 class="pushit">Emolument Details</h4>
    
    <table class="table table-striped table-bordered">
        <tr>

<th>ALLOWANCE</th>
<th>AMOUNT</th>

<th></th>

        </tr>
    <?php
    if($emolument!=null)
    {

$adSal=0;
foreach($emolument as $emo)
{
    $adSal+=($emo->amount/100)*$model2->gross_pay
    ?>
    <tr>

<td><?= \frontend\modules\hr\models\Allowances::findOne($emo->allowance)->allowance_name ?></td>
<td><?= number_format(($emo->amount/100)*$model2->gross_pay,2) ?></td>

<td><?= Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['paymentdetails/update','id'=>$emo->id], ['class' => '', 'style'=>'margin-left:10px;','id'=>'noshow']) ?></td>

    </tr>

    <?php
}


}
    ?>
    <tr>
       <th>TOTAL</th>

        <td><?= number_format($adSal,2) ?></td>
        <td></td>
    </dr>
</table>
</div>


</div>


<?php

$style='';
$label='';
if($model->approved==2)
{
    $style="background-color:#f4a460; margin-right:30px;";
    $text='Reject';
}else{
    $style="background-color:#337ab7; margin-right:30px;";
    $text='Approve';
}
    ?>

<div style="margin-top:20px; float:right;">
<?= Yii::$app->user->identity->place==1 ?  Html::button($text,['class'=>'btn btn-primary', 'style'=>$style,'onclick'=>'approve('.$model->id.')','id'=>'but'.$model->id]) : '' ?>
<?= Html::button('Print Document',['onclick'=>'print()', 'class'=>'btn btn-primary']) ?>
</div>