<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "tasks".
 *
 * @property int $id
 * @property int $cid
 * @property string $task_name
 * @property int $task_type
 * @property int $initiator
 * @property int $finisher
 * @property string $created_at
 * @property string $updated_at
 */
class Tasks extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tasks';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'task_name', 'task_type', 'initiator'], 'required'],
            [['cid', 'task_type', 'initiator', 'finisher'], 'integer'],
            [['task_name'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'task_name' => 'Task Name',
            'task_type' => 'Task Type',
            'initiator' => 'Initiator',
            'finisher' => 'Finisher',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
