<?php

namespace backend\models;


use Yii;

/**
 * This is the model class for table "user".
 *
 * @property int $id
 * @property string $username
 * @property string $first_name
 * @property string $last_name
 * @property string $role
 * @property int $department
 * @property int $cid
 * @property string $email
 * @property int $position
 * @property string $position_label
 * @property int $status
 * @property string $auth_key
 * @property string $password_hash
 * @property string $password_reset_token
 * @property int $created_at
 * @property int $updated_at
 * @property int $place
 * @property int $shop_id
 */
class User extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'user';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['username', 'first_name', 'last_name', 'role', 'cid', 'email', 'department', 'auth_key', 'password_hash'], 'required'],
            [['cid', 'department', 'status', 'created_at', 'updated_at','place','shop_id'], 'integer'],
            [['username', 'email', 'password_hash', 'password_reset_token'], 'string', 'max' => 255],
            [['first_name', 'last_name'], 'string', 'max' => 150],
            [['role'], 'string', 'max' => 200],
            // [['position_label'], 'string', 'max' => 225],
            [['auth_key'], 'string', 'max' => 32],
            [['username'], 'unique'],
            [['shop_id'], 'forshop','skipOnEmpty'=>false],
            [['email'], 'unique'],
            [['place'], 'required'],
            [['password_reset_token'], 'unique'],
            [['role'],'my_unique'],
             ['place', 'my_unique_group']
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'username' => 'Username',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'role' => 'Role',
           'department' => 'Workgroup',
            'cid' => 'Cid',
            'email' => 'Email',
          //  'position' => 'Position',
          //  'position_label' => 'Position Label',
            'status' => 'Status',
            'place' => 'Place',
            'auth_key' => 'Auth Key',
            'password_hash' => 'Password Hash',
            'password_reset_token' => 'Password Reset Token',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'shop_id' => 'Shop ID',
        ];
    }

     static function getName($id)
    {
        $name=User::findOne($id);
        return ucwords($name->last_name.' '.$name->first_name);
    }

    function getNames()
    {       
        return ucwords($this->last_name.' '.$this->first_name);
    }

    function getLabel()
    {
        return ucwords($this->position_label).' - ('.ucwords($this->last_name.' '.$this->first_name).')';
    }

    function getLabel2()
    {
        return ucwords($this->last_name.' '.$this->first_name).' - ('.ucwords($this->position_label).')';
    }


   

    public function my_unique($attribute,$params)
    {
       
        //$checked=User::model()->find('role=:ba and cid=:sh',array(':ba'=>$this->role,':sh'=>$this->cid));
        $checked=User::find()->where(['role'=>$this->role])->andWhere(['cid'=>$this->cid])->andWhere(['!=','role','App User'])->andWhere(['!=','id',$this->id])->one();
        if($checked!=null)
        {
             $this->addError('role',
            'You can only have one user with '.$this->role.' Role');
        }
        // else if(!empty($this->phoneno) && $this->stdcode=='')
           //  {
           //      $this->addError('stdcode','Please enter STD number');
           //  }
    }

    public function my_unique_group($attribute,$params)
    {
       
        //$checked=User::model()->find('role=:ba and cid=:sh',array(':ba'=>$this->role,':sh'=>$this->cid));
        $checked=User::find()->where(['cid'=>$this->cid])->andWhere(['=','place','Group Head'])->andWhere(['department'=>$this->department])->one();
       // $checked=User::find()->where(['place'=>$this->place])->andWhere(['cid'=>$this->cid])->andWhere(['!=','place','Group Member'])->andWhere(['department'=>$this->department])->one();
        if($checked!=null)
        {
             if($this->place==1){ $place='Group head'; }
             $this->addError('place',
            'You can only have one user with '.$place.' Status for '.Departments::findOne($this->department)->department_name.' department');
        }
        // else if(!empty($this->phoneno) && $this->stdcode=='')
           //  {
           //      $this->addError('stdcode','Please enter STD number');
           //  }
    }

    public function forshop($attribute,$params)
    {
        if($this->department==1 && $this->shop_id==NULL)
        {
            $this->addError('shop_id',
            'Users on the shop Workgroup must enter a shop_id');
        }      
    }


}

// || $this->shop_id=='' || empty($this->shop_id))
