<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "workflow".
 *
 * @property int $id
 * @property int $cid
 * @property int $task_id
 * @property int $status
 * @property string $work_flow
 * @property string $int_workflow
 * @property string $instrument
 * @property string $instrument_text
 * @property string $status_id
 * @property string $status_text
 * @property string $notices
 * @property string $created_at
 * @property string $updated_at
 */
class Workflow extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'workflow';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cid', 'task_id', 'status', 'work_flow', 'int_workflow', 'instrument', 'instrument_text', 'status_text'], 'required'],
            [['cid', 'task_id', 'status'], 'integer'],
            [['work_flow', 'int_workflow', 'instrument', 'instrument_text', 'status_id', 'status_text', 'notices'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'task_id' => 'Task ID',
            'status' => 'Status',
            'work_flow' => 'Work Flow',
            'int_workflow' => 'Int Workflow',
            'instrument' => 'Instrument',
            'instrument_text' => 'Instrument Text',
            'status_id' => 'Status ID',
            'status_text' => 'Status Text',
            'notices' => 'Notices',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
