<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "ledger".
 *
 * @property int $id
 * @property int $cid
 * @property int $department
 * @property string $description
 * @property double $credit
 * @property double $amount_paid
 * @property double $debit
 * @property string $transaction_id
 * @property string $vendor
 * @property int $open
 * @property int $ptype
 * @property int $bank
 * @property int $aorb a for advance and b for balance. to specify if this is balance or advance payment
 * @property string $tlink original transaction link
 * @property int $shop_id
 * @property string $details
 * @property int $staff
 * @property int $chart_account
 * @property int $chart_account2
 * @property int $account_group
 * @property int $account_group2
 * @property int $entry_group
 * @property int $entry_group2
 * @property int $entry_type
 * @property int $entry_type2
 * @property string $dsource
 * @property string $created_at
 * @property string $updated_at
 * @property int $payment_method
 * @property string $table_no
 * @property string $leg2_link
 * @property string $invoice Id of invoice supplied by supplier or vendor on payment voucher
 * @property int $shift
 * @property string $stamp
 * @property int $fin
 * @property double $discount
 * @property double $reservation_deposit
 */
class Ledger extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'ledger';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'department', 'description', 'credit', 'debit', 'transaction_id', 'vendor', 'staff'], 'required'],
            [['cid', 'department', 'open', 'ptype', 'bank', 'aorb', 'shop_id', 'staff', 'chart_account', 'chart_account2', 'account_group', 'account_group2', 'entry_group', 'entry_group2', 'entry_type', 'entry_type2', 'payment_method', 'shift', 'fin'], 'integer'],
            [['description', 'details'], 'string'],
            [['credit', 'amount_paid', 'debit', 'discount', 'reservation_deposit'], 'number'],
            [['created_at', 'updated_at'], 'safe'],
            [['transaction_id'], 'string', 'max' => 200],
            [['vendor', 'tlink'], 'string', 'max' => 225],
            [['dsource'], 'string', 'max' => 5],
            [['table_no'], 'string', 'max' => 10],
            [['leg2_link', 'invoice', 'stamp'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'department' => 'Department',
            'description' => 'Description',
            'credit' => 'Credit',
            'amount_paid' => 'Amount Paid',
            'debit' => 'Debit',
            'transaction_id' => 'Transaction ID',
            'vendor' => 'Vendor',
            'open' => 'Open',
            'ptype' => 'Ptype',
            'bank' => 'Bank',
            'aorb' => 'Aorb',
            'tlink' => 'Tlink',
            'shop_id' => 'Shop ID',
            'details' => 'Details',
            'staff' => 'Staff',
            'chart_account' => 'Chart Account',
            'chart_account2' => 'Chart Account2',
            'account_group' => 'Account Group',
            'account_group2' => 'Account Group2',
            'entry_group' => 'Entry Group',
            'entry_group2' => 'Entry Group2',
            'entry_type' => 'Entry Type',
            'entry_type2' => 'Entry Type2',
            'dsource' => 'Dsource',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'payment_method' => 'Payment Method',
            'table_no' => 'Table No',
            'leg2_link' => 'Leg2 Link',
            'invoice' => 'Invoice',
            'shift' => 'Shift',
            'stamp' => 'Stamp',
            'fin' => 'Fin',
            'discount' => 'Discount',
            'reservation_deposit' => 'Reservation Deposit',
        ];
    }

    public function getCharts2()
    {
        return  $this->hasMany(Charts::className(),['id'=>'chart_account'])
        ->viaTable('Clients',['cid'=>'cid']);
    }

    
}
