<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\models\Ledger;

/**
 * SearchLedger represents the model behind the search form of `frontend\models\Ledger`.
 */
class SearchLedger extends Ledger
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'cid', 'department'], 'integer'],
            [['credit', 'debit'], 'number'],
            [['description'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Ledger::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'cid' => $this->cid(),
            'department' => $this->department,            
            'credit' => $this->credit,
            'debit' => $this->debit,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

         $query->andFilterWhere(['like', 'description', $this->description]);

        return $dataProvider;
    }

       public function cid()
    {
        return Yii::$app->user->identity->cid;
    }
}
