<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "shelves".
 *
 * @property int $id
 * @property string $shelf_name
 * @property int $cid
 * @property string $created_at
 */
class Shelves extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'shelves';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['shelf_name', 'cid', 'created_at'], 'required'],
            [['cid'], 'integer'],
            [['created_at'], 'safe'],
            [['shelf_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'shelf_name' => 'Shelf Name',
            'cid' => 'Cid',
            'created_at' => 'Created At',
        ];
    }
}
