<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "vendors".
 *
 * @property int $id
 * @property string $name
 * @property string $address
 * @property string $phone
 * @property string $contact_name
 * @property int $cid
 * @property string $created_at
 * @property string $updated_at
 */
class Vendors extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'vendors';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'address', 'phone', 'contact_name', 'cid'], 'required'],
            [['address'], 'string'],
            [['cid'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['name'], 'string', 'max' => 60],
            [['phone'], 'string', 'max' => 25],
            [['contact_name'], 'string', 'max' => 200],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'address' => 'Address',
            'phone' => 'Phone',
            'contact_name' => 'Contact Name',
            'cid' => 'Cid',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

   
}
