<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Charts;
use frontend\models\ChartsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\models\Leap;
use yii\filters\AccessControl;

/**
 * ChartsController implements the CRUD actions for Charts model.
 */
class ChartsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                // [
                //     'allow' => true,
                //     'actions' => ['index','dledger'],
                //     //'roles' => ['viewInventoryRole'],
                //     'roles' => ['@'],
                // ],
                [
                    'allow' => true,
                    'actions' => ['index','create','update','view','findModel','pdf','code','code2'],
                    'roles' => ['Client Admin','accounts'],
                ],        
                  
                     ],
                
                
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Charts models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ChartsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Charts model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Charts model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Charts();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Charts model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Charts model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        die('You cant do this');
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Charts model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Charts the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Charts::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionCode()
    {
        ob_start();
        $id=Yii::$app->request->post('code');  
       
        $dcode=Charts::find()->where(['anumber'=>$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one(); 
        //$find=Leap::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['staff'=>Yii::$app->user->identity->id])->andWhere(['se'=>$type])->one();

      

    
        echo json_encode(array('did'=>$dcode->id,'dname'=>$dcode->title)); 
    }


    public function actionCode2()
    {
        ob_start();
        $id=Yii::$app->request->post('code');  
        $bas=Yii::$app->request->post('bas');
        $type=Yii::$app->request->post('ty');
        $dcode=Charts::find()->where(['anumber'=>$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one(); 
        $find=Leap::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['staff'=>Yii::$app->user->identity->id])->andWhere(['se'=>$type])->one();

       $point=0;
        
        if($find!=NULL){
           // Leap::deleteAll()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['staff'=>Yii::$app->user->identity->id]);
            if($bas=='credit'){ $find->credit_code=$dcode->id; }elseif($bas=='debit'){ $find->debit_code=$dcode->id; }
            if($find->save()){ $point=1; }
        }else{

        $leap = new Leap();
        $leap->cid=Yii::$app->user->identity->cid;
        $leap->staff=Yii::$app->user->identity->id;
        $leap->se=$type;

        if($bas=='credit'){
        $leap->credit_code=$dcode->id;
        $leap->debit_code=0;
    }   
        if($bas=='debit'){        
        $leap->debit_code=$dcode->id;
        $leap->credit_code=0;
    }

        if($leap->save())
        {
            $point=1;
        } else{ //throw new \Exception("Error Processing Request");
        var_dump($leap->getErrors());
         }      

    }
      if($point==1){  echo json_encode(array('did'=>$dcode->id,'dname'=>$dcode->title)); }
    }


    public function actionPdf(){
        Yii::$app->response->format = 'pdf';
        $this->layout = '//print';
        return $this->render('myview', []);
    }

}
