<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Ledger;
use frontend\models\LedgerDel;
use frontend\models\SearchLedger;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\data\Pagination;
use yii\filters\AccessControl;
use frontend\models\Banks;
use frontend\models\Requisitions;

use backend\models\Clients;
use backend\models\User;
use backend\models\Workflow;
use frontend\models\Customers;
use yii\helpers\Html;
use frontend\models\Inventory;
use frontend\models\Ledgergo;
use frontend\models\Stores;
use frontend\models\StoresHistory;
use frontend\models\ShopHistory;
use frontend\models\Config;
use frontend\models\Shops;
use frontend\models\Taken;
use frontend\models\Dels;
use frontend\models\Discounts;
use frontend\models\Vendors;
use frontend\models\Charts;
use frontend\models\Entry;
use frontend\models\Tabs;
use frontend\models\Ledger2;
use yii\web\Session;
// echo Yii::getAlias('@vendor');
// die;

require Yii::getAlias('@vendor') . '/mike42/escpos-php/autoload.php';
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
        use Mike42\Escpos\Printer;
         

date_default_timezone_set('Africa/Lagos');

/**
 * LedgerController implements the CRUD actions for Ledger model.
 */
class LedgerController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
              'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','create','update','findModel','begining','cashbook',
                    'cash','debtors','tdetails','cashbookk','creditors','cdetails','reverse',
                    'reverseit','sales','get_receipt','last_receipt','history','history2','pay','payc',
                    'ledgergo','dis','trial','balance','entry','create2','accounts','remove_single_transaction'],
                    'roles' => ['accounts','Client Admin'],
                ],
                  [
                    'allow' => true,
                    'actions' => ['delete','do_discount'],  
                    'roles' => ['Client Admin']                 
                ],
                [
                    'allow' => true,
                    'actions' => ['save_payment','save_payment2','push_discount','start_reverse','do_rev','cash_transfer'],  
                    'roles' => ['accounts']                 
                ],
                   [
                    'allow' => true,
                    'actions' => ['rev','new_reverseit','remove_single_transaction','ignore'],  
                    'roles' => ['Shop Manager','Store Manager']                 
                ],
                  [
                    'allow' => true,
                    'actions' => ['retail','getitemr','addr','addr2','clearcart','closesale','bringr','update_quantity',
                    'remove_byid','allcart','getfastfood','lprint','details','ignore_discount','closesale22','closesale23','add',
                    'close','do_add','do_close','editl','closesale24','sale_details','sale_edit','tabs','update_quantityr1',
                    'remove_byidr1','closesale25','tab_list','getlaundry','sales_list','adjust','made'],  
                    'roles' => ['@']                 
                ],
                //  [
                //     'allow' => true,
                //     'actions' => ['error'],  
                //     'roles' => ['?','@']                 
                // ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

     /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

   

    /**
     * Lists all Ledger models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SearchLedger();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Ledger model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Ledger model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Ledger();

        if ($model->load(Yii::$app->request->post())) {

            $debit=str_replace(',', '', $model->debit);
            $credit=str_replace(',', '', $model->credit);

            $model->debit=$debit;
            $model->credit=$credit;

            if(!$model->save())
            {
                var_dump($model->getErrors()); die;
            }
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Ledger model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            

            $debit=str_replace(',', '', $model->debit);
            $credit=str_replace(',', '', $model->credit);

            $model->debit=$debit;
            $model->credit=$credit;

            if(!$model->save())
            {
                var_dump($model->getErrors()); die;
            }
            
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Ledger model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Ledger model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Ledger the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Ledger::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionBegining()
    {
        die('You cannot do this');
        $model = new Ledger();
        if(isset($_POST['Ledger']))
        {
            if ($model->load(Yii::$app->request->post())) {

            $debit=str_replace(',', '', $model->debit);
            $credit=str_replace(',', '', $model->credit);

            $model->debit=$debit;
            $model->credit=$credit;
            $model->amount_paid=$credit;
            $model->transaction_id=time().rand(1,12);
            $model->description='Opening Balance';
            $model->vendor="Client Opening Balance";
            $model->open=7;

            if(!$model->save())
            {
                var_dump($model->getErrors()); die;
            }
            return $this->redirect(['view', 'id' => $model->id]);
        }
        }
        return $this->render('begining',['model'=>$model]);
    }

    public function actionCashbook()
    {
       

        //preparing the query
        // $baba=0;
        // if(!empty(Yii::$app->request->get('mbal')) || Yii::$app->request->get('mbal')!=0)
        // {
        //     echo Yii::$app->request->get('mbal'); die;
        // }

       $query = Ledger::find()->where(['=','cid',Yii::$app->user->identity->cid]);
       // get the total number of users
       $count = $query->count();
       //creating the pagination object
       $pagination = new Pagination(['totalCount' => $count, 'defaultPageSize' => 100]);
       //limit the query using the pagination and retrieve the users
      // $pagination->pageParam='page';
     // $pagination->params=['page'=>Yii::$app->request->get('page'),'bal'=>$baba];
       $models = $query->offset($pagination->offset)
          ->limit($pagination->limit)
          ->all();

          // foreach($models as $mod)
          // {
          //   $bal+=($mod->credit-$mod->debit);
          // }
          
       return $this->render('cashbook', [
          'model' => $models,
          'pages' => $pagination,
       ]);

       
    }

    public function actionCash()
    {
        $records = new ActiveDataProvider(['query' => Ledger::find()->where(['=','cid',Yii::$app->user->identity->cid]),
            'pagination'=>['pageSize'=>10],

            ]);
        return $this->render('cash',['records'=>$records]);
    }

    public function actionDebtors()
    {
        // $debtors=Ledger::find()->where(['sum','amount_paid','credit'])->all();
        $query="select sum(credit) as credit, sum(amount_paid) as amount_paid, transaction_id, vendor from ledger where ptype=1 and cid='".Yii::$app->user->identity->cid."' group by vendor";
        $debtors=Ledger::findBySql($query)->all();

//         echo "<pre>";
// var_dump($debtors); 
// echo "</pre>";

// die;
        return $this->render('debtors',['debtors'=>$debtors]);
    }

    public function actionTdetails($id)
    {
        $records=Ledger::find()->where(['=','vendor',$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['aorb'=>1])->andWhere(['>','credit',0])->orderBy('id desc')->all();
        return $this->render('tdetails',['records'=>$records]);
    }


    public function actionCdetails($id)
    {
        $records=Ledger::find()->where(['=','vendor',$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['aorb'=>1])->andWhere(['>','debit',0])->orderBy('id desc')->all();
        $balances=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
        return $this->render('cdetails',['records'=>$records,'balances'=>$balances]);
    }

    public function actionCreate2()
  {
     
     ob_start();
     $done=0;
     $amount=Yii::$app->request->Post('amount');
     // $entry_group=Yii::app()->request->getPost('entry_group');
     $entry_type=Yii::$app->request->Post('entry_type');
     $chart_account=Yii::$app->request->Post('chart_account');

     $entry_type2=Yii::$app->request->Post('entry_type2');
     $chart_account2=Yii::$app->request->Post('chart_account2');
  


  $ac1=Charts::findOne($chart_account);
  $entry_group=$ac1->atype;
  $account_group=$ac1->account_group;


     
     // account type or atype in charts
    // if(empty($account_group)){ die('There was a problem. Please try again 2!'); }

            $transaction = Yii::$app->db->beginTransaction();
 try {

     if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
      {
        $amount=($amount*-1);
      }
      if($entry_type==2 && ($entry_group==1 || $entry_group==5))
      {
        $amount=($amount*-1);
      }

// debit entry


    $enter= new Entry();
    $enter->entry_type=$entry_type;
    $enter->entry_group=$entry_group;
    $enter->amount=$amount;
    $enter->chart_account=$chart_account;
    $enter->account_group=$account_group;
    $enter->cid=Yii::$app->user->identity->cid;
    $enter->who=Yii::$app->user->identity->id;
    $enter->created_at=date('Y-m-d');

    $enter->dsource='m';
if(!$enter->save()){ throw new \Exception('could not save entry1');
//throw new CHttpException(403, 'You are not authorized to perform this action.');
//var_dump($enter->getErrors()); 
}

    // credit entry
$amount=abs($amount);
//$amount=Yii::app()->request->getPost('amount');
     $ac2=Charts::findOne($chart_account2);
     $entry_group2=$ac2->atype;
     $account_group2=$ac2->account_group;

      if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
      {
        $amount=($amount*-1);
      }
      if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
      {
        $amount=($amount*-1);
      }

    $enter2= new Entry();
    $enter2->entry_type=$entry_type2;
    $enter2->entry_group=$entry_group2;
    $enter2->amount=$amount;
    $enter2->chart_account=$chart_account2;
    $enter2->account_group=$account_group2;
    $enter2->cid=Yii::$app->user->identity->cid;
    $enter2->who=Yii::$app->user->identity->id;
    $enter2->created_at=date('Y-m-d');

    $enter2->dsource='m';
    
    
    if(!$enter2->save()){ throw new \Exception('could not save entry2');
    //throw new CHttpException(403, 'You are not authorized to perform this action.');
    //var_dump($enter2->getErrors());
     
      }else{ $done=1; }



  $transaction->commit();
   echo $done;
            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; 
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; 
            }
    
  }


  public function actionAccounts()
  {
     $model= new Entry;
     $charts=Charts::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

      if(Yii::$app->request->post()){
        
        
        $target=null;
        $date1=Yii::$app->request->post('date1');
        $date2=Yii::$app->request->post('date2');
        if(Yii::$app->request->post('chart_account')){
        $target=Yii::$app->request->post('chart_account');
        }
      }
    return $this->render('accounts',array('charts'=>$charts,'model'=>$model,'date1'=>$date1,'date2'=>$date2,'target'=>$target));
  }



    public function actionSave_payment()
    {
        ob_start();
        $done=0;

            $transaction = Yii::$app->db->beginTransaction();
 try {

        $rid=Yii::$app->request->post('rid'); 
        $amount=Yii::$app->request->post('amount');
        $bank=Yii::$app->request->post('bank');
        // $record=Ledger::find()->where(['=','id',$rid])->one();
        $record=Ledger::findOne($rid);
        $chart_account=Yii::$app->request->post('chart_account');
        $chart_account2=Yii::$app->request->post('chart_account2');
        $entry_type=Yii::$app->request->post('entry_type');
        $entry_type2=Yii::$app->request->post('entry_type2');

        $ac1=Charts::findOne($chart_account);
        $ac2=Charts::findOne($chart_account2);

        $entry_group=$ac1->atype;
        $entry_group2=$ac2->atype;

        $account_group=$ac1->account_group;
        $account_group2=$ac2->account_group;
if(empty($record->transaction_id)){ die('its empty'); }
        $querya="select sum(amount_paid) from ledger where tlink='".$record->transaction_id."'";
  $saj = Yii::$app->db->createCommand($querya)->queryScalar(); 

if(($amount+$saj+$record->amount_paid)<=$record->credit)
{
        $new = new Ledger();
        $new->amount_paid+=$amount;
        $new->bank=$bank;
        $new->cid=$record->cid;
        $new->department=$record->department;
        $new->description=$record->description;
        $new->credit=0;
        $new->amount_paid=$amount;
        $new->transaction_id=time().rand(1,9);
        $new->debit=$record->debit;
        $new->vendor=$record->vendor;
        $new->open=$record->open;
        $new->ptype=$record->ptype;
        $new->staff=Yii::$app->user->identity->id;
        $new->aorb=2;
        $new->tlink=$record->transaction_id;
        $new->shop_id=$shop_id;
        $new->dsource='inc';

        $new->chart_account=$chart_account;
        $new->entry_type=$entry_type;
        $new->chart_account2=$chart_account2;
        $new->entry_type2=$entry_type2;
        $new->account_group=$account_group;
        $new->account_group2=$account_group2;
        $new->entry_group=$entry_group;
        $new->entry_group2=$entry_group2;


        if($record->shop_id==null)
        {
          //throw new \Exception('Shop ID is empty');
         // $shop_id=1;
        }

       // $npaid= $record->amount_paid+=$amount;
        if($new->save())
        {
            $done=1;

                    $dbank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['bid'=>$bank])->one();
                    $dbank->balance+=$amount;
                    if(!$dbank->save())
                    {
                       throw new \Exception( 'could not save to bank' );
                    }
        }else{
          throw new \Exception( 'could not save to cashbook or ledger' );
          // var_dump($new->getErrors());
        }
    
    
    // entry stuff

      if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
      {
        $amount=($amount*-1);
      }
      if($entry_type==2 && ($entry_group==1 || $entry_group==5))
      {
        $amount=($amount*-1);
      } 

      $enter = new Entry;
        $enter->amount=$amount;
        $enter->entry_type=$entry_type;
        $enter->entry_group=$entry_group;
        $enter->chart_account=$chart_account;       
        
        $enter->account_group=$account_group;
        $enter->who=Yii::$app->user->identity->id;
        $enter->cid=Yii::$app->user->identity->cid;
        $enter->created_at=date('Y-m-d');
        $enter->fid=$new->id;
        $enter->dsource='p';
        $enter->transaction_id=$record->transaction_id;
        $enter->lid=$new->id;
        
        if(!$enter->save())
        {
          //var_dump($enter->getErrors()); die;
          throw new \Exception('Could not save entry');
        }

        // second entry

        $amount=abs($amount);
        // entry 2

      if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
      {
        $amount=($amount*-1);
      }
      if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
      {
        $amount=($amount*-1);
      }


        $enter2 = new Entry;
        $enter2->amount=$amount;
        $enter2->entry_type=$entry_type2;
        $enter2->entry_group=$entry_group2;
        $enter2->chart_account=$chart_account2;
    
        $enter2->account_group=$account_group2;
        $enter2->who=Yii::$app->user->identity->id;
        $enter2->cid=Yii::$app->user->identity->cid;
        $enter2->created_at=date('Y-m-d');
        $enter2->fid=$new->id;
        $enter2->dsource='p';
        $enter2->transaction_id=$record->transaction_id;
        $enter2->lid=$new->id;
        if(!$enter2->save())
        {
          //var_dump($enter2->getErrors()); die;
          throw new \Exception('Could not save entry2');
        }
$amount=abs($amount);
        $all=json_encode(array('done'=>$done,'npaid'=>$record->amount_paid+$saj+$amount,'nout'=>$record->credit-$record->amount_paid-$saj-$amount));
        echo $all;
      }else{
        $all=json_encode(array('done'=>'3'));
        echo $all;
      }

      

       $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }

    }


    // save payment2

    public function actionSave_payment2()
    {
        ob_start();
        $done=0;

        $rid=Yii::$app->request->post('rid');
        $amount=Yii::$app->request->post('amount');
        $bank=Yii::$app->request->post('bank');
        //$record=Ledger::find()->where(['=','id',$rid])->one();

        $cbank=Banks::findOne($bank);

        $record=Ledger::findOne($rid);
        $chart_account=Yii::$app->request->post('chart_account');
        $chart_account2=Yii::$app->request->post('chart_account2');
        $entry_type=Yii::$app->request->post('entry_type');
        $entry_type2=Yii::$app->request->post('entry_type2');

        $ac1=Charts::findOne($chart_account);
        $ac2=Charts::findOne($chart_account2);

        $entry_group=$ac1->atype;
        $entry_group2=$ac2->atype;

        $account_group=$ac1->account_group;
        $account_group2=$ac2->account_group;

        $querya="select sum(amount_paid) from ledger where tlink='".$record->transaction_id."'";
  $saj = Yii::$app->db->createCommand($querya)->queryScalar(); 

if($cbank->balance>$amount){
if(($amount+$saj+$record->amount_paid)<=$record->debit)
{
        $new = new Ledger();
        $new->amount_paid+=$amount;
        $new->bank=$bank;
        $new->cid=$record->cid;
        $new->department=$record->department;
        $new->description=$record->description;
        $new->credit=0;
        $new->amount_paid=$amount;
        $new->transaction_id=time().rand(1,9);
        $new->debit=0;
        $new->vendor=$record->vendor;
        $new->open=$record->open;
        $new->ptype=$record->ptype;
        $new->aorb=2;
        $new->staff=Yii::$app->user->identity->id;
        $new->tlink=$record->transaction_id;
        $new->dsource='exp';

        $new->chart_account=$chart_account;
        $new->entry_type=$entry_type;
        $new->chart_account2=$chart_account2;
        $new->entry_type2=$entry_type2;
        $new->account_group=$account_group;
        $new->account_group2=$account_group2;
        $new->entry_group=$entry_group;
        $new->entry_group2=$entry_group2;

       // $npaid= $record->amount_paid+=$amount;
        if($new->save())
        {
            $done=1;

           $dbank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['bid'=>$bank])->one();
           $dbank->balance-=$amount;
          $dbank->save();
        }


        // entry stuff

      if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
      {
        $amount=($amount*-1);
      }
      if($entry_type==2 && ($entry_group==1 || $entry_group==5))
      {
        $amount=($amount*-1);
      } 

      $enter = new Entry;
        $enter->amount=$amount;
        $enter->entry_type=$entry_type;
        $enter->entry_group=$entry_group;
        $enter->chart_account=$chart_account;       
        
        $enter->account_group=$account_group;
        $enter->who=Yii::$app->user->identity->id;
        $enter->cid=Yii::$app->user->identity->cid;
        $enter->created_at=date('Y-m-d');
        $enter->fid=$new->id;
        $enter->dsource='po';
        $enter->transaction_id=$record->transaction_id;
        $enter->lid=$new->id;
        
        if(!$enter->save())
        {
          //var_dump($enter->getErrors()); die;
          throw new \Exception('Could not save entry');
        }

        // second entry

        $amount=abs($amount);
        // entry 2

      if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
      {
        $amount=($amount*-1);
      }
      if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
      {
        $amount=($amount*-1);
      }


        $enter2 = new Entry;
        $enter2->amount=$amount;
        $enter2->entry_type=$entry_type2;
        $enter2->entry_group=$entry_group2;
        $enter2->chart_account=$chart_account2;
    
        $enter2->account_group=$account_group2;
        $enter2->who=Yii::$app->user->identity->id;
        $enter2->cid=Yii::$app->user->identity->cid;
        $enter2->created_at=date('Y-m-d');
        $enter2->fid=$new->id;
        $enter2->dsource='po';
        $enter2->transaction_id=$record->transaction_id;
        $enter2->lid=$new->id;
        if(!$enter2->save())
        {
          //var_dump($enter2->getErrors()); die;
          throw new \Exception('Could not save entry2');
        }
$amount=abs($amount);
        $all=json_encode(array('done'=>$done,'npaid'=>$record->amount_paid+$saj+$amount,'nout'=>$record->debit-$record->amount_paid-$saj-$amount));
        echo $all;
      }else{ $all=json_encode(array('done'=>3));
echo $all; }
    }else{ 

$all=json_encode(array('done'=>2));
echo $all;

    }

    }

    public function actionCashbookk()
    {
      
     $from=Yii::$app->request->post('from');
     $to=Yii::$app->request->post('to');
     $bank=Yii::$app->request->post('bank');

     //$leave=Ledger::find()->where(['<','created_at',$from]) ->all();
if(empty($bank)){
       $querya="select sum(amount_paid) from ledger where SUBSTR(created_at,1,10)<'".$from."' && cid='".Yii::$app->user->identity->cid."' && ptype=1";
       $querya1="select sum(amount_paid) from ledger where SUBSTR(created_at,1,10)<'".$from."' && cid='".Yii::$app->user->identity->cid."' && ptype=2";
     }else{
       $querya="select sum(amount_paid) from ledger where SUBSTR(created_at,1,10)<'".$from."' && bank='".$bank."' && cid='".Yii::$app->user->identity->cid."' && ptype=1";
       $querya1="select sum(amount_paid) from ledger where SUBSTR(created_at,1,10)<'".$from."' && bank='".$bank."' && cid='".Yii::$app->user->identity->cid."' && ptype=2";
     }
  $bal = Yii::$app->db->createCommand($querya)->queryScalar(); 
  $bal1 = Yii::$app->db->createCommand($querya1)->queryScalar(); 
  $allbal=$bal-$bal1;

     $balances=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

     if(Yii::$app->request->post()){ 
          $query = Ledger::find()->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['between','SUBSTR(created_at,1,10)',$from,$to])->andWhere(['!=','amount_paid',0]);

          if(!empty($bank)){
            $query=$query->andWhere(['bank'=>$bank]);
          }

          $query=$query->all();

       return $this->render('cashbookk', [
          'model' => $query,
          'balances' => $balances,
          'bank' => $bank,
          'out' => $allbal,
        'from' => $from,
          'to' => $to,
         
       ]);
     }else{

      return $this->render('cashbookk',['balances' => $balances]);
    }
    }

    public function actionCreditors()
    {
        // $debtors=Ledger::find()->where(['sum','amount_paid','credit'])->all();
        $query="select sum(debit) as debit, sum(amount_paid) as amount_paid, transaction_id, vendor from ledger where ptype=2 and cid='".Yii::$app->user->identity->cid."' group by vendor";
        $creditors=Ledger::findBySql($query)->all();

        return $this->render('creditors',['creditors'=>$creditors]);
    }

    public function actionReverse()
    {
      if(Yii::$app->request->post())
      {
        $tid=trim(Yii::$app->request->post('tid'));
        $to=Yii::$app->request->post('to');
        $from=Yii::$app->request->post('from');

        $reverse = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
            ->where('id!=:sam', [':sam' => 0])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid]);
            
            if(!empty(Yii::$app->request->post('from')) && !empty(Yii::$app->request->post('to')))
            {
                $reverse=$reverse->andWhere(['between','SUBSTR(created_at,1,10)',Yii::$app->request->post('from'), Yii::$app->request->post('to')]);
            }


            if(!empty(Yii::$app->request->post('tid')))
            {
                $reverse=$reverse->andWhere(['=','transaction_id',$tid]);
            }

            $reverse=$reverse->andWhere(['!=','ptype',0])->andWhere(['aorb'=>1]);

            $reverse=$reverse->all();
                     
            

      }
      return $this->render('reverse',['reverse'=>$reverse]);
    }

    public function actionReverseit()
    {
      $tid=Yii::$app->request->get('tid'); 

       


       $transaction = Yii::$app->db->beginTransaction();
 try {
$ben=Ledger::find()->where(['transaction_id'=>$tid])->one();
//$links=Ledger::find()->where(['tlink'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->all();

if($ben->tlink==NULL)
{
  $ben=Ledger::find()->where(['transaction_id'=>$tid])->one();
}else{
  $ben=Ledger::find()->where(['tlink'=>$tid])->one();
}
$del2=Requisitions::find()->where(['transaction_id'=>$tid])->one();

     // if(!$del=Ledger::deleteAll(['transaction_id'=>$tid]))
     // {
     //   throw new \Exception('could not delete from ledger'); 
     // }
      


      // $kept=new LedgerDel();
      // $kept->setAttributes($ben);
      // if(!$kept->save())
      // {
      //    throw new \Exception('could not save to could no save to ledgerdel'); 
      // }

       

if($del2->concluded==1){
       $items=json_decode($del2->requested_item,true);

       foreach($items as $it)
       {
       
       
        if($del2->task_type==1)
        {
           $bobo=Stores::findOne($it['item_id']);
           if($bobo->deductable==1){
           $bobo->quantity-=$it['quantity'];
         }
        }

        if($del2->task_type==2)
        {
           $bobo=Inventory::find()->where(['item_id'=>$it['item_id']])->one();
           if($bobo->deductable==1){
           $bobo->quantity+=$it['quantity'];
         }
        }
        if(!$bobo->save())
        {
          throw new \Exception('could not save to Inventory'); 
        } 
       }
     }
   
       

        
// foreach($links as $link)
// {
//   $can=Banks::findOne($link->bank);
//         if($link->ptype==1){
//         $can->balance-=$link->amount_paid;
//       }

//           if($link->ptype==2){
//         $can->balance+=$link->amount_paid;
//       }
//       if(!$can->save())
//       {
//          throw new \Exception('could not save to bank' ); 
//       }

        
//       if(!$link->delete())
//       {
//          throw new \Exception('could not delete balance payments on transaction from ledger' ); 
//       }
    
     
//       if(!$del2->delete())
//        {
//          throw new \Exception('could not Delete from Requisitions' ); 
//        }
//      }


      if($ben->tlink!=NULL){
      $can=Banks::findOne($ben->bank);
      if($ben->ptype==1){
        $can->balance-=$ben->amount_paid;
      }

      if($ben->ptype==2){
        $can->balance+=$ben->amount_paid;
      }
      if(!$can->save())
      {
         throw new \Exception('could not save to bank' ); 
      }
    }

        
      // if(!$link->delete())
      // {
      //    throw new \Exception('could not delete balance payments on transaction from ledger' ); 
      // }
    
     
      if(!$del2->delete())
       {
         throw new \Exception('could not Delete from Requisitions' ); 
       }
     
  

    if(!$ben->delete()){
        throw new \Exception('could not delete entry from ledger' ); 
      }

       $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }

        

       return $this->redirect(['reverse']);


    }

    public function actionSales()
    {

      if(Yii::$app->request->post())
      {
         $from=Yii::$app->request->post('from');
         $to=Yii::$app->request->post('to');
        $tid=Yii::$app->request->post('tid');

         $sales=Ledger::find()->where(['aorb'=>2])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['ptype'=>1]);
         if(!empty($from) || !empty($to))
         {
           $sales=$sales->andWhere(['between','SUBSTR(created_at,1,10)',$from,$to]);
         }
         if(!empty($tid))
         {
            $sales=$sales->andWhere(['transaction_id'=>$tid]);
         }
         $sales=$sales->orderBy('id desc')->all();

      }else{
         $sales=Ledger::find()->where(['aorb'=>2])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['ptype'=>1])->orderBy('id desc')->all();
      }

     
      return $this->render('sales',['sales'=>$sales]);
    }

    public function actionGet_receipt()
    {
      ob_start();
      $tid=Yii::$app->request->post('tid');
      $tlink=Yii::$app->request->post('tlink');

      $main=Ledger::find()->where(['transaction_id'=>$tlink])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
      $adds=Ledger::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();

      $client=Clients::findOne(Yii::$app->user->identity->cid);

        $fat=Requisitions::find()->where(['transaction_id'=>$tlink])->one();
      
      $cro=json_decode($fat->requested_item,true);

      ?>

            <div id="holder" style="width:100%;">
<h1 style="text-align:center;">Sales Receipt</h1>
<table class="table table-bordered" style="">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:12px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">SALES RECEIPT</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO: <?php echo $tid; ?></td>
</tr>



  <tr style="font-weight:bold;">
  
    <td colspan="2">Recieved from: <?= ucwords($main->customer->name) ?> </td>
  </tr>

  <tr style="font-weight:bold;">
    <?php
    // $total=0;
    // $goods='';
    //   foreach(json_decode($record->requested_item,true) as $item)
    //   {
    //     $total+=$item['total'];
    //     $goods.=$item['item_name'].', ';
    //   }
    ?>
  
    <td colspan="2">The sum of:<span style="font-weight:normal;"> <?php echo ucwords(Yii::$app->Formatter->asSpellout($adds['amount_paid'])); ?> Naira Only.</span></td>
  </tr>
  <tr style="font-weight:bold;">
  
    <td colspan="2">Being payment for : <span style="font-weight:normal;"> <?= empty($cro[0]['narration']) ? 'Goods Purchased' : ucfirst($cro[0]['narration']) ?> on <span sytle='font-weight:bold; color:red;'><?= $tlink ?></span> </span> </td>
  </tr>

  </tr>


  <tr style="font-weight:bold;">
   <td>Company Rep: <span style="font-weight:normal;"><?php $name=User::findOne(Yii::$app->user->identity->id); echo ucwords($name->first_name." ".$name->last_name); ?></span> </td>
    
    <td>Amount Paid: <del>N</del> <?php echo number_format($adds['amount_paid'],2); ?></td>
    
  </tr>

 
<tr>
<td colspan="2" id="noshow" style="text-align:right;"><?= Html::button('Print Receipt',['class'=>'btn btn-primary','onclick'=>'print()','style'=>'']) ?></td>
</tr>

</table>
</div>

      <?php
    }


    // show last

    public function actionLast_receipt()
    {
      ob_start();
      $tid=Yii::$app->request->post('tid');
      // $tlink=Yii::$app->request->post('tlink');

      $main=Ledger::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
      $adds=Ledger::find()->where(['tlink'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orderBy('id desc')->one();

      $client=Clients::findOne(Yii::$app->user->identity->cid);

      $fat=Requisitions::find()->where(['transaction_id'=>$tid])->one();
      
      $cro=json_decode($fat->requested_item,true);


      ?>

            <div id="holder" style="width:100%;">
<h1 style="text-align:center;">Sales Receipt</h1>
<table class="table table-bordered" style="">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:12px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">SALES RECEIPT</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO: <?php echo $tid; ?></td>
</tr>




  <tr style="font-weight:bold;">
  <?php //ucwords(Customers::findOne($main->vendor)->name) ?>
    <td colspan="2">Recieved from: <?=  ucwords($main->customer->name) ?> </td>
  </tr>

  <tr style="font-weight:bold;">
    <?php
    // $total=0;
    // $goods='';
    //   foreach(json_decode($record->requested_item,true) as $item)
    //   {
    //     $total+=$item['total'];
    //     $goods.=$item['item_name'].', ';
    //   }
    ?>
  
    <td colspan="2">The sum of:<span style="font-weight:normal;"> <?php echo ucwords(Yii::$app->Formatter->asSpellout($adds['amount_paid'])); ?> Naira Only.</span></td>
  </tr>
  <tr style="font-weight:bold;">
  
    <td colspan="2">Being payment for : <span style="font-weight:normal;"><?= empty($cro[0]['narration']) ? 'Goods Purchased' : ucfirst($cro[0]['narration']) ?> <?php //echo ucwords($goods); ?> </span> </td>
  </tr>

  </tr>
  <tr style="font-weight:bold;">
  
    <td>Company Rep: <span style="font-weight:normal;"><?php $name=User::findOne(Yii::$app->user->identity->id); echo ucwords($name->first_name." ".$name->last_name); ?></span> </td>
    <td>Amount Paid: <del>N</del> <?php echo number_format($adds['amount_paid'],2); ?></td>
  </tr>




<tr>
<td colspan="2" id="noshow" style="text-align:right;"><?= Html::button('Print Receipt',['class'=>'btn btn-primary','onclick'=>'print()','style'=>'']) ?></td>
</tr>

</table>
</div>

      <?php
    }



     public function actionHistory()
    {
      ob_start();
      $tid=Yii::$app->request->post('tid');
      // $tlink=Yii::$app->request->post('tlink');

      $main=Ledger::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
      $adds=Ledger::find()->where(['tlink'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orWhere(['transaction_id'=>$tid])->andWhere(['!=','amount_paid',0])->orderBy('id desc')->all();

      ?>
      <div style="font-weight:bold;"><?= "Sale Value: ".number_format($main->credit,2) ?></div>
<table class="table table-bordered table-striped">
<tr>
<th>Date</th>
<th>Amount Paid</td>
<td>Balance</th>
</tr>
<?php
foreach($adds as $add)
{
  ?>
<tr>
<td><?= date('jS F Y',strtotime($add->created_at)) ?></td>
<td><?= number_format($add->amount_paid,2) ?></td>
<td><?= number_format($main->credit-=$add->amount_paid,2) ?></td>
</tr>
  <?php
}

?>

</table>

      <?php

      }




    public function actionHistory2()
    {
      ob_start();
      $tid=Yii::$app->request->post('tid');
      // $tlink=Yii::$app->request->post('tlink');

      $main=Ledger::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
      $adds=Ledger::find()->where(['tlink'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orWhere(['transaction_id'=>$tid])->andWhere(['!=','amount_paid',0])->orderBy('id desc')->all();

      ?>
      <div style="font-weight:bold;"><?= "Expenditure Value: ".number_format($main->debit,2) ?></div>
<table class="table table-bordered table-striped">
<tr>
<th>Date</th>
<th>Amount Paid</td>
<td>Balance</th>
</tr>
<?php
foreach($adds as $add)
{
  ?>
<tr>
<td><?= date('jS F Y',strtotime($add->created_at)) ?></td>
<td><?= number_format($add->amount_paid,2) ?></td>
<td><?= number_format($main->debit-=$add->amount_paid,2) ?></td>
</tr>
  <?php
}

?>

</table>

      <?php

      }



      public function actionPay($tid,$tlink=0,$id)
      {
         $record=Requisitions::find()->where(['transaction_id'=>$tid])->one();
         return $this->render('payment_voucher',['tid'=>$tid,'record'=>$record,'tlink'=>$tlink,'id'=>$id]);
      }

        public function actionPayc($tid,$tlink=0,$id)
      {
         $record=Requisitions::find()->where(['transaction_id'=>$tid])->one();
         return $this->render('invoice',['tid'=>$tid,'record'=>$record,'tlink'=>$tlink,'id'=>$id]);
      }

      public function actionRetail($stype)
      {
        $this->layout='column1';
        // $type=Shops::findOne(Yii::$app->user->identity->shop_id)->shop_type;

        switch ($stype) {
          case '1':
            return $this->render('retail');
            break;           

            case '3':
            //$rooms=Inventory::find()->where(['shop_id'=>Yii::$app->user->identity->shop_id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->all();
            $query="select * from inventory where shop='".Yii::$app->user->identity->shop_id."' and cid='".Yii::$app->user->identity->cid."'";
            $rooms = Yii::$app->db->createCommand($query)->queryAll(); 
            $model= new Taken();
            return $this->render('rooms',['rooms'=>$rooms,'model'=>$model]);
            break;

            case '2':
            return $this->render('bar');
            break;

            case '4':
            return $this->render('kitchen');
            break;

            case '5':
            return $this->render('fastfood');
            break;

            case '6':
            return $this->render('standard');
            break;

            case '7':
            return $this->render('laundry');
            break;
          
          default:
            return $this->render('nknown');
            break;
        }
        
      }

      public function actionGetitemr()
      {
        ob_start();
        $item=Yii::$app->request->post('item');
        if(!empty($item)){
        $find=Inventory::find()->where(['like','name',$item])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['!=','quantity',0])->andWhere(['!=','price',0])->andWhere(['=','shop',Yii::$app->user->identity->shop_id])->limit(5)->all();
        
        foreach($find as $f)
        {
          ?>
<div style="padding:10px; background-color:#369; color:#fff; border-bottom:1px solid #fff; cursor:pointer;" onclick="addr('<?= $f->id ?>')"><?= ucwords($f->name.' - '.$f->description) ?></div>

          <?php
        }
      }
      }

      public function actionAddr()
      {
        $id=Yii::$app->request->post('item');
        $model=Inventory::findOne($id);

        ob_start();
        
        // access the cart from "cart" subcomponent
       $cart = new  \yz\shoppingcart\ShoppingCart();

       if($model->quantity>0){
        $cart->put($model, 1);
      }else{
        ?>
<script type="text/javascript">
alert('Out of stock');
</script>

        <?php
      }

        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        
        //LedgerController::Allcart();
        Yii::$app->bar->bar();


      
       
  }

  // addr2

      public function actionAddr2()
      {
        $id=Yii::$app->request->post('item');
        $model=Inventory::findOne($id);

        ob_start();
        
        // access the cart from "cart" subcomponent
       $cart = new  \yz\shoppingcart\ShoppingCart();

       if($model->quantity>0){
        $cart->put($model, 1);
      }else{
        ?>
<script type="text/javascript">
alert('Out of stock');
</script>

        <?php
      }

        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        
        //LedgerController::Allcart();
        Yii::$app->wash->laundry();


      
       
  }
      
      
      public function actionBringr()
      {
        $id=Yii::$app->request->post('item');
        $model=Inventory::find()->where(['barcode'=>$id])->one();

        ob_start();
        
        // access the cart from "cart" subcomponent
       $cart = new  \yz\shoppingcart\ShoppingCart();

       
        $cart->put($model, 1);

        $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        //LedgerController::Allcart();
        Yii::$app->mike->hello();

        
      }

       public function actionAdjust()
      {
        if(Yii::$app->request->post())
        {
          $amount=Yii::$app->request->post('amount');
          $bank=Yii::$app->request->post('bank');
          $direction=Yii::$app->request->post('direction');

          if(empty($amount))
          {
            die('please enter amount paid');
          }


           $ledger= new Ledger();

              if($direction==1){
                $ledger->debit=0;
              }

              if($direction==2){
                $ledger->debit=$amount;
              }

              if($direction==1){
                $ledger->credit=$amount;
              }

               if($direction==2){
                $ledger->credit=0;
              }


                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date('Y-m-d');
                $ledger->transaction_id='0'; 
                $ledger->vendor='0';   
                $ledger->amount_paid=$amount;  
                $ledger->description="Balance adjustment for ".Banks::findOne($bank)->bank;

                if($direction==1){
                $ledger->ptype=1;
                }

                if($direction==2){
                $ledger->ptype=2;
                }

                $ledger->open=8;
                $ledger->vendor="Adjustment for ".Banks::findOne($bank)->bank;
                $ledger->bank=$bank;
                $ledger->staff=Yii::$app->user->identity->id;
                if(!$ledger->save())
                {
                    
                    throw new \Exception( 'could not save to ledger' );  
                   // var_dump($ledger->getErrors()); die;
                    // 15508444924
                    // 15508412687
                }
               return $this->redirect(['made']);


        }
        return $this->render('adjust');
      }

      public function actionMade()
      {
        return $this->render('made');
      }


    public function actionClearcart()
    {
        
        //$cart = \Yii::$app->cart->getPositions();
         $cart = new  \yz\shoppingcart\ShoppingCart();
         //\Yii::$app->cart->removeAll();
         $type=Shops::findOne(Yii::$app->user->identity->shop_id)->shop_type;
         $cart->removeAll();
         return $this->redirect(['/ledger/retail','stype'=>$type]);

    }



    public function actionClosesale()
    {
        
       

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $positions = $cart->getPositions(); 
        $total = $cart->getCost();   


        $config=Config::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

        $bank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

        $inbank=Banks::findOne($config->bank);
        
        $shopy=Shops::findOne(Yii::$app->user->identity->shop_id); 


        if(empty($bank))
        {
          die('You have not yet set a bank account to receive payments');
        }

        // $ctype=Clients::findOne(Yii::$app->user->identity->cid)->industry;
        // if($ctype==2){
        if(empty($config->bank))
        {
          die('No bank account specified in config');
        }  
        // }      

        $transaction_id=time().rand(1,9);

         $details=array();

          foreach($positions as $position)
          {
            // $details['item_id'][]=$position->item_id;
            // $details['item_name'][]=$position->name;
            // $details['id'][]=$position->id;
            // $details['quantity'][]=$position->getQuantity();

            $details[]=['item_id'=>$position->item_id,'item_name'=>$position->name,'price'=>$position->getPrice(),'quantity'=>$position->getQuantity(),'id'=>$position->id];
          }
          // $item[]=array('total'=>$total,'amount'=>$amount,'details'=>$description,'quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$position->item_id,'id'=>$id,'amount_paid'=>$amount_paid,'narration'=>$narration,'shop_id'=>Yii::$app->user->identity->shop_id,'countable'=>$position->countable);

                $transaction = Yii::$app->db->beginTransaction();
                try {

                   if(!empty(Yii::$app->user->identity->shop_id) && Yii::$app->user->identity->department==1)
        {
           
    
       
                $ledger= new Ledger();
                $ledger->debit=0;
                $ledger->credit=$total;
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date("Y-m-d H:i:s");
                $ledger->transaction_id=time().rand(1,9); 
                $ledger->vendor='0';   
                $ledger->amount_paid=$total;   
                $ledger->description="Income";
                $ledger->shop_id=Yii::$app->user->identity->shop_id;
                $ledger->details=json_encode($details);
                $ledger->ptype=1;
                $ledger->bank=$config->bank;
                $ledger->transaction_id=$transaction_id;
                $ledger->staff=Yii::$app->user->identity->id;
                if(!$ledger->save())
                {
                    
                   throw new \Exception( 'could not save to ledger' );  
                   // var_dump($ledger->getErrors()); die;
                }
               
                
                   


                    // $row11 = explode(',', $workflow->status_id);
                    // $row22 = explode(',', $workflow->int_workflow);
                    // $reid = array_search(5, $row11);
                    // $rere = $row22[$reid];

                    foreach($positions as $position)
                    {

                    $uti = Inventory::findOne($position->id);
                    if ($uti->countable == 1) { //die();
                        $uti->quantity -= $position->getQuantity();
                    }


                    if (!$uti->save()) {
                        throw new \Exception('could not save inventory');
                        
                    }
                    // }

                if ($uti->countable == 1) {
                    $shoph = new ShopHistory();
                    $shoph->cid = Yii::$app->user->identity->cid;
                    $shoph->name = $position->name;
                    $shoph->quantity = $position->getQuantity();

                    $shoph->price = $position->getPrice();
                    $shoph->staff = Yii::$app->user->identity->id;
                    // $storeh->received_date=date('Y-m-d');
                    $shoph->created_at = date('Y-m-d');
                    $shoph->item_id = $position->id;
                    $shoph->issued_by = Yii::$app->user->identity->id;
                    $shoph->received_by = 0;
                    $shoph->type = Yii::$app->user->identity->id;
                    $shoph->transaction_id = 0;
                    $shoph->countable = $position->countable;


                    if (!$shoph->save()) {
                        
                        throw new \Exception('could not save to shop history');
                      // var_dump($shoph->getErrors()); die;
                        
                    }
                }
              }  

              $inbank->balance+=$total;

              // if($ctype==2){
              if(!$inbank->save())
              {
                  throw new \Exception('could not save to bank');
              }
            // }

// start print

// $connector = new WindowsPrintConnector("mark4");
// $printer = new Printer($connector);

// /* Information for the receipt */
// // $items = array(
// //     new item("Example item #1", "4.00"),
// //     new item("Another thing", "3.50"),
// //     new item("Something else", "1.00"),
// //     new item("A final item", "4.45"),
// // );

// foreach($positions as $pos)
// {
//   $items[] = new item($pos->name, $pos->getQuantity()." @ ".$pos->price." - ", number_format($pos->price*$pos->getQuantity(),2));
// }
// $subtotal = new item('Subtotal', '', number_format($total,2));
// // $tax = new item('Vat', '', number_format($total*.10,2));
// $vat=$total*.0;
// $tax = new item('Vat', '', number_format($vat,2));
// $total = new item('Total', '',  number_format($total+=($vat),2), true);
// /* Date is kept the same for testing */
// $date = date('l jS \of F Y h:i:s A');
// // $date = "Monday 6th of April 2015 02:56:25 PM";

// /* Start the printer */
// // $logo = EscposImage::load("resources/escpos-php.png", false);
// $printer = new Printer($connector);

// /* Print top logo */
// $printer -> setJustification(Printer::JUSTIFY_CENTER);
// // $printer -> graphics($logo);

// /* Name of shop */
// $printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
// $printer -> text($shopy->name."\n");
// $printer -> selectPrintMode();
// $printer -> text($shopy->address."\n");
// $printer -> feed();

// /* Title of receipt */
// $printer -> setEmphasis(true);
// $printer -> text("SALES INVOICE\n");
// $printer -> setEmphasis(false);
// $printer -> feed();

// /* Items */
// $printer -> setJustification(Printer::JUSTIFY_LEFT);
// $printer -> setEmphasis(true);
// // $printer -> text(new item('', '', '$'));
// $printer -> setEmphasis(false);
// foreach ($items as $item) {
//     $printer -> text($item);
// }

// $printer -> feed();

// $printer -> setEmphasis(true);
// $printer -> text($subtotal);
// $printer -> setEmphasis(false);
// $printer -> feed();

// /* Tax and total */
// $printer -> text($tax);
// $printer -> selectPrintMode(Printer::MODE_DOUBLE_HEIGHT);
// $printer -> text($total);
// $printer -> selectPrintMode();

// /* Footer */
// $printer -> feed(2);
// $printer -> setJustification(Printer::JUSTIFY_CENTER);
// $printer -> text("Thank you for shopping at ".$shopy->name."\n");
// $printer -> text("No refund of goods after sale\n");
// $printer -> feed(2);
// $printer -> text($date . "\n");

// /* Cut the receipt and open the cash drawer */
// $printer -> cut();
// $printer -> pulse();

// $printer -> close();


              // end print
                  

                     $transaction->commit();
                   }

                    } catch (\Exception $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    } catch (\Throwable $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    }
             
         
           $type=Shops::findOne(Yii::$app->user->identity->shop_id)->shop_type;


           // start print




           // end print

         $cart->removeAll();

         return $this->redirect(['/ledger/retail','stype'=>$type]);
       

        

   }


   // closesale 2

    public function actionClosesale22()
    {
        
       

        ob_start();

        $vendor;


        $payment=Yii::$app->request->post('payment');
        $amount_paid=Yii::$app->request->post('amount_paid');

        $customer=Yii::$app->request->post('customer');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $positions = $cart->getPositions(); 
        $total = $cart->getCost();   

        if($customer!= null || !empty($customer)){ $cus=Customers::findOne($customer)->name; $vendor=$cus; }
echo "<span style='font-weight:bold; font-size:18px;'>Receipt for: ".ucwords($cus)."</span>";

        $config=Config::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

        $bank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

        $inbank=Banks::findOne($config->bank);
        
        $shopy=Shops::findOne(Yii::$app->user->identity->shop_id); 


        if(empty($bank))
        {
          die('You have not yet set a bank account to receive payments');
        }

        // $ctype=Clients::findOne(Yii::$app->user->identity->cid)->industry;
        // if($ctype==2){
        if(empty($config->bank))
        {
          die('No bank account specified in config');
        }  
        // }      

        $transaction_id=time().rand(1,9);

         $details=array();

          foreach($positions as $position)
          {
            // $details['item_id'][]=$position->item_id;
            // $details['item_name'][]=$position->name;
            // $details['id'][]=$position->id;
            // $details['quantity'][]=$position->getQuantity();

            $details[]=['item_id'=>$position->item_id,'item_name'=>$position->name,'price'=>$position->getPrice(),'quantity'=>$position->getQuantity(),'id'=>$position->id];
          }
          // $item[]=array('total'=>$total,'amount'=>$amount,'details'=>$description,'quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$position->item_id,'id'=>$id,'amount_paid'=>$amount_paid,'narration'=>$narration,'shop_id'=>Yii::$app->user->identity->shop_id,'countable'=>$position->countable);

                $transaction = Yii::$app->db->beginTransaction();
                try {

                   if(!empty(Yii::$app->user->identity->shop_id) && Yii::$app->user->identity->department==1)
        {
           
    
       
                $ledger= new Ledger();
                $ledger->debit=0;
                $ledger->credit=$total;
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date("Y-m-d H:i:s");
                $ledger->transaction_id=time().rand(1,9); 
                $ledger->vendor=$customer;   
                $ledger->amount_paid=$amount_paid;   
                $ledger->description="Income";
                $ledger->shop_id=Yii::$app->user->identity->shop_id;
                $ledger->details=json_encode($details);
                $ledger->ptype=1;
                $ledger->bank=$config->bank;
                $ledger->transaction_id=$transaction_id;
                $ledger->staff=Yii::$app->user->identity->id;
                $ledger->payment_method=$payment;
                if(!$ledger->save())
                {
                    
                   // throw new \Exception( 'could not save to ledger' );  
                   var_dump($ledger->getErrors()); //die;
                }



                if($payment==6000000){
  $check=Tabs::find()->where(['customer'=>$customer])->one();
  if($check==null){
              $tab =  new Tabs;
              $tab->customer=$customer;
              $tab->bill_ids.=$ledger->id;
              $tab->cid=Yii::$app->user->identity->cid;
              $tab->status=0;
              $tab->shop_type=$shopy->shop_type;
              if(!$tab->save())
              {
                throw new \Exception('could not save to tab');
              }
                 }else{
                  $check->bill_ids.=",".$ledger->id;
                  if(!$check->save())
                  {
                    throw new \Exception("Could not update tab");
                    
                  }
                 }

            }
               
                
                   


                    // $row11 = explode(',', $workflow->status_id);
                    // $row22 = explode(',', $workflow->int_workflow);
                    // $reid = array_search(5, $row11);
                    // $rere = $row22[$reid];

                    foreach($positions as $position)
                    {

                    $uti = Inventory::findOne($position->id);
                    if ($uti->countable == 1) { //die();
                        $uti->quantity -= $position->getQuantity();
                    }


                    if (!$uti->save()) {
                        throw new \Exception('could not save inventory');
                        
                    }
                    // }

                if ($uti->countable == 1) {
                    $shoph = new ShopHistory();
                    $shoph->cid = Yii::$app->user->identity->cid;
                    $shoph->name = $position->name;
                    $shoph->quantity = $position->getQuantity();

                    $shoph->price = $position->getPrice();
                    $shoph->staff = Yii::$app->user->identity->id;
                    // $storeh->received_date=date('Y-m-d');
                    $shoph->created_at = date('Y-m-d');
                    $shoph->item_id = $position->id;
                    $shoph->issued_by = Yii::$app->user->identity->id;
                    $shoph->received_by = 0;
                    $shoph->type = Yii::$app->user->identity->id;
                    $shoph->transaction_id = 0;
                    $shoph->countable = $position->countable;


                    if (!$shoph->save()) {
                        
                        throw new \Exception('could not save to shop history');
                      // var_dump($shoph->getErrors()); die;
                        
                    }
                }
              }  

              $inbank->balance+=$amount_paid;

              // if($ctype==2){
              if(!$inbank->save())
              {
                  throw new \Exception('could not save to bank');
              }


            // }

// start print

// $connector = new WindowsPrintConnector("mark4");
// $printer = new Printer($connector);

// /* Information for the receipt */
// // $items = array(
// //     new item("Example item #1", "4.00"),
// //     new item("Another thing", "3.50"),
// //     new item("Something else", "1.00"),
// //     new item("A final item", "4.45"),
// // );

// foreach($positions as $pos)
// {
//   $items[] = new item($pos->name, $pos->getQuantity()." @ ".$pos->price." - ", number_format($pos->price*$pos->getQuantity(),2));
// }
// $subtotal = new item('Subtotal', '', number_format($total,2));
// // $tax = new item('Vat', '', number_format($total*.10,2));
// $vat=$total*.0;
// $tax = new item('Vat', '', number_format($vat,2));
// $total = new item('Total', '',  number_format($total+=($vat),2), true);
// /* Date is kept the same for testing */
// $date = date('l jS \of F Y h:i:s A');
// // $date = "Monday 6th of April 2015 02:56:25 PM";

// /* Start the printer */
// // $logo = EscposImage::load("resources/escpos-php.png", false);
// $printer = new Printer($connector);

// /* Print top logo */
// $printer -> setJustification(Printer::JUSTIFY_CENTER);
// // $printer -> graphics($logo);

// /* Name of shop */
// $printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
// $printer -> text($shopy->name."\n");
// $printer -> selectPrintMode();
// $printer -> text($shopy->address."\n");
// $printer -> feed();

// /* Title of receipt */
// $printer -> setEmphasis(true);
// $printer -> text("SALES INVOICE\n");
// $printer -> setEmphasis(false);
// $printer -> feed();

// /* Items */
// $printer -> setJustification(Printer::JUSTIFY_LEFT);
// $printer -> setEmphasis(true);
// // $printer -> text(new item('', '', '$'));
// $printer -> setEmphasis(false);
// foreach ($items as $item) {
//     $printer -> text($item);
// }

// $printer -> feed();

// $printer -> setEmphasis(true);
// $printer -> text($subtotal);
// $printer -> setEmphasis(false);
// $printer -> feed();

// /* Tax and total */
// $printer -> text($tax);
// $printer -> selectPrintMode(Printer::MODE_DOUBLE_HEIGHT);
// $printer -> text($total);
// $printer -> selectPrintMode();

// /* Footer */
// $printer -> feed(2);
// $printer -> setJustification(Printer::JUSTIFY_CENTER);
// $printer -> text("Thank you for shopping at ".$shopy->name."\n");
// $printer -> text("No refund of goods after sale\n");
// $printer -> feed(2);
// $printer -> text($date . "\n");

// /* Cut the receipt and open the cash drawer */
// $printer -> cut();
// $printer -> pulse();

// $printer -> close();


              // end print
                  

                     $transaction->commit();
                   }

                    } catch (\Exception $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    } catch (\Throwable $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    }
             
         
           $shop=Shops::findOne(Yii::$app->user->identity->shop_id);
?>
<table class="table table-bordered table-striped" style="font-size:20px; width:100%;" >

  <tr>
<td colspan="4" style="text-align:center; font-weight:bold;"><?= $shop->name ?></td>
  </tr>
    <tr>
<td colspan="4" style="text-align:center; font-weight:bold;"><?= $shop->address ?></td>
  </tr>
    <tr>
<td colspan="4" style="text-align:center; font-weight:bold;"><?= $shop->phone ?></td>
  </tr>

  <tr  style="font-weight:bold">
<td>Item</td>
<td>Price</td>
<td>Quantity</td>
<td>Sub</td>
  </tr>
<?php $gain=0;
           foreach($positions as $position)
           {
              ?>
  <tr>
<td><?= $position->name ?></td>
<td><?= $position->getPrice() ?></td>
<td><?= $position->getQuantity() ?></td>
<td><?= $gain+=$position->getQuantity()*$position->getPrice() ?></td>
  </tr>


              <?php
           }

           ?>

           <tr  style="font-weight:bold">
<td></td>
<td></td>
<td>Total</td>
<td><?= number_format($gain) ?></td>
           </tr>
           <tr>
<td>PAID</td><TD><?= number_format($amount_paid,2) ?></TD>
<td>BALANCE</td><td><?= number_format(($total-$amount_paid),2) ?></td>
           </tr>


         </table>
         <?php

           

         $cart->removeAll();

         // return $this->redirect(['/ledger/retail','stype'=>$type]);

       

        

   }



   public function actionClosesale23()
    {
        
       

        ob_start();

        $vendor;


        $payment=Yii::$app->request->post('payment');
        $amount_paid=Yii::$app->request->post('amount_paid');

        $customer=Yii::$app->request->post('customer');
        $table_no=Yii::$app->request->post('table_no');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $positions = $cart->getPositions(); 
        $total = $cart->getCost();   

        if($customer!= null || !empty($customer)){ $cus=Customers::findOne($customer)->name; $vendor=$cus; }
echo "<span style='font-weight:bold; font-size:18px;'>Receipt for: ".ucwords($cus)."</span>";

        $config=Config::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

        $bank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

        $inbank=Banks::findOne($config->bank);
        
        $shopy=Shops::findOne(Yii::$app->user->identity->shop_id); 


        if(empty($bank))
        {
          die('You have not yet set a bank account to receive payments');
        }

        // $ctype=Clients::findOne(Yii::$app->user->identity->cid)->industry;
        // if($ctype==2){
        if(empty($config->bank))
        {
          die('No bank account specified in config');
        }  
        // }      

        $transaction_id=time().rand(1,9);

        $session=Yii::$app->session;
        if($session->has('dtid'))
        {
          $transaction_id=$session['dtid'];
          $oled=Ledger2::find()->where(['transaction_id'=>$transaction_id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();;

          $table_no=$oled->table_no;
          $customer=$oled->vendor;
          $payment_method=$oled->payment_method;
        }

         $details=array();

          foreach($positions as $position)
          {
            // $details['item_id'][]=$position->item_id;
            // $details['item_name'][]=$position->name;
            // $details['id'][]=$position->id;
            // $details['quantity'][]=$position->getQuantity();

            $details[]=['item_id'=>$position->item_id,'item_name'=>$position->name,'price'=>$position->getPrice(),'quantity'=>$position->getQuantity(),'id'=>$position->id];
          }
          // $item[]=array('total'=>$total,'amount'=>$amount,'details'=>$description,'quantity'=>$quantity,'item_name'=>$item_name,'item_id'=>$position->item_id,'id'=>$id,'amount_paid'=>$amount_paid,'narration'=>$narration,'shop_id'=>Yii::$app->user->identity->shop_id,'countable'=>$position->countable);

                $transaction = Yii::$app->db->beginTransaction();
                try {

                   if(!empty(Yii::$app->user->identity->shop_id) && Yii::$app->user->identity->department==1)
        {
           
    
       
                $ledger= new Ledger2();
                $ledger->debit=0;
                $ledger->credit=$total;
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date("Y-m-d H:i:s");
                $ledger->transaction_id=time().rand(1,9); 
                $ledger->vendor=$customer;   
                $ledger->amount_paid=$amount_paid;   
                $ledger->description="Income";
                // $ledger->shop_id=Yii::$app->user->identity->shop_id;
                $ledger->shop_id=$position->shop;
                $ledger->details=json_encode($details);
                $ledger->ptype=1;
                $ledger->bank=$config->bank;
                $ledger->transaction_id=$transaction_id;
                $ledger->staff=Yii::$app->user->identity->id;
                $ledger->payment_method=$payment;
                $ledger->table_no=$table_no;
                if(!$ledger->save())
                {
                    
                   // throw new \Exception( 'could not save to ledger' );  
                   var_dump($ledger->getErrors()); //die;
                }



              $inbank->balance+=$amount_paid;

              // if($ctype==2){
              if(!$inbank->save())
              {
                  throw new \Exception('could not save to bank');
              }

              // end print
                  

                     $transaction->commit();
                   }

                    } catch (\Exception $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    } catch (\Throwable $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    }
             
         unset($session['dtid']);
           $shop=Shops::findOne(Yii::$app->user->identity->shop_id);
?>
<table class="table table-bordered table-striped" style="font-size:20px; width:100%;" >

  <tr>
<td colspan="4" style="text-align:center; font-weight:bold;"><?= $shop->name ?></td>
  </tr>
    <tr>
<td colspan="4" style="text-align:center; font-weight:bold;"><?= $shop->address ?></td>
  </tr>
    <tr>
<td colspan="4" style="text-align:center; font-weight:bold;"><?= $shop->phone ?></td>
  </tr>

  <tr  style="font-weight:bold">
<td>Item</td>
<td>Price</td>
<td>Quantity</td>
<td>Sub</td>
  </tr>
<?php $gain=0;
           foreach($positions as $position)
           {
              ?>
  <tr>
<td><?= $position->name ?></td>
<td><?= $position->getPrice() ?></td>
<td><?= $position->getQuantity() ?></td>
<td><?= $gain+=$position->getQuantity()*$position->getPrice() ?></td>
  </tr>


              <?php
           }

           ?>

           <tr  style="font-weight:bold">
<td></td>
<td></td>
<td>Total</td>
<td><?= number_format($gain) ?></td>
           </tr>
           <tr>
<td>PAID</td><TD><?= number_format($amount_paid,2) ?></TD>
<td>BALANCE</td><td><?= number_format(($total-$amount_paid),2) ?></td>
           </tr>


         </table>
         <?php

           

         $cart->removeAll();

         // return $this->redirect(['/ledger/retail','stype'=>$type]);

       

        

   }


   // closesale24 to close 

   public function actionClosesale24()
    {      

        ob_start();

        $vendor;


        $payment=Yii::$app->request->post('payment');
        $amount_paid=Yii::$app->request->post('amount_paid');

        $customer=Yii::$app->request->post('customer');

        $transaction_id=Yii::$app->request->post('tid');

        $record=Yii::$app->request->post('record');

        $new_transaction_id=time().rand(1,12);

        if($customer!= null || !empty($customer)){ $cus=Customers::findOne($customer)->name; $vendor=$cus; }
        echo "<span style='font-weight:bold; font-size:18px;'>Receipt for: ".ucwords($cus)."</span>";

        $config=Config::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

        $bank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

        $inbank=Banks::findOne($config->bank);
        
        $shopy=Shops::findOne(Yii::$app->user->identity->shop_id); 


        if(empty($bank))
        {
          die('You have not yet set a bank account to receive payments');
        }

        // $ctype=Clients::findOne(Yii::$app->user->identity->cid)->industry;
        // if($ctype==2){
        if(empty($config->bank))
        {
          die('No bank account specified in config');
        }  
        // }      

      //  $transaction_id=time().rand(1,9);

         $details=array();

         $positions=Ledger2::find()->where(['cid'=>Yii::$app->user->identity->cid,'transaction_id'=>$transaction_id])->all();

        $rad=Ledger2::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['transaction_id'=>$transaction_id])->one();

        if($rad->status==1){
          ?>
<script type="text/javascript">
alert('This sale has already been closed');
</script>

          <?php
          
        }
         
//var_dump($position);
//echo "amount paid ".$amount_paid; echo "payment thing ".$payment;
          // foreach($positions as $position)
          // {
          //   // $details['item_id'][]=$position->item_id;
          //   // $details['item_name'][]=$position->name;
          //   // $details['id'][]=$position->id;
          //   // $details['quantity'][]=$position->getQuantity();

          //   $details[]=['item_id'=>$position->item_id,'item_name'=>$position->name,'price'=>$position->getPrice(),'quantity'=>$position->getQuantity(),'id'=>$position->id];
          // }
         

                $transaction = Yii::$app->db->beginTransaction();
                try {

                   if(!empty(Yii::$app->user->identity->shop_id) && Yii::$app->user->identity->department==1 && $rad->status==0)
        {
           
            
              $otot=0;
              foreach($positions as $position){
                $sam=json_decode($position->details,true); //var_dump($sam);
                foreach($sam as $sa){
       $otot+=$sa['quantity']*$sa['price']; 
     }
     }

         $copy=$rad->attributes;
      $ledger = new Ledger;
      $ledger->setAttributes($copy);
      $ledger->credit=$amount_paid;
      $ledger->debit=0;
      $ledger->department = Yii::$app->user->identity->department;
      $ledger->cid = Yii::$app->user->identity->cid;
      $ledger->staff=Yii::$app->user->identity->id;
      $ledger->description = "Income";
      $ledger->vendor = $customer;
      $ledger->payment_method=$payment;
      $ledger->leg2_link=$transaction_id;
      $ledger->amount_paid=$amount_paid;
      $ledger->transaction_id=$new_transaction_id;
      $ledger->details='';
      $ledger->ptype=1;



                if(!$ledger->save())
                {
                    
                  throw new \Exception( 'could not save to ledger' );  
                   // var_dump($ledger->getErrors()); die;
                }



                if($payment==600000000){
  $check=Tabs::find()->where(['customer'=>$customer])->one();
  if($check==null){
              $tab =  new Tabs;
              $tab->customer=$customer;
              $tab->bill_ids.=$ledger->id;
              $tab->cid=Yii::$app->user->identity->cid;
              $tab->status=0;
              $tab->shop_type=$shopy->shop_type;
              if(!$tab->save())
              {
                throw new \Exception('could not save to tab');
              }
                 }else{
                  $check->bill_ids.=",".$ledger->id;
                  if(!$check->save())
                  {
                    throw new \Exception("Could not update tab");
                    
                  }
                 }

            }
               
                
                   


                    // $row11 = explode(',', $workflow->status_id);
                    // $row22 = explode(',', $workflow->int_workflow);
                    // $reid = array_search(5, $row11);
                    // $rere = $row22[$reid];

                    foreach($positions as $position)
                    {
$lap=json_decode($position->details,true); //var_dump($lap);

foreach($lap as $la){
                    $uti = Inventory::findOne($la['id']); 
                    if ($uti->countable == 1) { //die();
                        $uti->quantity -= $la['quantity'];
                    }


                   
                    // }

                if ($uti->countable == 1) {
                    $shoph = new ShopHistory();
                    $shoph->cid = Yii::$app->user->identity->cid;
                    $shoph->name = $la['item_name'];
                    $shoph->quantity = $la['quantity'];

                    $shoph->price = $la['price'];
                    $shoph->staff = Yii::$app->user->identity->id;
                    // $storeh->received_date=date('Y-m-d');
                    $shoph->created_at = date('Y-m-d');
                    $shoph->item_id = $la['id'];
                    $shoph->issued_by = Yii::$app->user->identity->id;
                    $shoph->received_by = 0;
                    $shoph->type = Yii::$app->user->identity->id;
                    $shoph->transaction_id = time().rand(1,9)."r";
                    $shoph->countable = $uti->countable;
                    $shoph->standing_quantity = $uti->quantity;
                    $shoph->qout=$la['quantity'];


                    if (!$shoph->save()) {
                        
                        throw new \Exception('could not save to shop history');
                      // var_dump($shoph->getErrors()); die;
                        
                    }


                     if (!$uti->save()) {
                        throw new \Exception('could not save inventory');
                        
                    }
                }



                  }
              }  

              $inbank->balance+=$amount_paid;

              // if($ctype==2){
              if(!$inbank->save())
              {
                  throw new \Exception('could not save to bank');
              }


              foreach($positions as $position)
              {
                $position->status=1;
                if(!$position->save())
                {
                  throw new \Exception('could not update leger2 status');
                }
              }

            
            // }

// start print




              // end print
                  

                     $transaction->commit();
                   }

                    } catch (\Exception $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    } catch (\Throwable $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    }
             
         
           $shop=Shops::findOne(Yii::$app->user->identity->shop_id);
?>

<table class="table table-bordered table-striped" style="font-size:20px; width:100%;" >

  <tr>
<td colspan="4" style="text-align:center; font-weight:bold;"><?= $shop->name ?></td>
  </tr>
    <tr>
<td colspan="4" style="text-align:center; font-weight:bold;"><?= $shop->address ?></td>
  </tr>
    <tr>
<td colspan="4" style="text-align:center; font-weight:bold;"><?= $shop->phone ?></td>
  </tr>

  <tr  style="font-weight:bold">
<td>Item</td>
<td>Price</td>
<td>Quantity</td>
<td>Sub</td>
  </tr>
<?php $gain=0;
$pay=0;
foreach($positions as $position){
  $pay+=$position['amount_paid'];
  $sap=json_decode($position->details,true); //var_dump($lap);
           foreach($sap as $sa)
           {
              ?>
  <tr>
<td><?= $sa['item_name'] ?></td>
<td><?= $sa['price'] ?></td>
<td><?= $sa['quantity'] ?></td>
<td><?= $sa['quantity']*$sa['price'] ?></td>
  </tr>


              <?php
              
              $gain+=$sa['quantity']*$sa['price'];
           }
         }
           ?>

           <tr  style="font-weight:bold">
<td></td>
<td></td>
<td>Total</td>
<td><?= number_format($gain) ?></td>
           </tr>
           <tr>
<td>PAID</td><TD><?= number_format($amount_paid,2) ?></TD>
<td>BALANCE</td><td><?= number_format(($gain-$amount_paid),2) ?></td>
           </tr>


         </table>

         <?php

           

     

         // return $this->redirect(['/ledger/retail','stype'=>$type]);

       

        

   }


   public function actionUpdate_quantity()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $pot=$cart->getPositionById($id);
        $cart->update($pot,$quantity);
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();

        //LedgerController::Allcart();
        Yii::$app->mike->hello();
    
    
  }


     public function actionUpdate_quantityr1()
    {
        $id=Yii::$app->request->post('id');
        $quantity=Yii::$app->request->post('quantity');

        $cart = new  \yz\shoppingcart\ShoppingCart();
        $pot=$cart->getPositionById($id);
        $cart->update($pot,$quantity);
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();

        //LedgerController::Allcart();
        Yii::$app->bar->bar();
    
    
  }


  public function actionDo_add($id,$tid)
  {
    $session=Yii::$app->session;
    $session->open();
    $session['dtid']=$tid; 
   // return $this->render('do_add');
    return $this->redirect(['retail','stype'=>$id]);
  }


  public function actionDo_close($id,$tid)
  {
    $sale=Ledger2::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->all();
   
    return $this->render('do_close',['sale'=>$sale,'rec_id'=>$id,'transaction_id'=>$tid]);
  }


   public function actionEditl()
    {

        if (Yii::$app->request->post()) {
            $posts = Yii::$app->request->post();
            $gross=0;
// var_dump($posts); die;
            for ($x = 0; $x < count($posts['item_id']); $x++) {
                $total = 0;
               echo  $total += ($posts['quantity'][$x] * $posts['price'][$x]); echo "<br>";
                if (empty($posts['customer'])) {
                    $item[] = array('total' => $total, 'price' => $posts['price'][$x], 'quantity' => $posts['quantity'][$x], 'item_name' => $posts['item_name'][$x], 'item_id' => $posts['item_id'][$x], 'id' => $posts['id'][$x]);
                } else {
                    $item[] = array('total' => $total, 'price' => $posts['price'][$x], 'quantity' => $posts['quantity'][$x], 'item_name' => $posts['item_name'], 'item_id' => $posts['item_id'][$x], 'customer_name' => $posts['customer'], 'id' => $posts['id'][$x]);
                }
                $gross+=$total;
            }
//die;
            $point = Ledger2::findOne($posts['rec_id']);
            $point->details = json_encode($item);
            $point->credit=$gross;
            if (!$point->save()) {
                var_dump($point->getErrors());
                die;
            } else {
                echo "its done " . $posts['rec_id'];
                return $this->redirect(['sale_edit', 'id' => $posts['rec_id'], 'tid' => $posts['transaction_id']]);
            }

        }

        //  var_dump($posts);

        //return $this->render('editr');
    }


    // holder keep

     public function actionEditlk()
    {

        if (Yii::$app->request->post()) {
            $posts = Yii::$app->request->post();
// var_dump($posts); die;
            for ($x = 0; $x < count($posts['item_id']); $x++) {
                $total = 0;
               echo  $total += ($posts['quantity'][$x] * $posts['price'][$x]); echo "<br>";
                if (empty($posts['customer'])) {
                    $item[] = array('total' => $total, 'price' => $posts['price'][$x], 'quantity' => $posts['quantity'][$x], 'item_name' => $posts['item_name'][$x], 'item_id' => $posts['item_id'][$x], 'id' => $posts['id'][$x]);
                } else {
                    $item[] = array('total' => $total, 'price' => $posts['price'][$x], 'quantity' => $posts['quantity'][$x], 'item_name' => $posts['item_name'], 'item_id' => $posts['item_id'][$x], 'customer_name' => $posts['customer'], 'id' => $posts['id'][$x]);
                }
            }
//die;
            $point = Ledger2::findOne($posts['rec_id']);
            $point->details = json_encode($item);
            $point->credit=$total;
            if (!$point->save()) {
                var_dump($point->getErrors());
                die;
            } else {
                echo "its done " . $posts['rec_id'];
                return $this->redirect(['do_close', 'id' => $posts['rec_id'], 'tid' => $posts['transaction_id']]);
            }

        }

        //  var_dump($posts);

        //return $this->render('editr');
    }


  public function actionRemove_byid()
    {
        $id=Yii::$app->request->post('id');        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        // $pot=$cart->getPositionById($id);
        $cart->removeById($id);
      
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
        //LedgerController::Allcart();
        Yii::$app->mike->hello();
        
   
  }


    public function actionRemove_byidr1()
    {
        $id=Yii::$app->request->post('id');        

        $cart = new  \yz\shoppingcart\ShoppingCart();
        // $pot=$cart->getPositionById($id);
        $cart->removeById($id);
      
        // $cart->put($pot,3);

         $all_items = $cart->getPositions();
       // var_dump($all_items);

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ob_start();
        //LedgerController::Allcart();
        Yii::$app->bar->bar();
        
   
  }



  public function actionTabs()
  {
    $tabs=Ledger2::find()->where(['cid'=>Yii::$app->user->identity->cid,'payment_method'=>600000000,'status'=>0])->groupBy(['vendor'])->all();
    return $this->render('tabs',['tabs'=>$tabs]);
  }

  public function actionTab_list($vendor)
  {
    $records=Ledger2::find()->where(['vendor'=>$vendor,'cid'=>Yii::$app->user->identity->cid,'status'=>0])->all();
    $shopt=Shops::find()->where(['id'=>Yii::$app->user->identity->shop_id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
    return $this->render('tab_list',['records'=>$records,'vendor'=>$vendor,'st'=>$shopt->shop_type]);
  }


  public static function Allcart()
  {
       ob_start();
        
        // access the cart from "cart" subcomponent
       $cart = new  \yz\shoppingcart\ShoppingCart();       
       

        $all_items = $cart->getPositions();
      

        $client=Clients::findOne(Yii::$app->user->identity->cid);
        ?>
        <table class="table table-bordered table-striped">
            <tr>
<th>ITEM NAME</th>
<TH>QUANTITY</TH>
<TH>PRICE</TH>
<TH>SUB</TH>

</tr>

<?php
        foreach($all_items as $all)
        {
          ?>
          

<tr>
<td class="col-md-3" ><?= ucwords($all->name) ?></td>
<td class="col-md-3" ><?= Html::textInput('quantity',$all->getQuantity(),['class'=>'form-control','id'=>$all->getid().'quantity','style'=>'width:100px;','onkeyup'=>'update_quantityr('.$all->getid().')','autocomplete'=>'off']) ?></td>
<td class="col-md-3" ><?= number_format($all->getPrice(),2) ?></td>
<td class="col-md-3" ><?= number_format($all->getQuantity()*$all->getPrice(),2) ?></td>
<td><span onclick="remove_by_idr('<?php echo $all->getid(); ?>');" style="cursor:pointer; color:blue;" title="Delete">X</span></td>
</tr>

          <?php
   }

?>
<tr>
<td colspan="2"></td>
<th>Total: </th>
<th><?= number_format($cart->getCost(),2);  ?></th>
</tr>

<tr>
  <td>
     <div>
<?= Html::textInput('custome','',['class'=>'form-control','onkeyup'=>'getItemC()','id'=>'custo','placeholder'=>'Enter Customer name','autocomplete'=>'off']) ?>
    <div id="item_listC">
    </div>
    </div>
    <div id="customer"></div>
  </td>
  <td>
  <?= Html::dropDownList('bank',null, ['6000000'=>'Add to Tab']+ArrayHelper::map(Payment::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','name'),['class'=>'form-control','prompt'=>'Payment Method','id'=>'payment']) ?>
  </td>
<td colspan="3">

</td>
</tr>
</table>
<?php
}




//       public function actionLedgergo()
//       {
//         $goo=Ledgergo::find()->all();

//                     $transaction = Yii::$app->db->beginTransaction();
//  try {

//         foreach($goo as $go)
//         {
//           $new=new Ledger();
               
//           $new->amount_paid+=$go->amount_paid;
//           $new->bank=$go->bank;
//           $new->cid=$go->cid;
//           $new->department=$go->department;
//           $new->description=$go->description;
//           $new->credit=$go->credit;
//           $new->transaction_id=$go->transaction_id;
//           $new->debit=$go->debit;
//           $new->vendor=$go->vendor;
//           $new->open=$go->open;
//           $new->ptype=$go->ptype;
//           $new->aorb=$go->aorb;
//           $new->tlink=$go->tlink;
//           $new->created_at=$go->created_at;
//           if(!$new->save())
//           {
//             throw new \Exception('could not save to ledgergo'); 
//           }

//           if($go->ptype==1)
//           {
//             if(!empty($go->bank)){
//             $vo=Banks::findOne($go->bank);
//             $vo->balance+=$go->amount_paid;
//             if(!$vo->save())
//             {
//               throw new \Exception('could increment bank balance'); 
//             }}
//           }

//           if($go->ptype==2)
//           {
//             if(!empty($go->bank)){
//               $vo=Banks::findOne($go->bank);
//             $vo->balance-=$go->amount_paid;
//             if(!$vo->save())
//             {
//               throw new \Exception('could deduct from bank balance'); 
//             }}
//           }

//         }
//          $transaction->commit();

//             } catch (\Exception $e) {
//                 $transaction->rollBack();
//                 throw $e; die('failed');
//             } catch (\Throwable $e) {
//                 $transaction->rollBack();
//                 throw $e; die('failed');
//             }
//       }

   


    // public function actionSave_payment()
    // {
    //     ob_start();
    //     $done=0;

    //     $rid=Yii::$app->request->post('rid');
    //     $amount=Yii::$app->request->post('amount');
    //     $bank=Yii::$app->request->post('bank');
    //     $record=Ledger::find()->where(['=','id',$rid])->one();
    //     $record->amount_paid+=$amount;
    //     $record->bank=$bank;
    //    // $npaid= $record->amount_paid+=$amount;
    //     if($record->save())
    //     {
    //         $done=1;
    //     }

    //     $all=json_encode(array('done'=>$done,'npaid'=>$record->amount_paid,'nout'=>$record->credit-$record->amount_paid));
    //     echo $all;
    // }

    function actionNew_reverseit()
    {
      

      $id=Yii::$app->request->get('tid'); 
      $transaction = Yii::$app->db->beginTransaction();
      try {

      // fetch initiating transaction entry from ledger
      $entry=Ledger::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['transaction_id'=>$id])->one();

      // if initiating transaction is income remove initiating entry from cashbook and add items back to shop inventory and put items in add item to item shop history, finally delete associated requisition using connecting transaction_id
      $request=Requisitions::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['transaction_id'=>$entry->transaction_id])->one();


      // $work = Requisitions::findOne($id);
      $workflow = Workflow::findOne($request->workflow_id);
      // $task = Tasks::findOne($workflow->task_id);

      // reverse associated income or expenditure items
      $items=json_decode($request->requested_item,true);

      // check for any associated entries to this initiation transaction
      $associated=Ledger::find()->where(['tlink'=>$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->all();

    
$echeck=Entry::find()->where(['transaction_id'=>$id])->count();
  if($echeck>0){
       if(!Entry::deleteAll(['transaction_id'=>$id]))
        {
          throw new \Exception('could not delete from real entries 2');
        }
      }
      if(!empty($associated))
      {
         // address bank concerns
        foreach($associated as $asso)
        {
          $bank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['bid'=>$asso->bank])->one();
          if($request->task_type==1)
          {
            $bank->balance+=$asso->amount_paid;
            if(!$bank->save())
            {
              // var_dump($bank->getErrors()); die;
              throw new \Exception('could not save to bank1');
            }

            if(!$asso->delete())
            {
              throw new \Exception('could not delete from ledger1');
            }
          }elseif ($request->task_type==2) {
            $bank->balance-=$asso->amount_paid;
            if(!$bank->save())
            {
              // var_dump($bank->getErrors()); die;
              throw new \Exception('could not save to bank2');
            }
            if(!$asso->delete())
            {
              throw new \Exception('could not delete from ledger');
            }
          }else{
            // die('Unknown entry type');
            throw new \Exception('Unknown entry type');

          }
        }
      

      // if(!$associated->deleteAll())
      //   {
      //     // var_dump($associated->getErrors()); die;
      //     throw new \Exception('could not save to ledger links');
      //   }
      }

      

      if($request->task_type==1)
      {
        foreach($items as $item)
        {
          $flush=Stores::find()->where(['id'=>$item['item_id']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
          // if returned item is countable then add back to store ledger
          if($flush->countable==1 && $request['concluded']==1)
          {
            $flush->quantity-=$item['quantity'];
            if(!$flush->save())
            {
              // var_dump($flush->getErrors()); die();
              throw new \Exception('could not save to store');
            }

                        $row11 = explode(',', $workflow->status_id);
                        $row22 = explode(',', $workflow->int_workflow);
                        $reid = array_search(5, $row11);
                        $rere = $row22[$reid];                        

                        // enter transaction details into store history
                        $storeh = new StoresHistory();
                        $storeh->name = $flush->name;
                        $storeh->cid = $flush->cid;
                        $storeh->units = $flush->units;
                        $storeh->standing_quantity = $flush->quantity;
                        $storeh->particulars = $flush->particulars;
                        $storeh->qout = $item['quantity'];

                        // $storeh->received_date=date('Y-m-d');
                        // $storeh->recieved_by=$uti->recieved_by;
                        $storeh->recieved_by = $rere;
                        $storeh->transaction_id = $request->transaction_id;
                        $storeh->balance = $flush->balance;
                        $storeh->transaction_quantity = $item['quantity'];
                        $storeh->issued_date = date('Y-m-d');
                        $storeh->description = $flush->particulars;
                        $storeh->vendor = $item['vendor'];
                        $storeh->type = 11; // decrease

                        $storeh->issued_by = Yii::$app->user->identity->id;
                        $storeh->given_to = $request->raised_by;
                        $storeh->item_id = $item['item_id'];
                        if (!$storeh->save()) {
                           throw new \Exception('could not save to store history');
                          // var_dump($storeh->getErrors()); die();
                            
                        }
                    

          }
        }
      }elseif ($request->task_type==2) {
        foreach($items as $item)
        {
          $flush=Inventory::find()->where(['id'=>$item['id']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
          // if returned item is countable then add back to store ledger
          if($flush->countable==1 && $request['concluded']==1)
          {
            $flush->quantity+=$item['quantity'];
            if(!$flush->save())
            {
              // var_dump($flush->getErrors()); die();
              throw new \Exception('could not save to inventory');
            }

            // enter transaction into shop history

            $shoph = new ShopHistory();
            $shoph->cid = Yii::$app->user->identity->cid;
            $shoph->name = $item['item_name'];
            $shoph->quantity = $item['quantity'];

            $shoph->price = 0;
            $shoph->staff = Yii::$app->user->identity->id;
            // $storeh->received_date=date('Y-m-d');
            $shoph->created_at = date('Y-m-d');
            $shoph->item_id = $item['item_id'];
            $shoph->issued_by = Yii::$app->user->identity->id;
            $shoph->received_by = $request->raised_by;
            $shoph->type = 1;
            $shoph->qout=$item['quantity'];
            $shoph->transaction_id = $request->transaction_id;
            $shoph->countable = 0;


            if (!$shoph->save()) {
                
                throw new \Exception('could not save to shop history1');
              // var_dump($shoph->getErrors()); die();
                
            }
          }
        }
      }else{
        // die('Unknown transaction description');
        throw new \Exception('Unknown transaction description 5');
      }

      if(!$entry->delete())
      {
        throw new \Exception('Could not delete main transaction');
      }


      if(!$request->delete())
      {
        throw new \Exception('Could not delete from requisition'); 
      }

      $del=Dels::find()->where(['transaction_id'=>$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
      $del->done=1;
      if(!$del->save())
      {
        throw new \Exception('Could not update Dels');
      }


      $transaction->commit();

                } catch (\Exception $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                } catch (\Throwable $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                }

                return $this->redirect(['rev']);



    }



    function actionRemove_single_transaction()
    {
      // fetch all payment entries from ledger
      // check if its more than one if it is go ahead and delete it
      $id=Yii::$app->request->get('tid');
      $specific=Yii::$app->request->get('id');
      $bigleg=Ledger::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['transaction_id'=>$id])->one();

      $check1=Ledger::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['tlink'=>$id])->count();


// var_dump($check); die;
        $transaction = Yii::$app->db->beginTransaction();
      try {
      if($check1>1)
      {
        $entries=Ledger::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['id'=>$specific])->one();

        $bank=Banks::findOne($entries->bank);
        $bank->balance-=$entries['amount_paid'];
        if(!$bank->save())
        {
          //var_dump($bank->getErrors()); die();
          throw new \Exception('could not save to bank');
        }

        if(!$entries->delete())
{
  // var_dump($entries->getErrors()); die;
  throw new \Exception('could not delete specific entry');
}
      }else{
        $check=Dels::find()->where(['transaction_id'=>$id])->one();
        if(empty($check))
        {
          $new = new Dels();
          $new->transaction_id=$id;
          $new->done=0;
          $new->cid=Yii::$app->user->identity->cid;
          $new->ttype=$bigleg['ptype'];
          if(!$new->save())
          {
            throw new \Exception('could not save to deletions');
          }

          $bigleg->open=1;
          if(!$bigleg->save())
          {
            throw new \Exception('could not set open to 1');
          }

        }
        ?>
        <script type="text/javascript">
        alert('Entry has been forwarded for further action'); 
        </script>
        <?php
         die('Entry has been forwarded for further action');
        

      }
      if(!Entry::deleteAll(['lid'=>$specific]))
        {
          throw new \Exception('could not delete from real entries');
        }

      $transaction->commit();

                } catch (\Exception $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                } catch (\Throwable $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                }

      return $this->redirect(['cashbookk']);
    }

    public function actionSale_details($id,$tid)
    {
      //$details=Ledger2::findOne($id);
      $details=Ledger2::find()->where(['transaction_id'=>$tid])->all();
      return $this->render('sale_details',['details'=>$details]);
    }

    public function actionStart_reverse()
    {
        ob_start();
        $id=Yii::$app->request->get('tid');
        $check=Dels::find()->where(['transaction_id'=>$id])->one();
        $enter=Ledger::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['transaction_id'=>$id])->one();

           $transaction = Yii::$app->db->beginTransaction();
      try {
        if(empty($check))
        {
          $new = new Dels();
          $new->transaction_id=$id;
          $new->done=0;
          $new->cid=Yii::$app->user->identity->cid;
          $new->ttype=$enter['ptype'];
          if(!$new->save())
          {
            throw new \Exception('could not save to deletions');
          }

          $enter->open=1;
          if(!$enter->save())
          {
            throw new \Exception('could not change open to 1');
          }

        }
        ob_flush();
        ?>

<script type="text/javascript">
alert('Request has been forwarded for further action');
</script>
        <?php

        $transaction->commit();

                } catch (\Exception $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                } catch (\Throwable $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                }


        return $this->redirect(['reverse']);
    }

    public function actionRev()
    {
      if(Yii::$app->user->identity->role=='Store Manager'){
      $revs=Dels::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['done'=>0])->andWhere(['ttype'=>2])->all();
    }
      if(Yii::$app->user->identity->role=='Shop Manager'){
      $revs=Dels::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['done'=>0])->andWhere(['ttype'=>1])->all();
    }
     

      // $joe=Ledger::findAll([$add]); var_dump($joe); die;
      return $this->render('rev',['revs'=>$revs]);
    }

    public function actionPush_discount()
    {
      $tid=Yii::$app->request->post('rid');
      $amount=Yii::$app->request->post('amount');
      $chart_account=Yii::$app->request->post('chart_account');
      $chart_account2=Yii::$app->request->post('chart_account2');
      $entry_type=Yii::$app->request->post('entry_type');
      $entry_type2=Yii::$app->request->post('entry_type2');

      $done=1;     

      $dico=new Discounts();
      $dico->cid=Yii::$app->user->identity->cid;
       
// 
      $dico->discount=$amount;
      $dico->transaction_id=$tid;
      $dico->status=0;
      $dico->entry_type=$entry_type;
      $dico->entry_type2=$entry_type2;
      $dico->chart_account=$chart_account;
      $dico->chart_account2=$chart_account2;
      if(!$dico->save())
      {
        $done=0;
        // var_dump($dico->getErrors()); die;
       throw new \Exception("Could not save to 7890");
        
      }
      echo $done;
    }


    public function actionAdd()
    {
      unset($session['dtid']);
      $sales=Ledger2::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['status'=>0])->groupBy(['transaction_id'])->all();
      $shopt=Shops::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();
      //$shopt->shop_type; 
      return $this->render('add',['sales'=>$sales,'st'=>$shopt->shop_type]);
    }

    public function actionClose()
    {
      return $this->render('close');
    }

    public function actionDo_discount()
    {
        $tid=Yii::$app->request->get('tid');
        $id=Yii::$app->request->get('id');
        $leg=Ledger::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();

        $disk=Discounts::findOne($id);

         $fcheck=Ledger::find()->where(['transaction_id'=>$tid])->one();

        $query="select sum(amount_paid) from ledger where tlink='".$tid."' and cid='".Yii::$app->user->identity->cid."'";
        $links = Yii::$app->db->createCommand($query)->queryScalar(); 

        if(trim($fcheck['credit']-$disk['discount'])<trim($fcheck['amount_paid']+$links)){

          die('Cannot offer discount to this customer');
        }       

        $transaction = Yii::$app->db->beginTransaction();
        try {
        $dis=Discounts::findOne($id);
        $dis->status=1;

        if(!$dis->save())
        {
          throw new \Exception("Could not update discount to 1");
          
        }

       
        if($leg->ptype==1)
        {
          $leg->credit-=$dis->discount;  
           if(!$leg->save())
            {
             
              // var_dump($leg->getErrors()); die;
              throw new \Exception('could not save to ledger1');
            }      
        }

        if($leg->ptype==2)
        {
          $leg->debit-=$dis->discount;  
             if(!$leg->save())
            {
              
              // var_dump($leg->getErrors()); die;
              throw new \Exception('could not save to ledger2');
            }      
        }

$amount=$dis->discount;
$entry_type=$dis->entry_type; $entry_type2=$dis->entry_type2;
$chart_account=$dis->chart_account; $chart_account2=$dis->chart_account2;

 $ac1=Charts::findOne($chart_account);
        $ac2=Charts::findOne($chart_account2);

        $entry_group=$ac1->atype;
        $entry_group2=$ac2->atype;

        $account_group=$ac1->account_group;
        $account_group2=$ac2->account_group;


      if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
      {
        $amount=($amount*-1);
      }
      if($entry_type==2 && ($entry_group==1 || $entry_group==5))
      {
        $amount=($amount*-1);
      } 

      $enter = new Entry;
        $enter->amount=$amount;
        $enter->entry_type=$entry_type;
        $enter->entry_group=$entry_group;
        $enter->chart_account=$chart_account;       
        
        $enter->account_group=$account_group;
        $enter->who=Yii::$app->user->identity->id;
        $enter->cid=Yii::$app->user->identity->cid;
        $enter->created_at=date('Y-m-d');
        $enter->fid=$dis->id;
        $enter->dsource='d';
        $enter->transaction_id=$tid;
        //$enter->lid=$new->id;
        
        if(!$enter->save())
        {
          //var_dump($enter->getErrors()); die;
          throw new \Exception('Could not save entry');
        }

        // second entry

        $amount=abs($amount);
        // entry 2

      if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
      {
        $amount=($amount*-1);
      }
      if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
      {
        $amount=($amount*-1);
      }


        $enter2 = new Entry;
        $enter2->amount=$amount;
        $enter2->entry_type=$entry_type2;
        $enter2->entry_group=$entry_group2;
        $enter2->chart_account=$chart_account2;
    
        $enter2->account_group=$account_group2;
        $enter2->who=Yii::$app->user->identity->id;
        $enter2->cid=Yii::$app->user->identity->cid;
        $enter2->created_at=date('Y-m-d');
        $enter2->fid=$dis->id;
        $enter2->dsource='d';
        $enter2->transaction_id=$tid;
        //$enter2->lid=$new->id;
        if(!$enter2->save())
        {
          //var_dump($enter2->getErrors()); die;
          throw new \Exception('Could not save entry2');
        }
$amount=abs($amount);

           $transaction->commit();

                } catch (\Exception $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                } catch (\Throwable $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                }
          return $this->redirect(['dis']);

         
    }


    public function actionTrial()
    {
      // $balances=Entry::model()->findAll();
     // $edetails_sql="select sum(amount) as amount, date_paid_out, description, expense_type from Expenses where date_paid_out between '".$date1."' and '".$date2."' && cid='".Yii::app()->user->cid."' group by expense_type";
     // $expense_details = Yii::app()->db->createCommand($edetails_sql)->queryAll();
    $client=Clients::findOne(Yii::$app->user->identity->cid);
     $model= new Ledger;
     if(Yii::$app->request->post()){ 
    $date1=Yii::$app->request->post('date1');
     $date2=Yii::$app->request->post('date2');
        
       
      $entry_sql="select sum(amount) as amount, chart_account, entry_type, entry_group, id from entry where created_at between '".$date1."' and '".$date2."' && cid='".Yii::$app->user->identity->cid."' group by chart_account";
//$entry_sql="select sum(entry.amount) as amount, entry.chart_account, entry.entry_type, entry.entry_group, entry.id, charts.id, charts.account_group from entry,charts where entry.created_at between '".$date1."' and '".$date2."' && entry.cid='".Yii::app()->user->cid." on charts.id=entry.chart_account' group by entry.chart_account";
     $entry = Yii::$app->db->createCommand($entry_sql)->queryAll(); 
     // var_dump($entry); die;         

     }
    return $this->render('trial',['balances'=>$entry,'model'=>$model,'date2'=>$date2,'client'=>$client]);
    }



    public function actionDis()
    {
      $lists=Discounts::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['status'=>0])->all();
      return $this->render('discount_list',['lists'=>$lists]);
    }

    public function actionEntry()
    {
      $model= new Entry; return $this->render('entry',['model'=>$model]);
    }

    public function actionDo_rev()
    {
      ob_start();
      $id=Yii::$app->request->post('tid');
     

      $check=Dels::find()->where(['transaction_id'=>$id])->one();
        $enter=Ledger::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['transaction_id'=>$id])->one();

           $transaction = Yii::$app->db->beginTransaction();
      try {
        if(empty($check))
        {
          $new = new Dels();
          $new->transaction_id=$id;
          $new->done=0;
          $new->cid=Yii::$app->user->identity->cid;
          $new->ttype=$enter['ptype'];
          if(!$new->save())
          {
            throw new \Exception('could not save to deletions');
          }

          $enter->open=1;
          if(!$enter->save())
          {
            throw new \Exception('could not change open to 1');
          }

        }
        
      

        $transaction->commit();

                } catch (\Exception $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                } catch (\Throwable $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                }
                \Yii::$app->response->data="Marked for Reversal";
    }

    public function actionSale_edit($id,$tid)
    {

      $sale=Ledger2::find()->where(['id'=>$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one(); 
   
      return $this->render('sale_edit',['sale'=>$sale,'rec_id'=>$id,'transaction_id'=>$tid]);
      
    }

    public function actionIgnore()
    {
      $tid=Yii::$app->request->get('tid');
      $id=Yii::$app->request->get('id');
      $men = Dels::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['transaction_id'=>$tid])->one();
      if(!$men->delete())
      {
        throw new \Exception("Could not run cancel discount");
        // var_dump($men->getErrors()); die;
        
      }
      return $this->redirect(['rev']);
    }


    public function actionClosesale25()
    {
        ob_start();

        $vendor;

        // payment:payment,
        // amount_paid:amount_paid,
        // customer:customer,
        // table_no:table_no,
        // record:record,
        // tid:tid


        $payment=Yii::$app->request->post('payment');
        $amount_paid=Yii::$app->request->post('amount_paid');

        $customer=Yii::$app->request->post('customer');

        $transaction_id=Yii::$app->request->post('tid');

        $record=Yii::$app->request->post('record');
        $table=Yii::$app->request->post('table_no');

        $shopy=Shops::findOne(Yii::$app->user->identity->shop_id); 

        $transaction = Yii::$app->db->beginTransaction();
                try {

        $rec=Ledger2::find()->where(['transaction_id'=>$transaction_id,'cid'=>Yii::$app->user->identity->cid])->one();
        $rec2=Ledger2::find()->where(['transaction_id'=>$transaction_id,'cid'=>Yii::$app->user->identity->cid])->all();
foreach($rec2 as $re)
{
        $re->payment_method=600000000;
        if(!$re->save())
          {
            throw new \Exception('could not update payment_method');
          }
}
        // $rec->payment_method=600000000;
        // if(!$rec->save())
        //   {
        //     throw new \Exception('could not update payment_method');
        //   }



                if($payment==600000000){
  $check=Tabs::find()->where(['customer'=>$customer])->one();
  if($check==null){
              $tab =  new Tabs;
              $tab->customer=$customer;
              $tab->bill_ids.=$record;
              $tab->cid=Yii::$app->user->identity->cid;
              $tab->status=0;
              $tab->shop_type=$shopy->shop_type;
              if(!$tab->save())
              {
                throw new \Exception('could not save to tab');
              }
                 }else{
                  $check->bill_ids.=",".$ledger->id;
                  if(!$check->save())
                  {
                    throw new \Exception("Could not update tab");
                    
                  }
                 }

            }


              // foreach($rec2 as $position)
              // {
              //   $position->status=1;
              //   if(!$position->save())
              //   {
              //     throw new \Exception('could not update leger2 status');
              //   }
              // }

             $transaction->commit();
                  // }

                    } catch (\Exception $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    } catch (\Throwable $e) {
                        $transaction->rollBack();
                        throw $e; die('failed');
                    }
    }


    public function actionIgnore_discount()
    {
      $tid=Yii::$app->request->get('tid');
      $id=Yii::$app->request->get('id');

      $men = Discounts::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['id'=>$id])->one();

      $men->status=1;
      if(!$men->save())
      {
        throw new \Exception("Could not save to discount");
        // var_dump($men->getErrors()); die;
        
      }
      return $this->redirect(['dis']);
    }

    public function actionGetfastfood()
    {
        ob_start();
        $room=Yii::$app->request->post('rooms');
        $query=Inventory::find()->where(['category'=>$room])->all();

        
        $photo='';
        foreach($query as $vom)
        {  !empty($vom->photo) ? $photo='@web/cats/'.$vom->photo : $photo='@web/cats/jollof.jpg';
            ?>

<span style="float:left; margin:5px; border-radius:5px; text-align:center;"><?= Html::img($photo, ['class' => 'pull-center img-responsive','style'=>'height:70px; width:auto; border-radius:5px;','onclick'=>'tocart('.$vom->id.')']) ?><?= $vom->name ?></span>

            <?php
        }
    }


    public function actionGetlaundry()
    {
        ob_start();
        $room=Yii::$app->request->post('rooms');
        $query=Inventory::find()->where(['category'=>$room])->all();

        
        $photo='';
        foreach($query as $vom)
        {  !empty($vom->photo) ? $photo='@web/cats/'.$vom->photo : $photo='@web/cats/jollof.jpg';
            ?>

<span style="float:left; margin:5px; border-radius:5px; text-align:center;"><?= Html::button($vom->name,['onclick'=>'tocart2('.$vom->id.')','class'=>'btn btn-success form-control','style'=>'display:block; margin-bottom:5px;']) ?></span>

            <?php
        }
    }


    public function actionSales_list()
    {
      $results=null;
      $to=null;
      $from=null;
      if(Yii::$app->request->post()){ 

       $from=Yii::$app->request->post('from');
      $to=Yii::$app->request->post('to');

      $query="select *from ledger where substr(created_at, 1,10) between '".$from."' and '".$to."'";
      $results=Ledger::findBySql($query)->all();


      }

return $this->render('sales_list',['results'=>$results,'from'=>$from,'to'=>$to]);
    }


    public function actionCash_transfer()
    {
      $results=null;
      $to=null;
      $from=null;
      if(Yii::$app->request->post()){ 

        $from=Yii::$app->request->post('from');
        $to=Yii::$app->request->post('to');
        $amount=Yii::$app->request->post('amount');

        $bank1=Banks::findOne($from);
        $bank2=Banks::findOne($to);

        if($bank1->balance<$amount)
        {
          die('You inssufficient funds in account that money is being moved from');
        }

        $bank1->balance-=$amount;
        $bank2->balance+=$amount;

        $transaction_id=time().rand(1,9);

            $transaction = Yii::$app->db->beginTransaction();
            try {

              if(!$bank1->save()){ throw new \Exception('could not save bank1'); }

              if(!$bank2->save()){ throw new \Exception('could not save bank2'); }

              // decrease
              // payment type 2 is a debit and is for expenditure and reduces ledger balance
              $ledger = new Ledger;             
              $ledger->credit=0;
              $ledger->debit=$amount;
              $ledger->department = Yii::$app->user->identity->department;
              $ledger->cid = Yii::$app->user->identity->cid;
              $ledger->staff=Yii::$app->user->identity->id;
              $ledger->description = "inter accounts transfer";
              $ledger->vendor = '0';
              $ledger->payment_method=0;
              //$ledger->leg2_link=0;
              $ledger->amount_paid=$amount;
              $ledger->transaction_id=$transaction_id;
              $ledger->details='';
              $ledger->ptype=2;
              $ledger->bank=$from;

                if(!$ledger->save())
                {
                    
                  // throw new \Exception( 'could not save to ledger' );  
                   var_dump($ledger->getErrors()); die;
                }


                // increase
                // payment 


              $ledger = new Ledger;             
              $ledger->credit=$amount;
              $ledger->debit=0;
              $ledger->department = Yii::$app->user->identity->department;
              $ledger->cid = Yii::$app->user->identity->cid;
              $ledger->staff=Yii::$app->user->identity->id;
              $ledger->description = "inter accounts transfer";
              $ledger->vendor = '0';
              $ledger->payment_method=0;
              //$ledger->leg2_link=0;
             $ledger->amount_paid=$amount;
              $ledger->transaction_id=$transaction_id;
              $ledger->details='';
              $ledger->ptype=1;
              $ledger->bank=$to;

                if(!$ledger->save())
                {
                    
                  // throw new \Exception( 'could not save to ledger' );  
                   var_dump($ledger->getErrors()); die;
                }

              $transaction->commit();
   
            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; 
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; 
            }


         Yii::$app->session->setFlash('success', 'Funds successfully Transfered');

        }

        

        return $this->render('cash_transfer');
    }


    public function actionBalance()
    {
      // $balances=Entry::model()->findAll();
     // $edetails_sql="select sum(amount) as amount, date_paid_out, description, expense_type from Expenses where date_paid_out between '".$date1."' and '".$date2."' && cid='".Yii::app()->user->cid."' group by expense_type";
     // $expense_details = Yii::app()->db->createCommand($edetails_sql)->queryAll();
    $client=Clients::findOne(Yii::$app->user->identity->cid);
     $model= new Ledger;
      if(Yii::$app->request->post()){ 
    $date1=Yii::$app->request->post('date1');
     $date2=Yii::$app->request->post('date2');
      
      $entry_sql="select sum(amount) as amount, chart_account, entry_type, entry_group, id from entry where created_at between '".$date1."' and '".$date2."' && cid='".Yii::$app->user->identity->cid."' group by chart_account";
//$entry_sql="select sum(entry.amount) as amount, entry.chart_account, entry.entry_type, entry.entry_group, entry.id, charts.id, charts.account_group from entry,charts where entry.created_at between '".$date1."' and '".$date2."' && entry.cid='".Yii::app()->user->cid." on charts.id=entry.chart_account' group by entry.chart_account";
     $entry = Yii::$app->db->createCommand($entry_sql)->queryAll(); 
     // var_dump($entry); die;

          $entry_sql2="select sum(amount) as amount, chart_account, entry_type, entry_group, account_group, id from entry where created_at between '".$date1."' and '".$date2."' && cid='".Yii::$app->user->identity->cid."' group by account_group";
//$entry_sql="select sum(entry.amount) as amount, entry.chart_account, entry.entry_type, entry.entry_group, entry.id, charts.id, charts.account_group from entry,charts where entry.created_at between '".$date1."' and '".$date2."' && entry.cid='".Yii::app()->user->cid." on charts.id=entry.chart_account' group by entry.chart_account";
     $entry2 = Yii::$app->db->createCommand($entry_sql2)->queryAll(); 

      // $entry = Yii::app()->db->createCommand()
      // ->select('select sum(amount) as amount, chart_account, entry_type, entry_group, id')
      // ->from('entry e')
      // ->join('chart_account c','e.account_group=c.id')
      // ->where('created_at >:d1 and created_at <:d2 and cid=:c',array(':d1'=>$date1,':d2'=>$date2,':c'=>Yii::app()->user->cid))
      // ->group('chart_account')
      // ->queryAll();

     $asset_sql="select sum(amount) as amount, chart_account, entry_type, entry_group, id, account_group from entry where created_at between '".$date1."' and '".$date2."' && cid='".Yii::$app->user->identity->cid."' and entry_group=1 group by account_group";
     $asseto = Yii::$app->db->createCommand($asset_sql)->queryAll();

     $lia_sql="select sum(amount) as amount, chart_account, entry_type, entry_group, id, account_group from entry where created_at between '".$date1."' and '".$date2."' && cid='".Yii::$app->user->identity->cid."' and entry_group=2 group by account_group";
     $liab = Yii::$app->db->createCommand($lia_sql)->queryAll();

     $equit_sql="select sum(amount) as amount, chart_account, entry_type, entry_group, id, account_group from entry where created_at between '".$date1."' and '".$date2."' && cid='".Yii::$app->user->identity->cid."' and entry_group=3 group by account_group";
     $equit = Yii::$app->db->createCommand($equit_sql)->queryAll();

     $exp_sql="select sum(amount) as amount, chart_account, entry_type, entry_group, id, account_group from entry where created_at between '".$date1."' and '".$date2."' && cid='".Yii::$app->user->identity->cid."' and entry_group=4 group by account_group";
     $exp = Yii::$app->db->createCommand($exp_sql)->queryAll();

     $rev_sql="select sum(amount) as amount, chart_account, entry_type, entry_group, id, account_group from entry where created_at between '".$date1."' and '".$date2."' && cid='".Yii::$app->user->identity->cid."' and entry_group=5 group by account_group";
     $rev = Yii::$app->db->createCommand($rev_sql)->queryAll();

     }
    return $this->render('balance',array('balances'=>$entry,'model'=>$model,'date2'=>$date2,'client'=>$client,'asseto'=>$asseto,'liab'=>$liab,'equit'=>$equit,'balances2'=>$entry2,'rev'=>$rev,'exp'=>$exp));
    }

      public function actionDetails()
    {
      $tid=Yii::$app->request->post('tid');
      $ctype=Clients::findOne(Yii::$app->user->identity->cid)->industry;
      if($ctype==2)
      {
        $det=Ledger2::find()->where(['transaction_id'=>$tid])->one()->details;
        $det1=json_decode($det,true);

        $hot='Quantity';
        foreach($det1 as $vo)
        {
          if(isset($vo['hotel']) && $vo['hotel']==1)
          {
            $hot='Days';
          }
        }
        ?>
        <table class="table table-striped table-bordered">
          <tr style="font-weight:bold;">
            <td>Item Name</td> <td><?= $hot ?></td><td>Price</td>
          </tr>
        <?php
        foreach($det1 as $de)
        {
            ?> <tr>
            <td><?= $de['item_name'] ?></td> <td><?= $de['quantity'] ?></td><td><?= $de['price'] ?></td>
          </tr>
          <?php
          
          $tot+=($de['quantity']*$de['price']);
        }
        ?>
        <tr style="font-weight:bold;"><td></td><td colspan="">Total</td><td><?= number_format($tot,2); ?></td></tr>
      </table>
        <?php
      }

      if($ctype==1)
      {
        $det=Requisitions::find()->where(['transaction_id'=>$tid])->one()->requested_item;
        $det1=json_decode($det,true);
      
      ?>
        <table class="table table-striped table-bordered">
          <tr style="font-weight:bold;">
            <td>Item Name</td> <td>Quantity</td><td>Price</td>
          </tr>
        <?php
        foreach($det1 as $de)
        {
            ?> <tr>
            <td><?= $de['item_name'] ?></td> <td><?= $de['quantity'] ?></td><td><?= $de['amount'] ?></td>
          </tr>
          <?php
          // var_dump($de);
          $tot+=($de['quantity']*$de['amount']);
        }
        ?>
        <tr style="font-weight:bold;"><td></td><td colspan="">Total</td><td><?= number_format($tot,2); ?></td></tr>
      </table>
        <?php
      }
    }

    public function actionLprint()
    {
      /* Call this file 'hello-world.php' */
       
       
        // $connector = new WindowsPrintConnector("mark4");
        // $printer = new Printer($connector);
        // $printer -> text("Hello World!\n");
        // $printer -> cut();
        // $printer -> close();

        try{
    $connector = new WindowsPrintConnector("mark4");
      $printer = new Printer($connector);

      /* Information for the receipt */
      $items = array(
          new item("Example item #1", "4.00"),
          new item("Another thing", "3.50"),
          new item("Something else", "1.00"),
          new item("A final item", "4.45"),
      );
      $subtotal = new item('Subtotal', '12.95');
      $tax = new item('A local tax', '1.30');
      $total = new item('Total', '14.25', true);
      /* Date is kept the same for testing */
      // $date = date('l jS \of F Y h:i:s A');
      $date = "Monday 6th of April 2015 02:56:25 PM";

      /* Start the printer */
      // $logo = EscposImage::load("resources/escpos-php.png", false);
      $printer = new Printer($connector);

      /* Print top logo */
      $printer -> setJustification(Printer::JUSTIFY_CENTER);
      // $printer -> graphics($logo);

      /* Name of shop */
      $printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
      $printer -> text("ExampleMart Ltd.\n");
      $printer -> selectPrintMode();
      $printer -> text("Shop No. 42.\n");
      $printer -> feed();

      /* Title of receipt */
      $printer -> setEmphasis(true);
      $printer -> text("SALES INVOICE\n");
      $printer -> setEmphasis(false);

      /* Items */
      $printer -> setJustification(Printer::JUSTIFY_LEFT);
      $printer -> setEmphasis(true);
      $printer -> text(new item('', '$'));
      $printer -> setEmphasis(false);
      foreach ($items as $item) {
          $printer -> text($item);
      }
      $printer -> setEmphasis(true);
      $printer -> text($subtotal);
      $printer -> setEmphasis(false);
      $printer -> feed();

      /* Tax and total */
      $printer -> text($tax);
      $printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
      $printer -> text($total);
      $printer -> selectPrintMode();

      /* Footer */
      $printer -> feed(2);
      $printer -> setJustification(Printer::JUSTIFY_CENTER);
      $printer -> text("Thank you for shopping at ExampleMart\n");
      $printer -> text("For trading hours, please visit example.com\n");
      $printer -> feed(2);
      $printer -> text($date . "\n");

      /* Cut the receipt and open the cash drawer */
      $printer -> cut();
      $printer -> pulse();

      $printer -> close();
      } catch (Exception $e) {
          echo "Couldn't print to this printer: " . $e -> getMessage() . "\n";
      }

      /* A wrapper to do organise item names & prices into columns */
          }
}

class item
{
    private $name;
    private $price;
    private $dollarSign;
    private $quantity;

    public function __construct($name = '', $quantity = '', $price = '', $dollarSign = false)
    {
        $this -> name = $name;
        $this -> price = $price;
        $this -> dollarSign = $dollarSign;
        $this-> quantity = $quantity;
    }

     public function __toString()
    {
        $rightCols = 10;
        $leftCols = 25;
        $centerCols = 10;
        // if ($this -> dollarSign) {
        //     $leftCols = $leftCols / 2 - $rightCols / 2;
        // }
        $left = str_pad($this -> name, $leftCols) ;

        $center = str_pad($this -> quantity, $centerCols) ;

        $sign = ($this -> dollarSign ? '$ ' : '');
        $right = str_pad($this -> price, $rightCols, ' ', STR_PAD_LEFT);
        return "$left$center$right\n";
    }

}




// require __DIR__ . '/vendor/autoload.php';
// use Mike42\Escpos\Printer;
// use Mike42\Escpos\EscposImage;
// use Mike42\Escpos\PrintConnectors\FilePrintConnector;

// /* Open the printer; this will change depending on how it is connected */
// $connector = new FilePrintConnector("/dev/usb/lp0");
// $printer = new Printer($connector);

// /* Information for the receipt */
// $items = array(
//     new item("Example item #1", "4.00"),
//     new item("Another thing", "3.50"),
//     new item("Something else", "1.00"),
//     new item("A final item", "4.45"),
// );
// $subtotal = new item('Subtotal', '12.95');
// $tax = new item('A local tax', '1.30');
// $total = new item('Total', '14.25', true);
// /* Date is kept the same for testing */
// // $date = date('l jS \of F Y h:i:s A');
// $date = "Monday 6th of April 2015 02:56:25 PM";

// /* Start the printer */
// $logo = EscposImage::load("resources/escpos-php.png", false);
// $printer = new Printer($connector);

// /* Print top logo */
// $printer -> setJustification(Printer::JUSTIFY_CENTER);
// $printer -> graphics($logo);

// /* Name of shop */
// $printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
// $printer -> text("ExampleMart Ltd.\n");
// $printer -> selectPrintMode();
// $printer -> text("Shop No. 42.\n");
// $printer -> feed();

// /* Title of receipt */
// $printer -> setEmphasis(true);
// $printer -> text("SALES INVOICE\n");
// $printer -> setEmphasis(false);

// /* Items */
// $printer -> setJustification(Printer::JUSTIFY_LEFT);
// $printer -> setEmphasis(true);
// $printer -> text(new item('', '$'));
// $printer -> setEmphasis(false);
// foreach ($items as $item) {
//     $printer -> text($item);
// }
// $printer -> setEmphasis(true);
// $printer -> text($subtotal);
// $printer -> setEmphasis(false);
// $printer -> feed();

// /* Tax and total */
// $printer -> text($tax);
// $printer -> selectPrintMode(Printer::MODE_DOUBLE_WIDTH);
// $printer -> text($total);
// $printer -> selectPrintMode();

// /* Footer */
// $printer -> feed(2);
// $printer -> setJustification(Printer::JUSTIFY_CENTER);
// $printer -> text("Thank you for shopping at ExampleMart\n");
// $printer -> text("For trading hours, please visit example.com\n");
// $printer -> feed(2);
// $printer -> text($date . "\n");

// /* Cut the receipt and open the cash drawer */
// $printer -> cut();
// $printer -> pulse();

// $printer -> close();

// /* A wrapper to do organise item names & prices into columns */
// class item
// {
//     private $name;
//     private $price;
//     private $dollarSign;

//     public function __construct($name = '', $price = '', $dollarSign = false)
//     {
//         $this -> name = $name;
//         $this -> price = $price;
//         $this -> dollarSign = $dollarSign;
//     }

//     public function __toString()
//     {
//         $rightCols = 10;
//         $leftCols = 38;
//         if ($this -> dollarSign) {
//             $leftCols = $leftCols / 2 - $rightCols / 2;
//         }
//         $left = str_pad($this -> name, $leftCols) ;

//         $sign = ($this -> dollarSign ? '$ ' : '');
//         $right = str_pad($sign . $this -> price, $rightCols, ' ', STR_PAD_LEFT);
//         return "$left$right\n";
//     }
// }


// 15562969607

//54400
//

//54400

//54400
