<?php

namespace frontend\controllers;

use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

class ReportsController extends \yii\web\Controller
{
        public function behaviors()
    {
        return [
            'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','create','delete','update','findModel'],
                    'roles' => ['@'],
                ],
                 [
                    'allow' => true,
                    'actions' => ['rinflow'],
                    'roles' => ['Client Admin','accounts'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        return $this->render('index');
    }

    public function actionRinflow()
    {
    	if(isset($_POST['sent']))
    	{
    		$results = (new \yii\db\Query())
		  //  ->select(['id', 'email'])
		    ->from('requisitions')
		    ->where('id!=:sam', [':sam' => 0])
		     ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid]);
		    $string='';
		    $var=609;
		    $var1=900;
		   // ->limit(10)

		    if(isset($_POST['tasktype']) && !empty($_POST['tasktype']))
		    {
		    	$results=$results->andWhere('task_type=:task',[':task'=>$_POST['tasktype']]);
		    	$string.=' Task Type';
		    }

		     if(isset($_POST['department']) && !empty($_POST['department']))
		    {
		    	$results=$results->andWhere('originating_department=:orig',[':orig'=>$_POST['department']]);
		    	$string.=' Department';
		    }

		     if(isset($_POST['raised_by']) && !empty($_POST['raised_by']))
		    {
		    	$results=$results->andWhere('raised_by=:raise',[':raise'=>$_POST['raised_by']]);
		    	$string.=' Originator';
		    }

		     if(!empty($_POST['concluded']) && isset($_POST['concluded']))
		    {
		    	
		    	if($_POST['concluded']=='not_concluded')
		    	{
		    		$string.=' Not Concluded';
		    		$var1=0;
		    	}
		    	elseif($_POST['concluded']=='concluded'){
		    		$string.=' Concluded';
		    		$var1=1;
		    	}
		    	$results=$results->andWhere('concluded=:conc',[':conc'=>$var1]);
		    	
		    }

		        if(isset($_POST['rejected']) && !empty($_POST['rejected']))
		    {
		    	
		    	if($_POST['rejected']=='not_rejected')
		    	{
		    		$string.=' Not Rejected'; $var=0;
		    	}elseif($_POST['rejected']=='rejected'){
		    		$string.=' Rejected'; $var=1;
		    	}
		    	$results=$results->andWhere('rejected=:rejo',[':rejo'=>$var]);
		    	
		    }

		     if(!empty($_POST['from']) && !empty($_POST['to']))
		    {		    	
		    	$results=$results->andWhere(['between','SUBSTR(created_at,1,10)',$_POST['from'], $_POST['to']]);
		    	$string.=' Between '.date('jS F Y',strtotime($_POST['from'])).' and '.date('jS F Y',strtotime($_POST['to']));
		    }


		    $results=$results->all();
    	}
    	return $this->render('r_inflow',['results'=>$results,'string'=>$string]);
    }

}
