<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Rooms;
use frontend\models\RoomsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;
use frontend\models\Taken;
use frontend\models\Inventory;
use frontend\models\Ledger;
use frontend\models\Accounts;

date_default_timezone_set('Africa/Lagos');

/**
 * RoomsController implements the CRUD actions for Rooms model.
 */
class RoomsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Rooms models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RoomsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Rooms model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Rooms model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Rooms();

        if ($model->load(Yii::$app->request->post())) {

        $room=Rooms::find()->where(['room_type'=>$model->room_type])->one();
        if($room!=null)
        {
            die('You have already created room numbers for these category of rooms');
        }

        for($x=1; $x<=$model->total_rooms; $x++)
        {
            $looms[]=($model->room_range+$x);
        }

        $model->rooms=json_encode($looms);



            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Rooms model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

        // $room=Rooms::find()->where(['room_type'=>$model->room_type])->one();
        // if($room!=null)
        // {
        //     die('You have alread created room numbers for this room');
        // }

        for($x=1; $x<=$model->total_rooms; $x++)
        {
            $looms[]=($model->room_range+$x);
        }
        $model->rooms=json_encode($looms);

        $model->save();

            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Rooms model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Rooms model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Rooms the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Rooms::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionGetrooms()
    {
        ob_start();
        $room=Yii::$app->request->post('rooms');
        $query=Rooms::find()->where(['room_type'=>$room])->one();
        $voom=json_decode($query->rooms,true);

        foreach($voom as $vom)
        {
            ?>

<span style="float:left;"><?= Html::img('@web/beds/bed2.jpg', ['class' => 'pull-center img-responsive','style'=>'height:70px; width:auto;']) ?><?= $vom ?></span>

            <?php
        }
    }

    public function actionGetrooms2()
    {
        $no=Yii::$app->request->post('no');
        $rooms=Rooms::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['room_type'=>$no])->one();
        
        $roo=json_decode($rooms->rooms,true);
       echo Html::dropDownList('room',null, $roo,['class'=>'form-control camp','prompt'=>'','id'=>'roomy','style'=>'background-color:red; color:#fff;']);
         
    }

    // get account

    public function actionDobill()
    {
        $no=Yii::$app->request->post('no');
        if($no==2){
        $account=Accounts::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

        $one=array();
        $two=array();

        foreach($account as $ac1)
        {
            array_push($one, $ac1->id);
        }

         foreach($account as $ac2)
        {
            array_push($two, $ac2->company);
        }


        //$roo=json_decode($rooms->rooms,true);
        $get=array_combine($one,$two);
       echo Html::dropDownList('account',null, $get,['class'=>'form-control','prompt'=>'','id'=>'account1','style'=>'']);
   }
         
    }

    public function actionExtendit()
    {
        $done=0;
        $id=Yii::$app->request->post('id');
        $date=Yii::$app->request->post('datex');
        $record=Taken::findOne($id);

        $old_date=$record->departure;
        $new_date=$date;
        $created=substr($record->created_at,1,10);

        // start set new total

        $date1=date_create($created);
        $date2=date_create($date);
        $diff=date_diff($date2,$date1);
        $michael=(int)$diff->format("%a");

        $price=Inventory::find()->where(['id'=>$record['room_type']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one()->price;
        $total=$michael*$price;

        $new_total=Ledger::find()->where(['transaction_id'=>$record->transaction_id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
        $new_total->credit=$total;
        $new_total->save();

        // end set new total

        $record->departure=$date;
        if($record->save())
        {
            $done=1;
        }
        echo json_encode(array('done'=>$done,'idx'=>$id,'newdate'=>$date,'textt'=>$total));
    }


}
