<?php

namespace backend\controllers;

use Yii;
use backend\models\Clients;
use backend\models\SearchClients;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\User;
use frontend\models\Requisitions;
use frontend\models\Stores;
use frontend\models\StoresHistory;
use frontend\models\Ledger;
use yii\data\Pagination;
use yii\filters\AccessControl;


/**
 * ClientsController implements the CRUD actions for Clients model.
 */
class ClientsController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
         'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','reports','store','viewusers','sledger',
                    'itemdetails','update','cashbook','delete','findModel','create'],
                    'roles' => ['adminRole'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Clients models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SearchClients();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Clients model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Clients model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Clients();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Clients model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Clients model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }


    /**
     * Finds the Clients model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Clients the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Clients::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionViewusers($id)
    {
        $users=User::find()->where(['cid'=>$id])->all();
        return $this->render('view_users',['id'=>$id,'users'=>$users]);
    }


    public function actionReports()
    {       
    
       $id=Yii::$app->request->get('id');
        if(isset($_POST['sent']))
        {
           
            $id=Yii::$app->request->post('id');
            $results = (new \yii\db\Query())
          //  ->select(['id', 'email'])
            ->from('requisitions')
            ->where('id!=:sam', [':sam' => 0])
             ->andWhere('cid=:po',[':po'=>$id]);
            $string='';
            $var=609;
            $var1=900;
           // ->limit(10)

            if(isset($_POST['tasktype']) && !empty($_POST['tasktype']))
            {
                $results=$results->andWhere('task_type=:task',[':task'=>$_POST['tasktype']]);
                $string.=' Task Type';
            }

             if(isset($_POST['department']) && !empty($_POST['department']))
            {
                $results=$results->andWhere('originating_department=:orig',[':orig'=>$_POST['department']]);
                $string.=' Department';
            }

             if(isset($_POST['raised_by']) && !empty($_POST['raised_by']))
            {
                $results=$results->andWhere('raised_by=:raise',[':raise'=>$_POST['raised_by']]);
                $string.=' Originator';
            }

             if(!empty($_POST['concluded']) && isset($_POST['concluded']))
            {
                
                if($_POST['concluded']=='not_concluded')
                {
                    $string.=' Not Concluded';
                    $var1=0;
                }
                elseif($_POST['concluded']=='concluded'){
                    $string.=' Concluded';
                    $var1=1;
                }
                $results=$results->andWhere('concluded=:conc',[':conc'=>$var1]);
                
            }

                if(isset($_POST['rejected']) && !empty($_POST['rejected']))
            {
                
                if($_POST['rejected']=='not_rejected')
                {
                    $string.=' Not Rejected'; $var=0;
                }elseif($_POST['rejected']=='rejected'){
                    $string.=' Rejected'; $var=1;
                }
                $results=$results->andWhere('rejected=:rejo',[':rejo'=>$var]);
                
            }

             if(!empty($_POST['from']) && !empty($_POST['to']))
            {               
                $results=$results->andWhere(['between','SUBSTR(created_at,1,10)',$_POST['from'], $_POST['to']]);
                $string.=' Between '.date('jS F Y',strtotime($_POST['from'])).' and '.date('jS F Y',strtotime($_POST['to']));
            }


            $results=$results->all();
           return $this->render('reports',['results'=>$results,'string'=>$string,'id'=>$id]);           
           
        }else{
             return $this->render('reports',['id'=>$id]);
             
        }
        
    }

     public function actionSledger($id)
    {
        $records=Stores::find()->where(['=','cid',$id])->all();
        return $this->render('sledger',['records'=>$records,'id'=>$id]);
    }

    public function actionItemdetails($tid,$id)
    {
        $history=StoresHistory::find()->where(['=','transaction_id',$tid])->andWhere(['=','cid',$id])->all();
        return $this->render('item_details',['history'=>$history]);
    }

     public function actionCashbook($id)
    {
       

        //preparing the query
        // $baba=0;
        // if(!empty(Yii::$app->request->get('mbal')) || Yii::$app->request->get('mbal')!=0)
        // {
        //     echo Yii::$app->request->get('mbal'); die;
        // }

       $query = Ledger::find()->where(['=','cid',$id]);
       // get the total number of users
       $count = $query->count();
       //creating the pagination object
       $pagination = new Pagination(['totalCount' => $count, 'defaultPageSize' => 10]);
       //limit the query using the pagination and retrieve the users
      // $pagination->pageParam='page';
     // $pagination->params=['page'=>Yii::$app->request->get('page'),'bal'=>$baba];
       $models = $query->offset($pagination->offset)
          ->limit($pagination->limit)
          ->all();

          // foreach($models as $mod)
          // {
          //   $bal+=($mod->credit-$mod->debit);
          // }
          
       return $this->render('cashbook', [
          'model' => $models,
          'pages' => $pagination,
       ]);

       
    }
}
