<?php
namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\models\AdminLoginForm;
use backend\models\SignupForm;
use backend\models\ClientSignupForm;
use backend\models\Clients;

/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['signup'],  
                        'allow' => true,                     
                        'roles' => ['adminRole'],
                        // 'roleParams' => ['postId' => Yii::$app->request->get('id')],
                    ],
                    [
                        'actions' => ['login', 'error','index'],
                        'allow' => true,
                    ], 
                    [
                    'actions'=>['logout','clientsignup','regsuccess'],
                    'allow'=>true,
                    'roles' => ['@'],
                    ],                               
                    
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {
        
        return $this->render('index');
    }

    /**
     * Login action.
     *
     * @return string
     */
    public function actionLogin()
    {
        
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new AdminLoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
           // return $this->goBack();
            return $this->redirect(['clients/index']);
             // return $this->redirect(['requisitions/viewrequisition','id'=>$id,'doc'=>$doc]);

        } else {
            $model->password = '';

            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Logout action.
     *
     * @return string
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    public function actionSignup()
    {
        $model = new SignupForm();
        if ($model->load(Yii::$app->request->post())) {
            if ($user = $model->signup()) {
                // if (Yii::$app->getUser()->login($user)) {
                //     return $this->goHome();
                // }
                //echo "success";
                 return $this->redirect(['site/regsuccess','client'=>Yii::$app->request->post('cid')]);
            }
        }

        return $this->render('signup', [
            'model' => $model,
        ]);
    }



     public function actionClientsignup($id)
    {
        $model = new ClientSignupForm();
        $name=Clients::findOne($id)->client_name;
        //var_dump(Yii::$app->request->post()); die;
        if ($model->load(Yii::$app->request->post())) {
            if ($user = $model->clientsignup()) {

                // if (Yii::$app->getUser()->login($user)) {
                //     return $this->goHome();
                // }
                //echo "success";
                 return $this->redirect(['clients/viewusers','id'=>$id]);
            }
        }

        return $this->render('client_signup', [
            'model' => $model,
            'client_id'=>$id,
            'name'=>$name,
        ]);
    }

    public function actionRegsuccess($client)
    {
        return $this->render('regsuccess');
    }





  
}
