<?php

namespace frontend\models;

use Yii;



/**
 * This is the model class for table "inventory".
 *
 * @property int $id
 * @property int $cid
 * @property string $barcode
 * @property string $name
 * @property string $description
 * @property double $quantity
 * @property double $supply_price
 * @property int $reorder
 * @property int $staff
 * @property double $price
 * @property string $created_at
 * @property string $updated_at
 * @property int $category
 * @property int $supplier
 * @property string $photo
 * @property int $countable
 */
class Inventory extends \yii\db\ActiveRecord implements \yz\shoppingcart\CartPositionInterface
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'inventory';
    }

     
    use  \yz\shoppingcart\CartPositionTrait;
    public function getPrice()
    {
        return $this->price;
    }

    public function getId()
    {
        return $this->id;
    }
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cid', 'staff', 'price','countable'], 'required'],
            [['cid', 'reorder', 'staff', 'category', 'supplier','countable'], 'integer'],
            [['description'], 'string'],
            [['quantity', 'supply_price', 'price'], 'number'],
            [['created_at', 'updated_at'], 'safe'],
            [['barcode'], 'string', 'max' => 200],
            [['name'], 'string', 'max' => 250],
            [['photo'], 'string', 'max' => 100],
            [['barcode'], 'unique'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Client Id',
            'barcode' => 'Barcode',
            'name' => 'Name',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'supply_price' => 'Supply Price',
            'reorder' => 'Reorder',
            'staff' => 'Staff',
            'price' => 'Price',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'category' => 'Category',
            'supplier' => 'Supplier',
            'photo' => 'Photo',
            'countable' => 'Deductable / Non-deductable'
        ];
    }
}
