<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "shops".
 *
 * @property int $id
 * @property string $name
 * @property int $cid
 * @property string $address
 * @property string $phone
 * @property int $shop_head
 * @property int $location
 */
class Shops extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'shops';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'cid', 'address', 'phone', 'shop_head', 'location'], 'required'],
            [['cid', 'shop_head', 'location'], 'integer'],
            [['address'], 'string'],
            [['name'], 'string', 'max' => 225],
            [['phone'], 'string', 'max' => 25],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'cid' => 'Cid',
            'address' => 'Address',
            'phone' => 'Phone',
            'shop_head' => 'Shop Head',
            'location' => 'Location',
        ];
    }
}
