<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Banks;
use frontend\models\BanksSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\models\Ledger;

/**
 * BanksController implements the CRUD actions for Banks model.
 */
class BanksController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Banks models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new BanksSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Banks model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Banks model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Banks();



        if ($model->load(Yii::$app->request->post())) {   
                       $transaction = Yii::$app->db->beginTransaction();
 try {     


            if(!$model->save())
            {
                throw new \Exception( 'could not save bank opening balance' ); 
            }

            $ledger= new Ledger();
                $ledger->debit=0;
                $ledger->credit=$model->balance;
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date('Y-m-d');
                $ledger->transaction_id='0'; 
                $ledger->vendor='0';   
                $ledger->amount_paid=$model->balance;  
                $ledger->description="Opening balance for ".$model->bank;
                $ledger->ptype=1;
                $ledger->bank=$model->bid;
                if(!$ledger->save())
                {
                    
                    throw new \Exception( 'could not save to ledger' );  
                   // var_dump($ledger->getErrors()); die;
                    // 15508444924
                    // 15508412687
                }

                 $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }

            return $this->redirect(['view', 'id' => $model->bid]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Banks model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        die('You cannot do this');
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->bid]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Banks model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Banks model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Banks the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Banks::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
