<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Customers;
use frontend\models\CustomersSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;


/**
 * CustomersController implements the CRUD actions for Customers model.
 */
class CustomersController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Customers models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CustomersSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Customers model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Customers model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Customers();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Customers model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Customers model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Customers model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Customers the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Customers::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

     public function actionSaveit()
    {
        if(Yii::$app->request->post() && Yii::$app->user->identity->department==1 && Yii::$app->user->identity->place==2)
            {
                
                $s=0;

                $name=Yii::$app->request->post('name');
                $email=Yii::$app->request->post('email');
                $phone=Yii::$app->request->post('phone');
                $address=Yii::$app->request->post('address');

                $customer=new Customers();

                $customer->name=$name;
                $customer->email=$email;
                $customer->address=$address;
                $customer->phone=$phone;
                $customer->cid=Yii::$app->user->identity->cid;
                $customer->created_at=date('Y-m-d H:i:s');
                if($customer->save())
                {
                    $s=1;
                }

                \Yii::$app->response->data=$s;
           }
    }

    public function actionCledger()
    {
  
        if(isset($_POST['sent']))
        {

      

             $income = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
            ->where('id!=:sam', [':sam' => 0])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid])
            ->andWhere('ptype=:kk',[':kk'=>1])
            ->andWhere('vendor=:j',[':j'=>$_POST['vendor']]);
         
            if(!empty($_POST['from']) && !empty($_POST['to']))
            {
                $income=$income->andWhere(['between','SUBSTR(created_at,1,10)',$_POST['from'], $_POST['to']]);
            }
                
           

            $income=$income->all();

            return $this->render('cledger',['income'=>$income]);


        }else{
          

        return $this->render('cledger');
    }
    }




    
}
