<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Instruments;
use frontend\models\SearchInstruments;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

/**
 * InstrumentsController implements the CRUD actions for Instruments model.
 */
class InstrumentsController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','create','delete','update','findModel','expenditure_requisition',
                    'purchase_order','equipment_requisition','delivery_note','payment_voucher','material_requisition',
                    'transfer_note','invoice','cashbook','receipt','waybill'],
                    'roles' => ['@'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Instruments models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SearchInstruments();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Instruments model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Instruments model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Instruments();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Instruments model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Instruments model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Instruments model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Instruments the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Instruments::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionExpenditure_requisition()
    {
        return $this->render('expenditure_requisition');
    }

    public function actionPurchase_order()
    {
        return $this->render('purchase_order');
    }

    public function actionEquipment_requisition()
    {
        return $this->render('equipment_requisition');
    }

    public function actionDelivery_note()
    {
        return $this->render('delivery_note');
    }

    public function actionPayment_voucher()
    {
        return $this->render('payment_voucher');
    }


    public function actionMaterial_requisition()
    {
        return $this->render('material_requisition');
    }

    public function actionTransfer_note()
    {
        return $this->render('transfer_note');
    }

    public function actionInvoice()
    {
        return $this->render('invoice');
    }

    public function actionCashbook()
    {
        return $this->render('cashbook');
    }

    public function actionReceipt()
    {
        return $this->render('receipt');
    }

     public function actionWaybill()
    {
        return $this->render('waybill');
    }
}
