<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Ledger;
use frontend\models\LedgerDel;
use frontend\models\SearchLedger;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\data\Pagination;
use yii\filters\AccessControl;
use frontend\models\Banks;
use frontend\models\Requisitions;

use backend\models\Clients;
use backend\models\User;
use backend\models\Workflow;
use frontend\models\Customers;
use yii\helpers\Html;
use frontend\models\Inventory;
use frontend\models\Ledgergo;
use frontend\models\Stores;



/**
 * LedgerController implements the CRUD actions for Ledger model.
 */
class LedgerController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
              'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','create','update','findModel','begining','cashbook',
                    'cash','debtors','tdetails','cashbookk','creditors','cdetails','reverse',
                    'reverseit','sales','get_receipt','last_receipt','history','history2','pay','payc',
                    'ledgergo'],
                    'roles' => ['accounts','Client Admin'],
                ],
                  [
                    'allow' => true,
                    'actions' => ['delete'],  
                    'roles' => ['Client Admin']                 
                ],
                [
                    'allow' => true,
                    'actions' => ['save_payment','save_payment2'],  
                    'roles' => ['accounts']                 
                ],
                //  [
                //     'allow' => true,
                //     'actions' => ['error'],  
                //     'roles' => ['?','@']                 
                // ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

     /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

   

    /**
     * Lists all Ledger models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SearchLedger();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Ledger model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Ledger model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Ledger();

        if ($model->load(Yii::$app->request->post())) {

            $debit=str_replace(',', '', $model->debit);
            $credit=str_replace(',', '', $model->credit);

            $model->debit=$debit;
            $model->credit=$credit;

            if(!$model->save())
            {
                var_dump($model->getErrors()); die;
            }
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Ledger model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            

            $debit=str_replace(',', '', $model->debit);
            $credit=str_replace(',', '', $model->credit);

            $model->debit=$debit;
            $model->credit=$credit;

            if(!$model->save())
            {
                var_dump($model->getErrors()); die;
            }
            
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Ledger model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Ledger model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Ledger the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Ledger::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionBegining()
    {
        die('You cannot do this');
        $model = new Ledger();
        if(isset($_POST['Ledger']))
        {
            if ($model->load(Yii::$app->request->post())) {

            $debit=str_replace(',', '', $model->debit);
            $credit=str_replace(',', '', $model->credit);

            $model->debit=$debit;
            $model->credit=$credit;
            $model->amount_paid=$credit;
            $model->transaction_id=time().rand(1,12);
            $model->description='Opening Balance';
            $model->vendor="Client Opening Balance";
            $model->open=7;

            if(!$model->save())
            {
                var_dump($model->getErrors()); die;
            }
            return $this->redirect(['view', 'id' => $model->id]);
        }
        }
        return $this->render('begining',['model'=>$model]);
    }

    public function actionCashbook()
    {
       

        //preparing the query
        // $baba=0;
        // if(!empty(Yii::$app->request->get('mbal')) || Yii::$app->request->get('mbal')!=0)
        // {
        //     echo Yii::$app->request->get('mbal'); die;
        // }

       $query = Ledger::find()->where(['=','cid',Yii::$app->user->identity->cid]);
       // get the total number of users
       $count = $query->count();
       //creating the pagination object
       $pagination = new Pagination(['totalCount' => $count, 'defaultPageSize' => 100]);
       //limit the query using the pagination and retrieve the users
      // $pagination->pageParam='page';
     // $pagination->params=['page'=>Yii::$app->request->get('page'),'bal'=>$baba];
       $models = $query->offset($pagination->offset)
          ->limit($pagination->limit)
          ->all();

          // foreach($models as $mod)
          // {
          //   $bal+=($mod->credit-$mod->debit);
          // }
          
       return $this->render('cashbook', [
          'model' => $models,
          'pages' => $pagination,
       ]);

       
    }

    public function actionCash()
    {
        $records = new ActiveDataProvider(['query' => Ledger::find()->where(['=','cid',Yii::$app->user->identity->cid]),
            'pagination'=>['pageSize'=>10],

            ]);
        return $this->render('cash',['records'=>$records]);
    }

    public function actionDebtors()
    {
        // $debtors=Ledger::find()->where(['sum','amount_paid','credit'])->all();
        $query="select sum(credit) as credit, sum(amount_paid) as amount_paid, transaction_id, vendor from ledger where ptype=1 and cid='".Yii::$app->user->identity->cid."' group by vendor";
        $debtors=Ledger::findBySql($query)->all();

//         echo "<pre>";
// var_dump($debtors); 
// echo "</pre>";

// die;
        return $this->render('debtors',['debtors'=>$debtors]);
    }

    public function actionTdetails($id)
    {
        $records=Ledger::find()->where(['=','vendor',$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['aorb'=>1])->andWhere(['>','credit',0])->orderBy('id desc')->all();
        return $this->render('tdetails',['records'=>$records]);
    }


    public function actionCdetails($id)
    {
        $records=Ledger::find()->where(['=','vendor',$id])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['aorb'=>1])->andWhere(['>','debit',0])->orderBy('id desc')->all();
        $balances=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
        return $this->render('cdetails',['records'=>$records,'balances'=>$balances]);
    }

    public function actionSave_payment()
    {
        ob_start();
        $done=0;

        $rid=Yii::$app->request->post('rid');
        $amount=Yii::$app->request->post('amount');
        $bank=Yii::$app->request->post('bank');
        $record=Ledger::find()->where(['=','id',$rid])->one();

        $querya="select sum(amount_paid) from ledger where tlink='".$record->transaction_id."'";
  $saj = Yii::$app->db->createCommand($querya)->queryScalar(); 

if(($amount+$saj+$record->amount_paid)<=$record->credit)
{
        $new = new Ledger();
        $new->amount_paid+=$amount;
        $new->bank=$bank;
        $new->cid=$record->cid;
        $new->department=$record->department;
        $new->description=$record->description;
        $new->credit=0;
        $new->amount_paid=$amount;
        $new->transaction_id=time().rand(1,9);
        $new->debit=$record->debit;
        $new->vendor=$record->vendor;
        $new->open=$record->open;
        $new->ptype=$record->ptype;
        $new->aorb=2;
        $new->tlink=$record->transaction_id;

       // $npaid= $record->amount_paid+=$amount;
        if($new->save())
        {
            $done=1;

           $dbank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['bid'=>$bank])->one();
           $dbank->balance+=$amount;
          $dbank->save();
        }

        $all=json_encode(array('done'=>$done,'npaid'=>$record->amount_paid+$saj+$amount,'nout'=>$record->credit-$record->amount_paid-$saj-$amount));
        echo $all;
      }else{
        $all=json_encode(array('done'=>'3'));
        echo $all;
      }

    }


    // save payment2

    public function actionSave_payment2()
    {
        ob_start();
        $done=0;

        $rid=Yii::$app->request->post('rid');
        $amount=Yii::$app->request->post('amount');
        $bank=Yii::$app->request->post('bank');
        $record=Ledger::find()->where(['=','id',$rid])->one();

        $cbank=Banks::findOne($bank);

        $querya="select sum(amount_paid) from ledger where tlink='".$record->transaction_id."'";
  $saj = Yii::$app->db->createCommand($querya)->queryScalar(); 

if($cbank->balance>$amount){
if(($amount+$saj+$record->amount_paid)<=$record->debit)
{
        $new = new Ledger();
        $new->amount_paid+=$amount;
        $new->bank=$bank;
        $new->cid=$record->cid;
        $new->department=$record->department;
        $new->description=$record->description;
        $new->credit=0;
        $new->amount_paid=$amount;
        $new->transaction_id=time().rand(1,9);
        $new->debit=0;
        $new->vendor=$record->vendor;
        $new->open=$record->open;
        $new->ptype=$record->ptype;
        $new->aorb=2;
        $new->tlink=$record->transaction_id;

       // $npaid= $record->amount_paid+=$amount;
        if($new->save())
        {
            $done=1;

           $dbank=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['bid'=>$bank])->one();
           $dbank->balance-=$amount;
          $dbank->save();
        }

        $all=json_encode(array('done'=>$done,'npaid'=>$record->amount_paid+$saj+$amount,'nout'=>$record->debit-$record->amount_paid-$saj-$amount));
        echo $all;
      }else{ $all=json_encode(array('done'=>3));
echo $all; }
    }else{ 

$all=json_encode(array('done'=>2));
echo $all;

    }

    }

    public function actionCashbookk()
    {
      
     $from=Yii::$app->request->post('from');
     $to=Yii::$app->request->post('to');
     $bank=Yii::$app->request->post('bank');

     //$leave=Ledger::find()->where(['<','created_at',$from]) ->all();
if(empty($bank)){
       $querya="select sum(amount_paid) from ledger where SUBSTR(created_at,1,10)<'".$from."'";
     }else{
       $querya="select sum(amount_paid) from ledger where SUBSTR(created_at,1,10)<'".$from."' && bank='".$bank."'";
     }
  $bal = Yii::$app->db->createCommand($querya)->queryScalar(); 

     $balances=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();

     if(Yii::$app->request->post()){ 
          $query = Ledger::find()->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['between','SUBSTR(created_at,1,10)',$from,$to])->andWhere(['!=','amount_paid',0]);

          if(!empty($bank)){
            $query=$query->andWhere(['bank'=>$bank]);
          }

          $query=$query->all();
       return $this->render('cashbookk', [
          'model' => $query,
          'balances' => $balances,
          'bank' => $bank,
          'out' => $bal,
         
       ]);
     }else{

      return $this->render('cashbookk',['balances' => $balances]);
    }
    }

    public function actionCreditors()
    {
        // $debtors=Ledger::find()->where(['sum','amount_paid','credit'])->all();
        $query="select sum(debit) as debit, sum(amount_paid) as amount_paid, transaction_id, vendor from ledger where ptype=2 and cid='".Yii::$app->user->identity->cid."' group by vendor";
        $creditors=Ledger::findBySql($query)->all();

        return $this->render('creditors',['creditors'=>$creditors]);
    }

    public function actionReverse()
    {
      if(Yii::$app->request->post())
      {
        $tid=Yii::$app->request->post('tid');
        $to=Yii::$app->request->post('to');
        $from=Yii::$app->request->post('from');

        $reverse = (new \yii\db\Query())
           // ->select(['id'])
            ->from('ledger')
            ->where('id!=:sam', [':sam' => 0])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid]);
            
            if(!empty(Yii::$app->request->post('from')) && !empty(Yii::$app->request->post('to')))
            {
                $reverse=$reverse->andWhere(['between','SUBSTR(created_at,1,10)',Yii::$app->request->post('from'), Yii::$app->request->post('to')]);
            }


            if(!empty(Yii::$app->request->post('tid')))
            {
                $reverse=$reverse->andWhere(['=','transaction_id',$tid]);
            }

            $reverse=$reverse->andWhere(['!=','ptype',0])->andWhere(['aorb'=>1]);

            $reverse=$reverse->all();
                     
            

      }
      return $this->render('reverse',['reverse'=>$reverse]);
    }

    public function actionReverseit()
    {
      $tid=Yii::$app->request->get('tid'); 

       $links=Ledger::find()->where(['tlink'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->all();


       $transaction = Yii::$app->db->beginTransaction();
 try {
$ben=Ledger::find()->where(['transaction_id'=>$tid])->one();

     // if(!$del=Ledger::deleteAll(['transaction_id'=>$tid]))
     // {
     //   throw new \Exception('could not delete from ledger'); 
     // }
      


      // $kept=new LedgerDel();
      // $kept->setAttributes($ben);
      // if(!$kept->save())
      // {
      //    throw new \Exception('could not save to could no save to ledgerdel'); 
      // }

       $del2=Requisitions::find()->where(['transaction_id'=>$tid])->one();

if($del2!=null){
if($del2->concluded==1){
       $items=json_decode($del2->requested_item,true);

       foreach($items as $it)
       {
       
       
        if($del2->task_type==1)
        {
           $bobo=Stores::findOne($it['item_id']);
           $bobo->quantity-=$it['quantity'];
        }

        if($del2->task_type==2)
        {
           $bobo=Inventory::find()->where(['item_id'=>$it['item_id']])->one();
           $bobo->quantity+=$it['quantity'];
        }
        if(!$bobo->save())
        {
          throw new \Exception('could not save to Inventory'); 
        } 
       }
     }
   }
       

        
foreach($links as $link){
  $can=Banks::findOne($link->bank);
        if($link->ptype==1){
        $can->balance-=$link->amount_paid;
      }

          if($link->ptype==2){
        $can->balance+=$link->amount_paid;
      }
      if(!$can->save())
      {
         throw new \Exception('could not save to bank' ); 
      }

        if($link!=null){
      if(!$link->delete())
      {
         throw new \Exception('could not delete balance payments on transaction from ledger' ); 
      }
      if($del2!=null){
      if(!$del2->delete())
       {
         throw new \Exception('could not Delete from Requisitions' ); 
       }
     }
    }

}
  

    if(!$ben->delete()){
        throw new \Exception('could not delete entry from ledger' ); 
      }

       $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }

        

       return $this->redirect(['reverse']);


    }

    public function actionSales()
    {

      if(Yii::$app->request->post())
      {
         $from=Yii::$app->request->post('from');
         $to=Yii::$app->request->post('to');
        $tid=Yii::$app->request->post('tid');

         $sales=Ledger::find()->where(['aorb'=>2])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['ptype'=>1]);
         if(!empty($from) || !empty($to))
         {
           $sales=$sales->andWhere(['between','SUBSTR(created_at,1,10)',$from,$to]);
         }
         if(!empty($tid))
         {
            $sales=$sales->andWhere(['transaction_id'=>$tid]);
         }
         $sales=$sales->orderBy('id desc')->all();

      }else{
         $sales=Ledger::find()->where(['aorb'=>2])->andWhere(['cid'=>Yii::$app->user->identity->cid])->andWhere(['ptype'=>1])->orderBy('id desc')->all();
      }

     
      return $this->render('sales',['sales'=>$sales]);
    }

    public function actionGet_receipt()
    {
      ob_start();
      $tid=Yii::$app->request->post('tid');
      $tlink=Yii::$app->request->post('tlink');

      $main=Ledger::find()->where(['transaction_id'=>$tlink])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
      $adds=Ledger::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();

      $client=Clients::findOne(Yii::$app->user->identity->cid);

        $fat=Requisitions::find()->where(['transaction_id'=>$tlink])->one();
      
      $cro=json_decode($fat->requested_item,true);

      ?>

            <div id="holder" style="width:100%;">
<h1 style="text-align:center;">Sales Receipt</h1>
<table class="table table-bordered" style="">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:12px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">SALES RECEIPT</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO: <?php echo $tid; ?></td>
</tr>



  <tr style="font-weight:bold;">
  
    <td colspan="2">Recieved from: <?= ucwords($main->customer->name) ?> </td>
  </tr>

  <tr style="font-weight:bold;">
    <?php
    // $total=0;
    // $goods='';
    //   foreach(json_decode($record->requested_item,true) as $item)
    //   {
    //     $total+=$item['total'];
    //     $goods.=$item['item_name'].', ';
    //   }
    ?>
  
    <td colspan="2">The sum of:<span style="font-weight:normal;"> <?php echo ucwords(Yii::$app->Formatter->asSpellout($adds['amount_paid'])); ?> Naira Only.</span></td>
  </tr>
  <tr style="font-weight:bold;">
  
    <td colspan="2">Being payment for : <span style="font-weight:normal;"> <?= empty($cro[0]['narration']) ? 'Goods Purchased' : ucfirst($cro[0]['narration']) ?> on <span sytle='font-weight:bold; color:red;'><?= $tlink ?></span> </span> </td>
  </tr>

  </tr>


  <tr style="font-weight:bold;">
   <td>Company Rep: <span style="font-weight:normal;"><?php $name=User::findOne(Yii::$app->user->identity->id); echo ucwords($name->first_name." ".$name->last_name); ?></span> </td>
    
    <td>Amount Paid: <del>N</del> <?php echo number_format($adds['amount_paid'],2); ?></td>
    
  </tr>

 
<tr>
<td colspan="2" id="noshow" style="text-align:right;"><?= Html::button('Print Receipt',['class'=>'btn btn-primary','onclick'=>'print()','style'=>'']) ?></td>
</tr>

</table>
</div>

      <?php
    }


    // show last

    public function actionLast_receipt()
    {
      ob_start();
      $tid=Yii::$app->request->post('tid');
      // $tlink=Yii::$app->request->post('tlink');

      $main=Ledger::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
      $adds=Ledger::find()->where(['tlink'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orderBy('id desc')->one();

      $client=Clients::findOne(Yii::$app->user->identity->cid);

      $fat=Requisitions::find()->where(['transaction_id'=>$tid])->one();
      
      $cro=json_decode($fat->requested_item,true);


      ?>

            <div id="holder" style="width:100%;">
<h1 style="text-align:center;">Sales Receipt</h1>
<table class="table table-bordered" style="">
<tr>

<td colspan="3" style="text-align:center; font-weight:bold;"><?php echo ucwords($client->client_name); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-size:12px;"><?php echo ucwords($client->client_address); ?></td>
</tr>

<tr>

<td colspan="3"  style="text-align:center; font-weight:bold;">SALES RECEIPT</td>
</tr>

<tr style="font-weight:bold;">

<td colspan="3"  style="text-align:center;">NO: <?php echo $tid; ?></td>
</tr>




  <tr style="font-weight:bold;">
  <?php //ucwords(Customers::findOne($main->vendor)->name) ?>
    <td colspan="2">Recieved from: <?=  ucwords($main->customer->name) ?> </td>
  </tr>

  <tr style="font-weight:bold;">
    <?php
    // $total=0;
    // $goods='';
    //   foreach(json_decode($record->requested_item,true) as $item)
    //   {
    //     $total+=$item['total'];
    //     $goods.=$item['item_name'].', ';
    //   }
    ?>
  
    <td colspan="2">The sum of:<span style="font-weight:normal;"> <?php echo ucwords(Yii::$app->Formatter->asSpellout($adds['amount_paid'])); ?> Naira Only.</span></td>
  </tr>
  <tr style="font-weight:bold;">
  
    <td colspan="2">Being payment for : <span style="font-weight:normal;"><?= empty($cro[0]['narration']) ? 'Goods Purchased' : ucfirst($cro[0]['narration']) ?> <?php //echo ucwords($goods); ?> </span> </td>
  </tr>

  </tr>
  <tr style="font-weight:bold;">
  
    <td>Company Rep: <span style="font-weight:normal;"><?php $name=User::findOne(Yii::$app->user->identity->id); echo ucwords($name->first_name." ".$name->last_name); ?></span> </td>
    <td>Amount Paid: <del>N</del> <?php echo number_format($adds['amount_paid'],2); ?></td>
  </tr>




<tr>
<td colspan="2" id="noshow" style="text-align:right;"><?= Html::button('Print Receipt',['class'=>'btn btn-primary','onclick'=>'print()','style'=>'']) ?></td>
</tr>

</table>
</div>

      <?php
    }



     public function actionHistory()
    {
      ob_start();
      $tid=Yii::$app->request->post('tid');
      // $tlink=Yii::$app->request->post('tlink');

      $main=Ledger::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
      $adds=Ledger::find()->where(['tlink'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orWhere(['transaction_id'=>$tid])->andWhere(['!=','amount_paid',0])->orderBy('id desc')->all();

      ?>
      <div style="font-weight:bold;"><?= "Sale Value: ".number_format($main->credit,2) ?></div>
<table class="table table-bordered table-striped">
<tr>
<th>Date</th>
<th>Amount Paid</td>
<td>Balance</th>
</tr>
<?php
foreach($adds as $add)
{
  ?>
<tr>
<td><?= date('jS F Y',strtotime($add->created_at)) ?></td>
<td><?= number_format($add->amount_paid,2) ?></td>
<td><?= number_format($main->credit-=$add->amount_paid,2) ?></td>
</tr>
  <?php
}

?>

</table>

      <?php

      }




    public function actionHistory2()
    {
      ob_start();
      $tid=Yii::$app->request->post('tid');
      // $tlink=Yii::$app->request->post('tlink');

      $main=Ledger::find()->where(['transaction_id'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
      $adds=Ledger::find()->where(['tlink'=>$tid])->andWhere(['cid'=>Yii::$app->user->identity->cid])->orWhere(['transaction_id'=>$tid])->andWhere(['!=','amount_paid',0])->orderBy('id desc')->all();

      ?>
      <div style="font-weight:bold;"><?= "Expenditure Value: ".number_format($main->debit,2) ?></div>
<table class="table table-bordered table-striped">
<tr>
<th>Date</th>
<th>Amount Paid</td>
<td>Balance</th>
</tr>
<?php
foreach($adds as $add)
{
  ?>
<tr>
<td><?= date('jS F Y',strtotime($add->created_at)) ?></td>
<td><?= number_format($add->amount_paid,2) ?></td>
<td><?= number_format($main->debit-=$add->amount_paid,2) ?></td>
</tr>
  <?php
}

?>

</table>

      <?php

      }



      public function actionPay($tid,$tlink=0,$id)
      {
         $record=Requisitions::find()->where(['transaction_id'=>$tid])->one();
         return $this->render('payment_voucher',['tid'=>$tid,'record'=>$record,'tlink'=>$tlink,'id'=>$id]);
      }

        public function actionPayc($tid,$tlink=0,$id)
      {
         $record=Requisitions::find()->where(['transaction_id'=>$tid])->one();
         return $this->render('invoice',['tid'=>$tid,'record'=>$record,'tlink'=>$tlink,'id'=>$id]);
      }

//       public function actionLedgergo()
//       {
//         $goo=Ledgergo::find()->all();

//                     $transaction = Yii::$app->db->beginTransaction();
//  try {

//         foreach($goo as $go)
//         {
//           $new=new Ledger();
               
//           $new->amount_paid+=$go->amount_paid;
//           $new->bank=$go->bank;
//           $new->cid=$go->cid;
//           $new->department=$go->department;
//           $new->description=$go->description;
//           $new->credit=$go->credit;
//           $new->transaction_id=$go->transaction_id;
//           $new->debit=$go->debit;
//           $new->vendor=$go->vendor;
//           $new->open=$go->open;
//           $new->ptype=$go->ptype;
//           $new->aorb=$go->aorb;
//           $new->tlink=$go->tlink;
//           $new->created_at=$go->created_at;
//           if(!$new->save())
//           {
//             throw new \Exception('could not save to ledgergo'); 
//           }

//           if($go->ptype==1)
//           {
//             if(!empty($go->bank)){
//             $vo=Banks::findOne($go->bank);
//             $vo->balance+=$go->amount_paid;
//             if(!$vo->save())
//             {
//               throw new \Exception('could increment bank balance'); 
//             }}
//           }

//           if($go->ptype==2)
//           {
//             if(!empty($go->bank)){
//               $vo=Banks::findOne($go->bank);
//             $vo->balance-=$go->amount_paid;
//             if(!$vo->save())
//             {
//               throw new \Exception('could deduct from bank balance'); 
//             }}
//           }

//         }
//          $transaction->commit();

//             } catch (\Exception $e) {
//                 $transaction->rollBack();
//                 throw $e; die('failed');
//             } catch (\Throwable $e) {
//                 $transaction->rollBack();
//                 throw $e; die('failed');
//             }
//       }

   


    // public function actionSave_payment()
    // {
    //     ob_start();
    //     $done=0;

    //     $rid=Yii::$app->request->post('rid');
    //     $amount=Yii::$app->request->post('amount');
    //     $bank=Yii::$app->request->post('bank');
    //     $record=Ledger::find()->where(['=','id',$rid])->one();
    //     $record->amount_paid+=$amount;
    //     $record->bank=$bank;
    //    // $npaid= $record->amount_paid+=$amount;
    //     if($record->save())
    //     {
    //         $done=1;
    //     }

    //     $all=json_encode(array('done'=>$done,'npaid'=>$record->amount_paid,'nout'=>$record->credit-$record->amount_paid));
    //     echo $all;
    // }
}
