<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Requisitions;
use frontend\models\RequisitionsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\Workflow;
use frontend\models\Notifications;
use backend\models\RequisitionTypes;
use frontend\models\Ledger;
use frontend\models\Items;
use frontend\models\Stores;
use frontend\models\StoresHistory;
use backend\models\User;
use frontend\models\Messages;
use yii\filters\AccessControl;
use backend\models\Transfers;
use backend\models\TransfersHistory;
use frontend\models\Inventory;
use backend\models\Tasks;
use frontend\models\Vendors;
use frontend\models\Productions;
use frontend\models\Banks;
use frontend\models\ShopHistory;


/**
 * RequisitionsController implements the CRUD actions for Requisitions model.
 */
class RequisitionsController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','create','delete','update','findModel','viewrequisition',
                    'approve','decline2','decline','myrequisitions','requisitiondetails',
      'attentionrequired','allrejections','allnotifications',
                    'viewnotification','outflow','land','editr','viewrejections','edelete'
                  ],
                    'roles' => ['@'],
                ],

                 [
                    'allow' => true,
                    'actions' => ['allrequisitions'],
                    'roles' => ['Client Admin'],
                ],
                 [
                    'allow' => true,
                    'actions' => ['pnl'],
                    'roles' => ['Client Admin','accounts'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Requisitions models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RequisitionsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Requisitions model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Requisitions model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
         $cart = new  \yz\shoppingcart\ShoppingCart();
         //\Yii::$app->cart->removeAll();
         $cart->removeAll();
        $model = new Requisitions();

        if ($model->load(Yii::$app->request->post())) {
            $model->transaction_id=time().rand(1,9);
          
           $ben=array();


           foreach($model->requested_item as $req)
           {
             $req['amount']; 
            $req['total']=$req['amount']*$req['quantity']; 
          
           $ben[]=array('item_name'=>$req['item_name'],'details'=>$req['details'],'quantity'=>$req['quantity'],'amount'=>$req['amount'],'total'=>$req['total']);
           
           }
           $model->requested_item=json_encode($ben);

          // var_dump($model->requested_item); 
           if(!$model->save())
           {
            var_dump($model->getErrors()); die;
           }
           
 
            if($model->save())
            {
                          
             return $this->redirect(['view', 'id' => $model->id]);               
            }
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Requisitions model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {      
       
       $flow_array=explode(',', $model->not_seen);       
       $model->status=$flow_array[0];
       $model->rejected=0;
       

        $ben=array();

           foreach($model->requested_item as $req)
           {
            echo $req['amount']; echo "<br>";
           echo $req['total']=$req['amount']*$req['quantity']; 
           echo "<br >";
           $ben[]=array('item_name'=>$req['item_name'],'details'=>$req['details'],'quantity'=>$req['quantity'],'amount'=>$req['amount'],'total'=>$req['total']);
           
           }
           $model->requested_item=$ben;

            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Requisitions model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }


    /**
     * Finds the Requisitions model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Requisitions the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Requisitions::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionViewrequisition($id,$doc)
    {
        $record=Requisitions::findOne($id);
        // var_dump($record); die;
        $doca=$record->instrument;
        $see=$record->status;
        return $this->render('view_requisition',['record'=>$record,'document'=>$doca,'see'=>$see]);
    }

      public function actionViewnotification($id,$doc)
    {
        $record=Requisitions::findOne($id);
        $doca=$record->instrument;
        $see=$record->status;

        $note=Notifications::find()->where(['=','notify',Yii::$app->user->identity->id])->all();
        foreach($note as $no)
        {
          $no->status=1;
          $no->save();
        }

        return $this->render('view_notification',['record'=>$record,'document'=>$doc,'see'=>$see]);
    }

    public function actionApprove($id,$doc)
    {
        $work=Requisitions::findOne($id); 
        $workflow=Workflow::findOne($work->workflow_id);
        $task=Tasks::findOne($workflow->task_id);
       // var_dump($task->finisher); die;
        $flows=explode(',', $workflow->int_workflow);
        $next_status='';
        $current_index=$work->current_index;
        $kept_index=$work->current_index;

        $documents=explode(',', $workflow->instrument);

        //$workflow=Workflow::findOne($record->workflow_id);
        $status_array=explode(',', $workflow->status_id);
        $show_what=$status_array[$work->current_index];

        $stamp=explode(',',$workflow->status_id);
        
      
      //  $index=array_search(Yii::$app->user->identity->id,$flows);
        $index=$current_index;
       
        if(isset($flows[$index+1]))
        {
            
            if($work->status==$work->raised_by)
            {
              $next_status=$flows[0];
            }else{
              $next_status=$flows[$index+1];
            }
            
        }else{
            //$next_status=$work->raised_by;
            $next_status=$flows[$kept_index];
            $work->concluded=1;

        }


       
        $next_doc='';

        //$index_doc=array_search($doc,$documents);
        $index_doc=$current_index;

        if(isset($documents[$index_doc+1]))
        {
           
           
             if($work->status==$work->raised_by)
            {              
              $next_doc=$documents[0];
            }else{
               $next_doc=$documents[$index_doc+1];
               $current_index+=1;
            }

        }else{
            $next_doc=$documents[$kept_index];
           // $work->concluded=1;
        }


        $hop=json_decode($work->requested_item,true);        
        $vendor=Vendors::findOne($hop[0]['vendor'])->name;
        $mike=$hop[0]['vendor'];

        $hop2=json_decode($work->requested_item,true); 
        $customer=$hop2[0]['customer_name'];


        $total=0;
        $goods='';
        $qty=0;
        $qty2=0;

        if($work->dsender_id==null && $stamp[$kept_index] == 5)
        { //die('dsender is null');
            foreach(json_decode($work->requested_item,true) as $item)
            {
                $total+=$item['total'];
                $goods.=$item['item_name'].', ';
                $qty+=$item['quantity'];
                $qty2=$item['quantity'];
                

                if($work->task_type==3)
                  //if($work->task_type==3 && $show_what==3)
                {
                    $row11=explode(',', $workflow->status_id);
                    $row22=explode(',', $workflow->int_workflow);
                    $reid=array_search(5, $row11);
                  $rere=$row22[$reid];

                  $uti=Stores::findOne($item['item_id']);

                    $storeh=new StoresHistory();
                    $storeh->name=$uti->name;
                    $storeh->cid=$uti->cid;
                    $storeh->units=$uti->units;
                    $storeh->standing_quantity=$uti->quantity;
                    $storeh->particulars=$uti->particulars;
                   // $storeh->received_date=date('Y-m-d');
                    // $storeh->recieved_by=$uti->recieved_by;
                    $storeh->recieved_by=$rere;
                    $storeh->transaction_id=$uti->transaction_id;
                    $storeh->balance=$uti->balance;
                    $storeh->transaction_quantity=$qty2;
                    $storeh->type=11;
                    $storeh->issued_date=date('Y-m-d');
                    $storeh->description=$uti->description;
                    
                    $storeh->issued_by=Yii::$app->user->identity->id;
                    $storeh->given_to=$uti->given_to;
                    $storeh->item_id=$item['item_id'];
                    if(!$storeh->save())
                        {
                            var_dump($storeh->getErrors()); die;
                        }


                                  $checkit=Transfers::find()->where(['=','reciever_id',$work->raised_by])->andWhere(['=','item_id',$item['item_id']])->one();
                                  if($checkit==null)
                                  {

$row11=explode(',', $workflow->status_id);
                    $row22=explode(',', $workflow->int_workflow);
                    $reid=array_search(5, $row11);
                  $rere=$row22[$reid];


                                  $move=new Transfers();
                                  $move->cid=Yii::$app->user->identity->cid;
                                  $move->sender_id=Yii::$app->user->identity->id;
                                  $move->reciever_id=$rere;
                                  $move->item_id=$item['item_id'];
                                  $move->item_name=$item['item_name'];
                                  $move->quantity=$qty2;
                                  $move->units=$uti->units;
                                  $move->created_at=date('Y-m-d H:i:s');
                                  if(!$move->save())
                                  {
                                    var_dump($move->getErrors()); die;
                                  }

                                }else{
                                  $checkit->quantity+=$qty2;
                                  $checkit->save();
                                }

                    // $th=new TransfersHistory();
                    // $th->cid=Yii::$app->user->identity->cid;
                    // $th->sender_id=Yii::$app->user->identity->id;
                    // $th->reciever_id=$work->raised_by;
                    // $th->item_id=$item['item_id'];
                    // $th->item_name=$item['item_name'];
                    // $th->quantity=$qty2;
                    // $th->created_at=date('Y-m-d H:i:s');
                    // if(!$th->save())
                    // {
                    //   var_dump($th->getErrors()); die;
                    // }
                    
                    
                    
                    $uti->quantity=($uti->quantity-$qty2);
                    if(!$uti->save())
                    {
                        var_dump($uti->getErrors()); die;
                    }
                }

                        
                                    
            }

          }else{
              // run code if sender_id is not null
            // die('dsender is not null at all');
            if($stamp[$kept_index] == 5 && $work->dsender_id!=null)
            {
            foreach(json_decode($work->requested_item,true) as $item)
            {
                $total+=$item['total'];
                $goods.=$item['item_name'].', ';
                $qty+=$item['quantity'];
                $qty2=$item['quantity'];
                

                if($work->task_type==3)
                  //if($work->task_type==3 && $show_what==3)
                {  
                  $row11=explode(',', $workflow->status_id);
                    $row22=explode(',', $workflow->int_workflow);
                    $reid=array_search(5, $row11);
                  $rere=$row22[$reid];

                    $uti=Transfers::find()->where(['=','item_id',$item['item_id']])->andWhere(['=','reciever_id',$work->dsender_id])->one();
                    // var_dump($uti); die;
                    $store=Stores::findOne($item['item_id']);
                    $store->quantity+=$qty2;
                    $store->save();

                    $storeh=new StoresHistory();
                    $storeh->name=$uti->item_name;
                    $storeh->cid=$uti->cid;
                   // $storeh->units=$uti->units;

                    $storeh->standing_quantity=$uti->quantity;
                   $storeh->particulars='Transfers';
                   // $storeh->received_date=date('Y-m-d');
                    // $storeh->recieved_by=$uti->recieved_by;
                    $storeh->recieved_by=$rere;
                    $storeh->transaction_id='Transfer';
                   // $storeh->balance=$uti->balance;
                    $storeh->transaction_quantity=$qty2;
                    $storeh->issued_date=date('Y-m-d');
                    $storeh->item_id=$item['item_id'];
                    $storeh->type=12;
                   // $storeh->description=$uti->description;
                    
                    $storeh->issued_by=Yii::$app->user->identity->id;
                    $storeh->given_to=$work->raised_by;
                    if(!$storeh->save())
                        {
                            var_dump($storeh->getErrors()); die;
                        }


                  //   $checkit=Transferhs::find()->where(['=','reciever_id',$work->raised_by])->andWhere(['=','item_id',$item['item_id']])->one();
                  //   if($checkit==null)
                  //   {

                  //   // $move=new Transfers();
                  //   // $move->cid=Yii::$app->user->identity->cid;
                  //   // $move->sender_id=Yii::$app->user->identity->id;
                  //   // $move->reciever_id=$work->raised_by;
                  //   // $move->item_id=$item['item_id'];
                  //   // $move->item_name=$item['item_name'];
                  //   // $move->quantity=$qty2;
                  //   // $move->created_at=date('Y-m-d H:i:s');
                  //   // if(!$move->save())
                  //   // {
                  //   //   var_dump($move->getErrors()); die;
                  //   // }

                  // }else{
                  //   $checkit->quantity+=$qty2;
                  //   $checkit->save();
                  // }
                    $sent=User::find()->where(['role'=>'Store Manager'])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one()->id;

$row11=explode(',', $workflow->status_id);
                    $row22=explode(',', $workflow->int_workflow);
                    $reid=array_search(5, $row11);
                  $rere=$row22[$reid];

                    $th=new TransfersHistory();
                    $th->cid=Yii::$app->user->identity->cid;
                    $th->sender_id=$sent;
                    $th->reciever_id=$rere;
                    $th->item_id=$item['item_id'];
                    $th->item_name=$item['item_name'];
                    $th->quantity=$qty2;
                    $th->created_at=date('Y-m-d H:i:s');
                    if(!$th->save())
                    {
                      var_dump($th->getErrors()); die;
                    }
                    
                    
                    
                    $uti->quantity=($uti->quantity-$qty2);
                    if(!$uti->save())
                    {
                        var_dump($uti->getErrors()); die;
                    }
                }

                        
                                    
            }
          }
            } // close if dsender is not null
            //echo $total."<br >".$goods."<br>".$qty; die;
           
           // echo $stamp[$kept_index]; die('stampped');
            // $leg=Ledger::find(1)->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','open',7])->one(); 
             $leg=Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
             if(count($leg)==0)
             {
                ?>
<script type="text/javascript"> alert('You have not entered an opening balance!'); return; </script>
                <?php die('You have not set an opening balance');
             }  
    
//echo $documents[$kept_index].' and '.Yii::$app->user->identity->position; die;

         if(($documents[$kept_index]==9) && $stamp[$kept_index] == 4) // if this document is invoice and logged in user is finisher
        //if(($documents[$kept_index]==9) && (Yii::$app->user->identity->position==1))
          
        {
            $transaction = Yii::$app->db->beginTransaction();
 try {
            //document or instrument is an invoice so credit ledger


                foreach(json_decode($work->requested_item,true) as $item)
            {
                $total+=$item['total'];
                // $goods.=$item['item_name'].', ';
                // $qty+=$item['quantity'];
                // $qty2=$item['quantity'];

            }

          
            if(count($leg)>0)
            {
                $ledger= new Ledger();
                $ledger->debit=0;
                $ledger->credit=$total;
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date('Y-m-d');
                $ledger->transaction_id=$work->transaction_id; 
                $ledger->vendor=$customer;   
                $ledger->amount_paid=$item['amount_paid'];   
                $ledger->description="Income";
                $ledger->ptype=1;
                if(!$ledger->save())
                {
                    //var_dump($ledger->getErrors()); die;
                    throw new \Exception( 'could not save to ledger' );  
                }
            }else{ echo count($leg);
                die('An opening balance has not been set!');
            }


            // send notifications
            $dnotice=explode(',', $workflow->notices);
            if(count($dnotice)>0 && $dnotice[0]!=Null){
              
                
                foreach($dnotice as $note)
                {
                    $notify= new Notifications();                
                    $notify->cid=Yii::$app->user->identity->cid;
                    $notify->notify=$note;
                    $notify->link=$work->transaction_id;                
                    $notify->action_by=Yii::$app->user->identity->id;
                    $notify->req_id=$work->id;
                    $notify->doc_id=$work->instrument;
                    $notify->workflow_id=$work->workflow_id;
                    $notify->concluded=$work->concluded;
                    $notify->rejected=$work->rejected;
                    $notify->message=$total."  has been recieved by ".User::findOne(Yii::$app->user->identity->id)->last_name;    
                      if(!$notify->save())
                    {
                        throw new \Exception( 'could not save notification' );  
                        //var_dump($notify->getErrors()); die;

                    }
                }  
                 }             
                // var_dump($work->requested_item); die;
       
         //  } // close if x == 0 for finisher

            $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }
                    
                }

                // carry out movement of goods on recivers click

            if($stamp[$kept_index] == 5 && $work->task_type==2)
            {
          $transaction = Yii::$app->db->beginTransaction();
 try 
 {
            foreach(json_decode($work->requested_item,true) as $item)
            {
                $total+=$item['total'];
                $goods.=$item['item_name'].', ';
                $qty+=$item['quantity'];
                $qty2=$item['quantity'];
               

                // if($work->task_type==2 && $show_what==3)
                // {
                    $uti=Inventory::findOne($item['id']);
                    if($uti->countable==1)
                    {
                    $uti->quantity-=$qty2;
                    }
                                       
                    
                    if(!$uti->save())
                    {
                        throw new \Exception( 'could not save inventory' ); 
                        var_dump($uti->getErrors()); die;
                    }
               // } 


                    $shoph=new ShopHistory();                   
                    $shoph->cid=Yii::$app->user->identity->cid;
                    $shoph->name=$item['item_name'];                                      
                    $shoph->quantity=$item['quantity'];
                     
                    $shoph->price=0;  
                    $shoph->staff=Yii::$app->user->identity->id;
                   // $storeh->received_date=date('Y-m-d');                  
                    $shoph->created_at=date('Y-m-d');                   
                    $shoph->item_id=$item['id'];
                    $shoph->issued_by=Yii::$app->user->identity->id;
                    $shoph->received_by=$work->raised_by;
                    $shoph->type=2;
                    $shoph->transaction_id=$work->transaction_id;
                    $shoph->countable=0;


                    if(!$shoph->save())
                        {
                             var_dump($shoph->getErrors());
                             throw new \Exception( 'could not save to shop history' ); 
                              die;
                        }

              }

                $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }
                }







           if($documents[$kept_index]==4 && $stamp[$kept_index]==4) // if this document is a payment voucher and logged in user is finisher
        {
             // document or instrument is purchase order debit   



           $transaction = Yii::$app->db->beginTransaction();
 try {
            
             foreach(json_decode($work->requested_item,true) as $item)
            {
                $total+=$item['total'];
                // $goods.=$item['item_name'].', ';
                // $qty+=$item['quantity'];
                // $qty2=$item['quantity'];
                
              }

                if(count($leg)>0)
            {
                $ledger= new Ledger();
                $ledger->debit=$total;
                $ledger->credit=0;
                $ledger->department=Yii::$app->user->identity->department;
                $ledger->cid=Yii::$app->user->identity->cid;
                $ledger->created_at=date('Y-m-d');
                $ledger->transaction_id=$work->transaction_id;            
                $ledger->description="Expenditure";  
                $ledger->vendor=$mike;  
                $ledger->ptype=2;       
                if(!$ledger->save())
                {
                  throw new \Exception( 'could not save to ledger' ); 
                }
            }else{
               die('An opening balance has not been set!');
            }

             $dnotice=explode(',', $workflow->notices);
             if(count($dnotice)>0 && $dnotice[0]!=Null){
                foreach($dnotice as $note)
                {
                    $notify= new Notifications();                
                    $notify->cid=Yii::$app->user->identity->cid;
                    $notify->notify=$note;
                    $notify->link=$work->transaction_id;                
                    $notify->action_by=Yii::$app->user->identity->id;
                    $notify->req_id=$work->id;
                    $notify->doc_id=$work->instrument;
                    $notify->workflow_id=$work->workflow_id;
                    $notify->concluded=$work->concluded;
                    $notify->rejected=$work->rejected;
                    $notify->message=$total."  has been disbursed by ".User::findOne(Yii::$app->user->identity->id)->last_name;    
                    if(!$notify->save())
                    {
                        //var_dump($notify->getErrors()); die;
                      throw new \Exception( 'could not save notification' ); 
                    }
                }

                }       
              

          
            // } // close if last occurence of finisher in 
               $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }
        }


        // do reciever moves

        if($stamp[$kept_index] == 5 && $work->task_type==1)
        {

           $transaction = Yii::$app->db->beginTransaction();
 try {
          foreach(json_decode($work->requested_item,true) as $item)
            {
                $total+=$item['total'];
                $goods.=$item['item_name'].', ';
                $qty+=$item['quantity'];
                $qty2=$item['quantity'];

                if($work->task_type==1)
                {
                    $uti=Stores::findOne($item['item_id']);

                    if($uti->countable==1)
                     {
                    $uti->quantity+=$qty2;
                                       
                    
                    if(!$uti->save())
                    {
                        //var_dump($uti->getErrors()); die;
                      throw new \Exception('could not save to store' ); 
                    }
                      }
                }


                 if($work->task_type==1 && $stamp[$kept_index] == 5)
                {
                   $row11=explode(',', $workflow->status_id);
                    $row22=explode(',', $workflow->int_workflow);
                    $reid=array_search(5, $row11);
                  $rere=$row22[$reid];

                  $uti=Stores::findOne($item['item_id']);

                    $storeh=new StoresHistory();
                    $storeh->name=$uti->name;
                    $storeh->cid=$uti->cid;
                    $storeh->units=$uti->units;
                    $storeh->standing_quantity=$uti->quantity;
                    $storeh->particulars=$uti->particulars;
                   // $storeh->received_date=date('Y-m-d');
                    // $storeh->recieved_by=$uti->recieved_by;
                    $storeh->recieved_by=$rere;
                    $storeh->transaction_id=$uti->transaction_id;
                    $storeh->balance=$uti->balance;
                    $storeh->transaction_quantity=$qty2;
                    $storeh->issued_date=date('Y-m-d');
                    $storeh->description=$uti->description;
                    $storeh->vendor=$hop[0]['vendor'];
                    $storeh->type=12;
                    
                    $storeh->issued_by=Yii::$app->user->identity->id;
                    $storeh->given_to=$uti->given_to;
                    $storeh->item_id=$uti->id;
                    if(!$storeh->save())
                        {
                            throw new \Exception('could not save to store' ); 
                            var_dump($storeh->getErrors()); die;
                        }
 
                      }
              }
            // } // close if last occurence of finisher in 
               $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }

        }


        // start the product transfer


        $total=0;
        $goods='';
        $qty=0;
        $qty2=0;

        if($stamp[$kept_index] == 5 && $work->task_type==5)
        { 
            foreach(json_decode($work->requested_item,true) as $item)
            {
               // $total+=$item['total'];
                $goods.=$item['item_name'].', ';
                $qty+=$item['quantity'];
                $qty2=$item['quantity'];
                

                if($work->task_type==5)
                  //if($work->task_type==3 && $show_what==3)
                {
                    $uti=Inventory::find()->where(['item_id'=>$item['item_id']])->one();
                    $baba=Productions::find()->where(['item_id'=>$item['item_id']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
                    $baba->quantity-=$qty2;
                    if(!$baba->save())
                    {
                      var_dump($baba->getErrors()); die;
                    }

                    //$uti->quantity=($uti->quantity-$qty2);
                    $uti->quantity+=$qty2;
                    if(!$uti->save())
                    {
                        var_dump($uti->getErrors()); die;
                    }
                }

                 // shop history

                  $shoph=new ShopHistory();                   
                    $shoph->cid=Yii::$app->user->identity->cid;
                    $shoph->name=$item['item_name'];                                      
                    $shoph->quantity=$item['quantity'];
                     
                    $shoph->price=0;  
                    $shoph->staff=Yii::$app->user->identity->id;
                   // $storeh->received_date=date('Y-m-d');                  
                    $shoph->created_at=date('Y-m-d');                   
                    $shoph->item_id=$item['item_id'];
                    $shoph->issued_by=Yii::$app->user->identity->id;
                    $shoph->received_by=$work->raised_by;
                    $shoph->type=1;
                    $shoph->transaction_id=$work->transaction_id;
                    $shoph->countable=0;


                    if(!$shoph->save())
                        {
                            var_dump($shoph->getErrors()); die;
                        }       
                                    
            }

          }


           if($work->task_type==6 && $stamp[$kept_index]==5)
                 
                {

                    $transaction = Yii::$app->db->beginTransaction();
 try {
                   foreach(json_decode($work->requested_item,true) as $item)
                  {                   
                    // $goods.=$item['item_name'].', ';
                    // $qty+=$item['quantity'];
                    // $qty2=$item['quantity'];
                    if($item['flow']==1){
                    $checkit=Inventory::find()->where(['item_id'=>$item['item_id']])->one();

                    if($checkit==null)
                    {
                      $go = new Inventory();
                      $go->name=$item['item_name'];
                      $go->item_id=$item['item_id'];
                      $go->cid=Yii::$app->user->identity->cid;
                      $go->quantity=$item['quantity'];
                      $go->staff=Yii::$app->user->identity->id;
                      $go->description=$item['description'];
                      $go->countable=0;
                      $go->price=0;
                      $go->countable=$item['countable'];
                      $go->created_at=date("Y-m-d H:i:s");
                      $go->save();
                    }else{
                      $checkit->quantity+=$item['quantity'];
                      if(!$checkit->save())
                      {
                        throw new \Exception('could not save to inventory' ); 
                      }
                    }

                    $store=Stores::findOne($item['item_id']);
                    $store->quantity-=$item['quantity'];
                    if(!$store->save())
                    {
                      throw new \Exception('could not save to store' ); 
                    }
                  }


                         // record stuff in shop history

                    $shoph=new ShopHistory();                   
                    $shoph->cid=Yii::$app->user->identity->cid;
                    $shoph->name=$item['item_name'];                                      
                    $shoph->quantity=$item['quantity'];
                     
                    $shoph->price=0;  
                    $shoph->staff=Yii::$app->user->identity->id;
                   // $storeh->received_date=date('Y-m-d');                  
                    $shoph->created_at=date('Y-m-d');                   
                    $shoph->item_id=$item['item_id'];
                    $shoph->issued_by=Yii::$app->user->identity->id;
                    $shoph->received_by=$work->raised_by;
                    $shoph->type=1; // increasing shop quantity
                    $shoph->transaction_id=$work->transaction_id;
                    $shoph->countable=0;


                    if(!$shoph->save())
                        {
                           throw new \Exception('could not save to shop history' ); 
                            var_dump($shoph->getErrors()); die;
                        }


                        // store history
                        $row11=explode(',', $workflow->status_id);
                    $row22=explode(',', $workflow->int_workflow);
                    $reid=array_search(5, $row11);
                  $rere=$row22[$reid];


                    $storeh=new StoresHistory();
                    $storeh->name=$item['item_name'];
                    $storeh->cid=Yii::$app->user->identity->cid;
                    $storeh->units='store to shop';
                    $storeh->standing_quantity=$item['quantity'];
                    $storeh->particulars='store to shop';
                   // $storeh->received_date=date('Y-m-d');
                    // $storeh->recieved_by=$uti->recieved_by;
                    $storeh->recieved_by=$rere;
                    $storeh->transaction_id=$work->transaction_id;
                    $storeh->balance=$item['quantity'];
                    $storeh->transaction_quantity=$item['quantity'];
                    $storeh->issued_date=date('Y-m-d');
                    $storeh->description=$uti->description;
                    
                    $storeh->type=11; //reducing store
                    
                    $storeh->issued_by=Yii::$app->user->identity->id;
                    $storeh->given_to=Yii::$app->user->identity->id;
                    $storeh->item_id=$item['item_id'];
                    if(!$storeh->save())
                        { 
                           throw new \Exception('could not save to store history' ); 
                            var_dump($storeh->getErrors()); die;
                        }
 
                   

                  }

                     $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }

                }


        // end the product transfer


        $work->status=$next_status;
        $work->rejected=0;
        $work->instrument=$next_doc;
        $work->current_index=$current_index;
        $work->save();

        // $dnotice=explode(',', $workflow->notices);
        // foreach($dnotice as $note)
        // {
        //     $notify= new Notifications();                
        //     $notify->cid=Yii::$app->user->identity->cid;
        //     $notify->notify=$note;
        //     $notify->link=$work->transaction_id;                
        //     $notify->action_by=Yii::$app->user->identity->id;
        //     $notify->message='Requisition approved';    
        //     if(!$notify->save())
        //     {
        //         var_dump($notify->getErrors()); die;
        //     }
        // }
       


        return $this->redirect(['requisitions/viewrequisition','id'=>$id,'doc'=>$doc]);
    }



    public function actionDecline($id,$doc)
    {
         $work=Requisitions::findOne($id); 
         $workflow=Workflow::findOne($work->workflow_id);


        $flows=explode(',', $workflow->int_workflow);
        $next_status='';
       // var_dump($flows); die;
        $current_index=$work->current_index;
        $kept_index=$work->current_index;
        //$index=array_search(Yii::$app->user->identity->id,$flows);
        //echo $index; echo " added ".$flows[$index+1]; 
        $index=$current_index;
        if(isset($flows[$index-1]))
        {
           $next_status=$flows[$index-1];
          
           
        }else{
         $next_status=$flows[$kept_index];
        }
      // echo  Yii::$app->user->identity->id;
       // echo " next status is ".($index-1); die;

        $documents=explode(',', $workflow->instrument);
        $next_doc='';

        //$index_doc=array_search($doc,$documents);
        $index_doc=$current_index;

        if(isset($documents[$index_doc-1]))
        {
            $next_doc=$documents[$index_doc-1];
             $current_index-=1;
        }else{
            $next_doc=$documents[$kept_index];
           // $work->concluded=1;

        }

        $work->status=$next_status;
        $work->rejected=1;
        $work->instrument=$next_doc;
        $work->current_index=$current_index;
        $work->save();

        // $notify= new Notifications();
        // $notify->to_be_notified=$work->raised_by.','.$work->not_seen;
        // $notify->cid=$work->workflow_id;
        // $notify->document_id=$work->id;
        // $notify->transaction_id=$work->transaction_id;
        // $notify->action_taken_by=Yii::$app->user->identity->id;
        // $notify->notification_details=RequisitionTypes::findOne($work->requisition_type)->requisition_type;
        
        // $notify->is_approved=0;
        // if(!$notify->save())
        // {
        //     var_dump($notify->getErrors()); die;
        // }

        return $this->redirect(['requisitions/viewrequisition','id'=>$id,'doc'=>$doc]);
    }

 

    public function actionDecline2()
    {
         
            //var_dump(Yii::$app->request->get()); die;

            $id=Yii::$app->request->get('record_id');
            $doc=Yii::$app->request->get('instrumente');
            $message=Yii::$app->request->get('messager');

         $work=Requisitions::findOne($id); 
         $workflow=Workflow::findOne($work->workflow_id);


        $flows=explode(',', $workflow->int_workflow);
        $next_status='';
       // var_dump($flows); die;
        $current_index=$work->current_index;
        $kept_index=$work->current_index;
        //$index=array_search(Yii::$app->user->identity->id,$flows);
        //echo $index; echo " added ".$flows[$index+1]; 

        $index=$current_index;
   // if a requisition is rejected just send it back to originatior using line below
         $next_status=$work->raised_by;
       
      // echo  Yii::$app->user->identity->id;
       // echo " next status is ".($index-1); die;

        $documents=explode(',', $workflow->instrument);
        $next_doc='';

        //$index_doc=array_search($doc,$documents);
        $index_doc=$current_index;

       
        $next_doc=$documents[$kept_index];
      
        

        $work->status=$work->raised_by;
        $work->rejected=1;
        $work->instrument=$documents[0];
        $work->current_index=0;
        $work->save();

        $dnotice=explode(',', $workflow->notices);
        foreach($dnotice as $note)
        {
            $notify= new Notifications();                
            $notify->cid=Yii::$app->user->identity->cid;
            $notify->notify=$note;
            $notify->link=$work->transaction_id;                
            $notify->action_by=Yii::$app->user->identity->id;
            $notify->req_id=$work->id;
            $notify->doc_id=$work->instrument;
            $notify->workflow_id=$work->workflow_id;
            $notify->concluded=$work->concluded;
            $notify->rejected=$work->rejected;
            $notify->message='Requisition rejected';    
            if(!$notify->save())
            {
                var_dump($notify->getErrors()); die;
            }
        }


        // send message to person who raised requisition

         

        if(!empty($message))
            {
                $dim= new Messages();
                $dim->cid=Yii::$app->user->identity->cid;
                $dim->from_id=Yii::$app->user->identity->id;
                $dim->to_id=$work->raised_by;
                $dim->subject=$work->title.' Requisition rejected';
                $dim->message=$message;
                $dim->message_link=$work->transaction_id;
                if(!$dim->save())
                {
                    var_dump($dim->getErrors()); die;
                }               
            
            } 

       

        return $this->redirect(['requisitions/viewrequisition','id'=>$id,'doc'=>$doc]);
    }


    public function actionMyrequisitions()
    {
        $requisitions=Requisitions::find()->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','raised_by',Yii::$app->user->id])->orderBy('id desc')->all();
        return $this->render('my_requisitions',['requisitions'=>$requisitions]);
    }


    public function actionAllrequisitions()
    {
        $requisitions=Requisitions::find()->where(['=','cid',Yii::$app->user->identity->cid])->orderBy('id desc')->all();
        return $this->render('all_requisitions',['requisitions'=>$requisitions]);
    }


    public function actionRequisitiondetails($tid,$doc)
    {
        return $this->render('req_details',['doc'=>$doc,'tid'=>$tid]);
    }


    public function actionPnl()
    {
        if(isset($_POST['sent']))
        {

        $income = (new \yii\db\Query())
           // ->select(['id'])
            ->from('requisitions')
            ->where('id!=:sam', [':sam' => 0])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid])
            ->andWhere(['concluded'=>1]);
            if(!empty($_POST['from']) && !empty($_POST['to']))
            {
                $income=$income->andWhere(['between','SUBSTR(created_at,1,10)',$_POST['from'], $_POST['to']]);
            }
            $income=$income->andWhere('task_type=:tata', [':tata' =>2]) ;         
            

            $total=$income->all();

            $income=$income->groupBy('task_type');
            $income=$income->all();

            $total_income=0;
            $total_exp=0;
            $u=0;
            foreach($total as $req)
            {
                $sale=json_decode($req['requested_item'],true);
               
                $total_income+=$sale[$u]['total'];
                // var_dump($req);
                // $u++;
            }
           

        $k=0;
        $expenditure = (new \yii\db\Query())
           // ->select(['id'])
            ->from('requisitions')
            ->where('id!=:sam', [':sam' => 0])
            ->andWhere('cid=:po',[':po'=>Yii::$app->user->identity->cid])
            ->andWhere('task_type=:tata', [':tata' =>1])
            ->andWhere(['concluded'=>1]);

            if(!empty($_POST['from']) && !empty($_POST['to']))
            {
                $expenditure=$expenditure->andWhere(['between','SUBSTR(created_at,1,10)',$_POST['from'], $_POST['to']]);
            }

            $total_expense=$expenditure->all();

            $expenditure=$expenditure->groupBy('task_type');
            $expenditure=$expenditure->all();

             foreach($expenditure as $ex)
            {
                $expo=json_decode($ex['requested_item'],true);
               
                $total_exp+=$expo[$k]['total'];
                // var_dump($req);
                // $u++;
            }

        }
          

        return $this->render('pnl',['income'=>$income,'expenditure'=>$expenditure,'total_income'=>$total_income,'total_exp'=>$total_exp]);
    }

    public function actionAttentionrequired()
    {
        $requisitions=Requisitions::find()->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','status',Yii::$app->user->identity->id])->andWhere(['=','concluded',0])->andWhere(['=','rejected',0])->orderBy('id desc')->all();
        return $this->render('list_requisitions',['requisitions'=>$requisitions]);        
    }

    public function actionAllrejections()
    {
        $requisitions=Requisitions::find()->where(['=','cid',Yii::$app->user->identity->cid])->andWhere(['=','status',Yii::$app->user->identity->id])->andWhere(['!=','concluded',1])->andWhere(['=','rejected',1])->orderBy('id desc')->all();
        return $this->render('allrejections',['requisitions'=>$requisitions]);
    }

    public function actionAllnotifications()
    {
        $requisitions=Notifications::find()->where(['=','notify',Yii::$app->user->identity->id])->andWhere(['=','status',0])->all();       
        return $this->render('allnotifications',['requisitions'=>$requisitions]);        
    }


    public function actionOutflow()
    {
      return $this->render('outflow');
    }


 
   public function actionDecline2_kept()
    {
         
            //var_dump(Yii::$app->request->get()); die;

            $id=Yii::$app->request->get('record_id');
            $doc=Yii::$app->request->get('instrumente');
            $message=Yii::$app->request->get('messager');

         $work=Requisitions::findOne($id); 
         $workflow=Workflow::findOne($work->workflow_id);


        $flows=explode(',', $workflow->int_workflow);
        $next_status='';
       // var_dump($flows); die;
        $current_index=$work->current_index;
        $kept_index=$work->current_index;
        //$index=array_search(Yii::$app->user->identity->id,$flows);
        //echo $index; echo " added ".$flows[$index+1]; 
        
        $index=$current_index;
        if(isset($flows[$index-1]))
        {
           $next_status=$flows[$index-1];
          
           
        }else{
         $next_status=$flows[$kept_index];
        }
      // echo  Yii::$app->user->identity->id;
       // echo " next status is ".($index-1); die;

        $documents=explode(',', $workflow->instrument);
        $next_doc='';

        //$index_doc=array_search($doc,$documents);
        $index_doc=$current_index;

        if(isset($documents[$index_doc-1]))
        {
            $next_doc=$documents[$index_doc-1];
             $current_index-=1;
        }else{
            $next_doc=$documents[$kept_index];
            // $next_doc=$work->raised_by;
           // $work->concluded=1;

        }

        $work->status=$work->raised_by;
        $work->rejected=1;
        $work->instrument=$next_doc;
        $work->current_index=$current_index;
        $work->save();

        $dnotice=explode(',', $workflow->notices);
        foreach($dnotice as $note)
        {
            $notify= new Notifications();                
            $notify->cid=Yii::$app->user->identity->cid;
            $notify->notify=$note;
            $notify->link=$work->transaction_id;                
            $notify->action_by=Yii::$app->user->identity->id;
            $notify->req_id=$work->id;
            $notify->doc_id=$work->instrument;
            $notify->workflow_id=$work->workflow_id;
            $notify->concluded=$work->concluded;
            $notify->rejected=$work->rejected;
            $notify->message='Requisition rejected';    
            if(!$notify->save())
            {
                var_dump($notify->getErrors()); die;
            }
        }


        // send message to person who raised requisition

         

        if(!empty($message))
            {
                $dim= new Messages();
                $dim->cid=Yii::$app->user->identity->cid;
                $dim->from_id=Yii::$app->user->identity->id;
                $dim->to_id=$work->raised_by;
                $dim->subject=$work->title.' Requisition rejected';
                $dim->message=$message;
                $dim->message_link=$work->transaction_id;
                if(!$dim->save())
                {
                    var_dump($dim->getErrors()); die;
                }               
            
            } 

       

        return $this->redirect(['requisitions/viewrequisition','id'=>$id,'doc'=>$doc]);
    }

    public function actionLand()
    {
      return $this->render('land');
    }

    public function actionEditr()
    {
      // $details=Yii::$app->request->post('details'); 
      // $quantity=Yii::$app->request->post('quantity'); 
      // $amount=Yii::$app->request->post('amount'); 
      // $all=array_merge($details,$quantity,$amount);
      if(Yii::$app->request->post()){

      $posts=Yii::$app->request->post(); 

//       for($x=0; $x<count($posts['item_id']); $x++)
// {

//            $total+=$posts['quantity'][$x]*$posts['amount'][$x];
// }

for($x=0; $x<count($posts['item_id']); $x++)
{
  $total=0;
$total+=$posts['quantity'][$x]*$posts['amount'][$x];
             if(empty($posts['customer']))
             {
                 $item[]=array('total'=>$total,'amount'=>$posts['amount'][$x],'details'=>$posts['details'][$x],'quantity'=>$posts['quantity'][$x],'item_name'=>$posts['item_name'][$x],'item_id'=>$posts['item_id'][$x],'id'=>$posts['item_id'][$x]);
             }else{
                 $item[]=array('total'=>$total,'amount'=>$posts['amount'][$x],'details'=>$posts['details'][$x],'quantity'=>$posts['quantity'][$x],'item_name'=>$posts['item_name'],'item_id'=>$posts['item_id'][$x],'customer_name'=>$posts['customer'],'id'=>$posts['item_id'][$x]);
             }

            

            // echo $posts['details'][$x];
  // echo "<pre>";
  // var_dump($post);
  // echo "</pre>";
}

 $point=Requisitions::findOne($posts['rec_id']);
             $point->requested_item=json_encode($item);
             if(!$point->save())
             {
              var_dump($point->getErrors()); die;
             }else{
              echo "its done ".$posts['rec_id'];
              return $this->redirect(['viewrejections','id'=>$posts['rec_id'], 'doc'=>9]);
             }

      }
      
    //  var_dump($posts);
    
      //return $this->render('editr');
    }


    public function actionViewrejections($id,$doc)
    {
        $record=Requisitions::findOne($id);
        // var_dump($record); die;
        $doca=$record->instrument;
        $see=$record->status;
        return $this->render('view_rejections',['record'=>$record,'document'=>$doca,'see'=>$see]);
    }

    public function actionEdelete()
    {
      $id=Yii::$app->request->post('rec_id');
      $rec=Requisitions::findOne($id)->delete();
      return $this->redirect(['allrejections']);
    }

    
}
