<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Stores;
use frontend\models\SearchStores;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\models\StoresHistory;
use yii\filters\AccessControl;

/**
 * StoresController implements the CRUD actions for Stores model.
 */
class StoresController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
           'access' => [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','findModel','itemdetails'],
                    'roles' => ['@'],
                ],
                  [
                    'allow' => true,
                    'actions' => ['sledger'],
                    'roles' => ['Store Manager','Client Admin'],
                ],
                 [
                    'allow' => true,
                    'actions' => ['sledger','delete','create','update'],
                    'roles' => ['Client Admin'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Stores models.
     * @return mixed
     */
    public function actionIndex()
    {
        if(Yii::$app->user->identity->role!='Client Admin')
        {
            die('You are not allowed to do this');
        }
        
        $searchModel = new SearchStores();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Stores model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Stores model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Stores();

        if ($model->load(Yii::$app->request->post())) {
            $model->transaction_id=time().rand(10,20);
            $model->name=ucwords($model->name);
            $model->balance=$model->quantity; 
            $model->issued_by=Yii::$app->user->identity->id;         

            if(!$model->save())
            {
                var_dump($model->getErrors()); die;
            }

            // enter into store history

            $storeh=new StoresHistory();
                    $storeh->name=$model->name;
                    $storeh->cid=Yii::$app->user->identity->cid;
                    $storeh->units=$model->units;
                    $storeh->standing_quantity=$model->quantity;
                    $storeh->particulars=$model->particulars;
                   // $storeh->received_date=date('Y-m-d');
                    // $storeh->recieved_by=$uti->recieved_by;
                    $storeh->recieved_by=Yii::$app->user->identity->id;
                    $storeh->transaction_id='fresh'.date('Y-m-d');
                    $storeh->balance=$model->quantity;
                    $storeh->transaction_quantity=$model->quantity;
                    $storeh->issued_date=date('Y-m-d');
                    $storeh->description=$model->particulars;
                    $storeh->vendor=0;
                    $storeh->type=12;
                    
                    $storeh->issued_by=Yii::$app->user->identity->id;
                    $storeh->given_to=Yii::$app->user->identity->id;
                    $storeh->item_id=$model->id;
                    if(!$storeh->save())
                        {
                            //throw new \Exception('could not save to store' ); 
                            var_dump($storeh->getErrors()); die;
                        }


            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Stores model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            $model->name=ucwords($model->name);
            $model->issued_by=Yii::$app->user->identity->id;


            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Stores model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Stores model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Stores the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Stores::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionSledger()
    {
        $records=Stores::find()->where(['=','cid',Yii::$app->user->identity->cid])->all();
        return $this->render('sledger',['records'=>$records]);
    }

    public function actionItemdetails($id)
    {
        $history=StoresHistory::find()->where(['=','item_id',$id])->andWhere(['=','cid',Yii::$app->user->identity->cid])->all();
        return $this->render('item_details',['history'=>$history]);
    }
}
