<?php

namespace backend\controllers;

use Yii;
use backend\models\Departments;
use backend\models\SearchDepartments;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\Clients;
use yii\filters\AccessControl;

use yii\helpers\Html;
use backend\filters\AccessRule1;


/**
 * DepartmentsController implements the CRUD actions for Departments model.
 */
class DepartmentsController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
            'class' => AccessControl::className(),
            'ruleConfig' => [
                    'class' => AccessRule1::className(),
                ],
            'rules' => [
                [
                    'allow' => true,
                    'actions' => ['index','view','create','delete','update','findModel'],
                    'roles' => ['@'],
                ],
                    ],
                ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Departments models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new SearchDepartments();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'id'=>$id
            
        ]);
    }



    // public function actionIndex($id)
    // {
    //     $searchModel = new SearchDepartments(['cid'=>$id]);
    //     $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

    //     return $this->render('index', [
    //         'searchModel' => $searchModel,
    //         'dataProvider' => $dataProvider,
    //         'id'=>$id
            
    //     ]);
    // }

    /**
     * Displays a single Departments model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Departments model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Departments();
        $name=Clients::findOne($id)->client_name;


        if ($model->load(Yii::$app->request->post())) {

            // $check=Departments::find()->where(['authorizer'=>$model->authorizer])->one();
            // if($check->authorizer!=null)
            // {
            
            //     die('This user has already been assigned head of a Departments. Please pick another user. Click '.Html::a(' HERE ', ['create','id'=>$id], ['class' => 'btn btn-success']).' to continue');
            // }
            $model->department_name=ucwords($model->department_name);
            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }
        // if(!$model->save())
        // {
        //     var_dump($model->getErrors());
        // }

        return $this->render('create', [
            'model' => $model,
            'client_id'=>$id,
            'name'=>$name,
           // 'id'=>$id
        ]);
    }

    /**
     * Updates an existing Departments model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            $model->department_name=ucwords($model->department_name);
            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Departments model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Departments model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Departments the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Departments::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
