<?php
namespace backend\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\filters\AccessRule1;
use common\models\AdminLoginForm;
use backend\models\SignupForm;
use backend\models\ClientSignupForm;
use backend\models\Clients;
use backend\models\ResetPasswordFormA;
use backend\models\PasswordResetRequestFormA;
use common\models\Admin;
use backend\models\User;

/**
 * Site controller
 */
class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'ruleConfig' => [
                    'class' => AccessRule1::className(),
                ],
                'rules' => [
                    [
                        'actions' => ['signup','staffs','staff_update','dos_update','suspend','suspend2'],  
                        'allow' => true,                     
                        'roles' => ['admin'],
                        // 'roleParams' => ['postId' => Yii::$app->request->get('id')],
                    ],
                    [
                        'actions' => ['login', 'error','index','request-password-reset','reset-password'],
                        'allow' => true,
                        'roles'=>['?'],
                    ], 
                    [
                    'actions'=>['logout','clientsignup','regsuccess','changepass','index','error'],
                    'allow'=>true,
                    'roles' => ['@'],
                    ],                               
                    
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {
        
        return $this->render('index');
    }

    /**
     * Login action.
     *
     * @return string
     */
    public function actionLogin()
    {
        
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new AdminLoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
           // return $this->goBack();
            return $this->redirect(['clients/index']);
             // return $this->redirect(['requisitions/viewrequisition','id'=>$id,'doc'=>$doc]);

        } else {
            $model->password = '';

            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Logout action.
     *
     * @return string
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    public function actionSignup()
    {
        $model = new SignupForm();
        if ($model->load(Yii::$app->request->post())) {
            if ($user = $model->signup()) {
                // if (Yii::$app->getUser()->login($user)) {
                //     return $this->goHome();
                // }
                //echo "success";
                 return $this->redirect(['site/staffs','client'=>Yii::$app->request->post('cid')]);
            }
        }

        return $this->render('signup', [
            'model' => $model,
        ]);
    }



     public function actionClientsignup($id)
    {
        $model = new ClientSignupForm();
        $name=Clients::findOne($id)->client_name;
        //var_dump(Yii::$app->request->post()); die;
        if ($model->load(Yii::$app->request->post())) {
            if ($user = $model->clientsignup()) {

                // if (Yii::$app->getUser()->login($user)) {
                //     return $this->goHome();
                // }
                //echo "success";
                 return $this->redirect(['clients/viewusers','id'=>$id]);
            }
        }

        return $this->render('client_signup', [
            'model' => $model,
            'client_id'=>$id,
            'name'=>$name,
        ]);
    }

    public function actionRegsuccess($client)
    {
        return $this->render('regsuccess');
    }

    public function actionRequestPasswordReset()
    {
        // $this->layout='column1';
        $model = new PasswordResetRequestFormA();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            if ($model->sendEmail()) {
                Yii::$app->session->setFlash('success', 'Check your email for further instructions.');

                return $this->goHome();
            } else {
                Yii::$app->session->setFlash('error', 'Sorry, we are unable to reset password for the provided email address.');
            }
        }

        return $this->render('requestPasswordResetToken', [
            'model' => $model,
        ]);
    }

    /**
     * Resets password.
     *
     * @param string $token
     * @return mixed
     * @throws BadRequestHttpException
     */
    public function actionResetPassword($token)
    {
        // $this->layout='column1';
        try {
            $model = new ResetPasswordFormA($token);
        } catch (InvalidParamException $e) {
            throw new BadRequestHttpException($e->getMessage());
        }

        if ($model->load(Yii::$app->request->post()) && $model->validate() && $model->resetPassword()) {
            Yii::$app->session->setFlash('success', 'New password saved.');

            return $this->goHome();
        }

        return $this->render('resetPassword', [
            'model' => $model,
        ]);
    }

    public function actionChangepass()
    {
      if(Yii::$app->request->post())
      {
        $opass=Yii::$app->request->post('old_password');
        $npass=Yii::$app->request->post('new_password');
        $npassc=Yii::$app->request->post('confirm_new_password');
        // echo $opass; echo $npass; echo $npassc;
        $password=Yii::$app->user->identity->password_hash; 
        $hash=Yii::$app->getSecurity()->generatePasswordHash($npass);
        // echo $password; echo "<br>".$hash; die;
        // $dpass=password_hash($opass,PASSWORD_DEFAULT); echo $dpass; die;
        if(!Yii::$app->getSecurity()->validatePassword($opass,$password))
        {
          die('Your passwords do not match!');
        }
        if($npass!=$npassc)
        {
          die('New passwords do not match!');
        }

        $user=Admin::findOne(Yii::$app->user->identity->id);
        $user->password_hash=$hash;
        if(!$user->save())
        {
          var_dump($user->getErrors()); die;
        }
        Yii::$app->session->setFlash('success', 'New password saved.');
        return $this->redirect(['changepass']);
        
        
      }
      return $this->render('changepass');
    }

    public function actionStaffs()
    {
        $staffs=Admin::find()->all();
        return $this->render('staffs',['staffs'=>$staffs]);
    }

    public function actionStaff_update($id)
    {
        $model=Admin::find()->where(['id'=>$id])->one();     

        return $this->render('supdate',['model'=>$model]);
        
    }

    public function actionDos_update()
    {
        $id=Yii::$app->request->post('Admin')['id'];
        $model=Admin::findOne($id);
        
         if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            
            if($model->save())
            {
               
            // $auth = \Yii::$app->authManager; 
            // $auth->revokeAll($id);
            // $authorRole = $auth->getRole($model->role);
            // $auth->assign($authorRole, $model->id);
           
            }else{
              var_dump($model->getErrors()); die;   
            }

            return $this->redirect(['staffs']);
         }
         var_dump($model->getErrors());
    }

    public function actionSuspend($id,$cid)
    {
        $user=User::findOne($id);
        if($user->status==10)
        {
            $user->status=0;
        }elseif($user->status==0)
        {
            $user->status=10;
        }
        
        if(!$user->save())
        {
            var_dump($user->getErrors()); die;
        }
        return $this->redirect(['clients/viewusers','id'=>$cid]);
    }

     public function actionSuspend2($id)
    {
        $user=Admin::findOne($id);
        if($user->status==10)
        {
            $user->status=0;
        }elseif($user->status==0)
        {
            $user->status=10;
        }
        
        if(!$user->save())
        {
            var_dump($user->getErrors()); die;
        }
        return $this->redirect(['staffs']);
    }





  
}
